/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.psmlmanager;

import java.util.Iterator;
import org.apache.jetspeed.om.profile.QueryLocator;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.psmlmanager.PsmlManagerService;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.TurbineConfig;

public class PsmlImporter {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(PsmlImporter.class.getName());
    protected boolean check = true;

    public static void main(String[] args) {
        String msg;
        System.out.println("***** PSML Importer *****");
        boolean checkImport = true;
        try {
            String root = "./webapp";
            String properties = "/WEB-INF/conf/TurbineResources.properties";
            if (args.length > 0) {
                checkImport = args[0].equalsIgnoreCase("true");
            }
            if (args.length > 1) {
                root = args[1];
            }
            if (args.length > 2) {
                properties = args[2];
            }
            TurbineConfig config = new TurbineConfig(root, properties);
            config.init();
        }
        catch (Exception e) {
            String msg2 = "PSML Importer: error initializing Turbine configuration";
            logger.error(msg2, e);
            System.out.println(msg2);
            e.printStackTrace();
            System.exit(0);
        }
        PsmlManagerService exporterService = null;
        PsmlManagerService importerService = null;
        try {
            exporterService = (PsmlManagerService)TurbineServices.getInstance().getService("PsmlImportManager");
        }
        catch (InstantiationException e) {
            msg = "PSML Importer: error loading Psml Exporter Service";
            logger.error(msg, e);
            System.out.println(msg);
            e.printStackTrace();
            System.exit(0);
        }
        try {
            importerService = PsmlManager.getService();
        }
        catch (InstantiationException e) {
            msg = "PSML Importer: error loading Psml Importer Service";
            logger.error(msg, e);
            System.out.println(msg);
            e.printStackTrace();
            System.exit(0);
        }
        if (exporterService.getClass().getName().equals(importerService.getClass().getName())) {
            String msg3 = "PSML Importer Error: Importer Class cannot equal Exporter Class.";
            logger.error(msg3);
            System.out.println(msg3);
            System.exit(0);
        }
        PsmlImporter importer = new PsmlImporter();
        importer.setCheck(checkImport);
        boolean ran = importer.run(exporterService, importerService);
        if (ran) {
            System.out.println("**** PSML Importer - completed");
        }
        System.exit(1);
    }

    public boolean run(PsmlManagerService exporterService, PsmlManagerService importerService) {
        String msg;
        int count = 0;
        try {
            if (this.check && this.alreadyImported()) {
                return false;
            }
            msg = "Running with Importer Service: " + importerService.getClass();
            System.out.println(msg);
            logger.info(msg);
            msg = "Running with Exporter Service: " + exporterService.getClass();
            System.out.println(msg);
            logger.info(msg);
            QueryLocator locator = new QueryLocator(15);
            count = exporterService.export(importerService, locator);
        }
        catch (Exception e) {
            System.out.println("Error importing: " + e.toString());
            logger.error("Error importing: ", e);
            e.printStackTrace();
            return false;
        }
        msg = "PSMLImporter completed. Exported " + count + " profiles";
        System.out.println(msg);
        logger.info(msg);
        return true;
    }

    public boolean alreadyImported() {
        try {
            JetspeedUser user = JetspeedSecurity.getUser("admin");
            QueryLocator ql = new QueryLocator(1);
            ql.setUser(user);
            Iterator iterator = PsmlManager.query(ql);
            if (iterator.hasNext()) {
                String msg = "PSMLImporter: Detected database is populated. No need to import.";
                System.out.println(msg);
                logger.info(msg);
                return true;
            }
            return false;
        }
        catch (UnknownUserException e) {
            return false;
        }
        catch (JetspeedSecurityException e) {
            String msg = "Failed to run import: Database Access Error detecting database on import: ";
            logger.error(msg, (Throwable)((Object)e));
            System.out.println(msg + e.toString());
            return true;
        }
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    public boolean getCheck() {
        return this.check;
    }
}

