/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.profiler;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.commons.lang.SerializationUtils;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.om.profile.BasePSMLDocument;
import org.apache.jetspeed.om.profile.Control;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.QueryLocator;
import org.apache.jetspeed.om.profile.psml.PsmlControl;
import org.apache.jetspeed.om.profile.psml.PsmlController;
import org.apache.jetspeed.om.profile.psml.PsmlPortlets;
import org.apache.jetspeed.om.profile.psml.PsmlSkin;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.GroupRole;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.ServiceHelper;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.profiler.ProfilerService;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.MimeType;
import org.apache.jetspeed.util.PortletUtils;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;

public class JetspeedProfilerService
extends TurbineBaseService
implements ProfilerService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedProfilerService.class.getName());
    private static final String CONFIG_RESOURCE_DEFAULT = "resource.default";
    private static final String CONFIG_RESOURCE_EXT = "resource.ext";
    private static final String CONFIG_SECURITY = "security";
    private static final String CONFIG_ROLE_FALLBACK = "rolefallback";
    private static final String CONFIG_NEWUSER_TEMPLATE = "newuser.template";
    private static final String CONFIG_NEWUSER_MEDIA = "newuser.media_types";
    private static final String CONFIG_FALLBACK_LANGUAGE = "fallback.language";
    private static final String CONFIG_FALLBACK_COUNTRY = "fallback.country";
    private static final String CONFIG_FALLBACK_TO_ROOT = "fallback.to.root";
    private static final String CONFIG_ROLE_MERGE = "rolemerge";
    private static final String CONFIG_ROLE_MERGE_CONTROL = "rolemerge.control";
    private static final String CONFIG_ROLE_MERGE_CONTROLLER = "rolemerge.controller";
    private static final String DEFAULT_CONFIG_RESOURCE_DEFAULT = "default";
    private static final String DEFAULT_CONFIG_RESOURCE_EXT = ".psml";
    private static final boolean DEFAULT_CONFIG_SECURITY = false;
    private static final boolean DEFAULT_CONFIG_ROLE_FALLBACK = true;
    private static final String DEFAULT_CONFIG_NEWUSER_TEMPLATE = null;
    private static final String[] DEFAULT_CONFIG_NEWUSER_MEDIA = new String[]{"html", "wml"};
    private static final String DEFAULT_CONFIG_ROLE_MERGE_CONTROL = "TabControl";
    private static final String DEFAULT_CONFIG_ROLE_MERGE_CONTROLLER = "TabController";
    private static final String PATH_EXTENSION_DELIMITER = ".";
    private static final String MSG_MISSING_PARAMETER = "JetspeedProfilerService initialization failed. Missing parameter:";
    private Class profileClass = null;
    private Class locatorClass = null;
    String root;
    String resourceDefault;
    String resourceExt;
    String rolemergeControl;
    String rolemergeController;
    String newUserTemplate = DEFAULT_CONFIG_NEWUSER_TEMPLATE;
    boolean useSecurity = false;
    boolean useRoleFallback = true;
    boolean useFallbackLanguage = true;
    boolean useFallbackCountry = true;
    boolean useFallbackToRoot = false;
    boolean useRoleMerge = false;
    String[] mediaTypes = null;

    public Profile createProfile(RunData data, Profile profile) throws ProfileException {
        Profile current = null;
        CapabilityMap map = data == null ? CapabilityMapFactory.getDefaultCapabilityMap() : ((JetspeedRunData)data).getCapability();
        String mediaType = this.getMediaType(data, map);
        if (this.newUserTemplate == null) {
            return current;
        }
        if (this.mediaTypes != null) {
            for (int ix = 0; ix < this.mediaTypes.length; ++ix) {
                Profile dummy = this.createProfile(data, profile, this.mediaTypes[ix], this.newUserTemplate);
                if (!this.mediaTypes[ix].equalsIgnoreCase(mediaType)) continue;
                current = dummy;
            }
        }
        return current;
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        try {
            this.initConfiguration();
        }
        catch (Exception e) {
            logger.error("Profiler: Failed to load Service ", e);
        }
        this.setInit(true);
    }

    public void shutdown() {
    }

    public Profile getProfile(RunData data, CapabilityMap cm) throws ProfileException {
        JetspeedRunData rundata = (JetspeedRunData)data;
        Profile profile = this.fallbackProfile((RunData)rundata, cm);
        if (null == profile && this.useRoleFallback) {
            Vector<Profile> profiles = new Vector<Profile>();
            JetspeedUser user = rundata.getJetspeedUser();
            if (user != null) {
                try {
                    String paramRole = rundata.getParameters().getString("role");
                    Iterator groupRoles = JetspeedSecurity.getRoles(user.getUserName());
                    if (groupRoles != null) {
                        while (groupRoles.hasNext()) {
                            GroupRole gr = (GroupRole)groupRoles.next();
                            rundata.getParameters().setString("role", gr.getRole().getName());
                            profile = this.fallbackProfile((RunData)rundata, cm);
                            if (profile != null) {
                                profiles.add(profile);
                            }
                            rundata.getParameters().remove("role");
                        }
                        profile = this.mergeRoleProfiles(data, profiles);
                        if (profile == null) {
                            profile = this.fallbackProfile((RunData)rundata, cm);
                        }
                    }
                    rundata.getParameters().setString("role", paramRole);
                }
                catch (Exception e) {
                    logger.error("Error getting profile", e);
                    throw new ProfileException(e.toString());
                }
            }
        }
        return profile;
    }

    private Profile mergeRoleProfiles(RunData data, Vector profiles) throws Exception {
        Profile result = null;
        if (!this.useRoleMerge) {
            if (profiles.size() > 0) {
                result = (Profile)profiles.get(0);
            }
        } else if (profiles.size() > 0) {
            try {
                PsmlPortlets portlets = new PsmlPortlets();
                PsmlControl control = new PsmlControl();
                control.setName(this.rolemergeControl);
                portlets.setControl(control);
                PsmlController controller = new PsmlController();
                controller.setName(this.rolemergeController);
                portlets.setController(controller);
                PsmlSkin skin = new PsmlSkin();
                skin.setName(PortalToolkit.getSkin((String)null).getName());
                portlets.setSkin(skin);
                String mediaType = null;
                int paneCount = 0;
                for (Profile roleProfile : profiles) {
                    mediaType = mediaType == null ? roleProfile.getMediaType() : mediaType;
                    Profile tmpProfile = (Profile)roleProfile.clone();
                    Portlets tmpPortlets = tmpProfile.getDocument().getPortlets();
                    Control paneControl = tmpPortlets.getControl();
                    if (paneControl != null && paneControl.getName().equals(this.rolemergeControl)) {
                        for (int i = 0; i < tmpPortlets.getPortletsCount(); ++i) {
                            Portlets pane = tmpPortlets.getPortlets(i);
                            pane.setLayout(null);
                            portlets.addPortlets(pane);
                            ++paneCount;
                        }
                    } else {
                        if (tmpPortlets.getTitle() == null) {
                            String title = StringUtils.firstLetterCaps((String)roleProfile.getRoleName());
                            tmpPortlets.setTitle(title + " Home");
                        }
                        tmpPortlets.setLayout(null);
                        portlets.addPortlets(tmpPortlets);
                        ++paneCount;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Profiler: Processing profile for role " + roleProfile.getRoleName());
                }
                ProfileLocator locator = this.createLocator();
                locator.setUser((JetspeedUser)data.getUser());
                locator.setMediaType(mediaType);
                locator.setName(this.resourceDefault + this.resourceExt);
                PortletUtils.regenerateIds(portlets);
                result = this.createProfile(locator, portlets);
            }
            catch (Exception e) {
                logger.error("Exception", e);
            }
        }
        return result;
    }

    protected Profile fallbackProfile(RunData data, CapabilityMap cm) throws ProfileException {
        try {
            JetspeedRunData rundata = (JetspeedRunData)data;
            Profile profile = this.createProfile();
            JetspeedUser user = rundata.getJetspeedUser();
            profile.setMediaType(this.getMediaType((RunData)rundata, cm));
            String param = rundata.getParameters().getString("group");
            if (null != param) {
                profile.setGroup(JetspeedSecurity.getGroup(param));
            } else {
                param = rundata.getParameters().getString("role");
                if (null != param) {
                    if (user.hasLoggedIn()) {
                        profile.setRole(JetspeedSecurity.getRole(param));
                    } else {
                        profile.setAnonymous(true);
                        profile.setUser(user);
                    }
                } else {
                    param = rundata.getParameters().getString("user");
                    if (null != param) {
                        if (param.equals(JetspeedSecurity.getAnonymousUserName())) {
                            profile.setAnonymous(true);
                        }
                        if (user.getUserName().equals(param)) {
                            profile.setUser(user);
                        } else {
                            profile.setUser(JetspeedSecurity.getUser(param));
                        }
                    } else {
                        profile.setAnonymous(user.getUserName().equals(JetspeedSecurity.getAnonymousUserName()));
                        profile.setUser(user);
                    }
                }
            }
            StringBuffer resource = new StringBuffer();
            param = rundata.getParameters().getString("page");
            if (null == param) {
                resource.append(this.resourceDefault);
                resource.append(this.resourceExt);
            } else {
                resource.append(param);
                if (-1 == param.indexOf(PATH_EXTENSION_DELIMITER)) {
                    resource.append(this.resourceExt);
                }
            }
            profile.setName(resource.toString());
            this.getLanguageSettings(profile, (RunData)rundata);
            PSMLDocument doc = this.fallback(profile);
            if (null != doc) {
                profile.setDocument(doc);
                return profile;
            }
        }
        catch (Exception e) {
            logger.error("Exception in fallbackProfile", e);
            throw new ProfileException(e.toString());
        }
        return null;
    }

    public Profile getProfile(RunData rundata) throws ProfileException {
        CapabilityMap cm = null;
        cm = rundata instanceof JetspeedRunData ? ((JetspeedRunData)rundata).getCapability() : CapabilityMapFactory.getCapabilityMap(rundata);
        return this.getProfile(rundata, cm);
    }

    public Profile getProfile(RunData data, MimeType mt) throws ProfileException {
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap(mt.toString());
        return this.getProfile(data, cm);
    }

    public Profile getProfile(ProfileLocator locator) throws ProfileException {
        PSMLDocument doc = this.fallback(locator);
        Profile profile = this.createProfile(locator);
        profile.setDocument(doc);
        return profile;
    }

    protected void getLanguageSettings(Profile profile, RunData rundata) {
        String language = rundata.getParameters().getString("language");
        if (language != null) {
            String country;
            profile.setLanguage(language);
            if (!language.equals("-1") && (country = rundata.getParameters().getString("country")) != null) {
                profile.setCountry(country);
            }
        } else {
            Locale locale = (Locale)rundata.getUser().getTemp("locale");
            if (locale == null) {
                CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName("LocalizationService");
                locale = locService.getLocale(rundata);
                if (locale == null) {
                    locale = new Locale(TurbineResources.getString((String)"locale.default.language", (String)"en"), TurbineResources.getString((String)"locale.default.country", (String)"US"));
                }
                rundata.getUser().setTemp("locale", (Object)locale);
            }
            if (this.useFallbackLanguage) {
                profile.setLanguage(locale.getLanguage());
            }
            if (this.useFallbackCountry) {
                profile.setCountry(locale.getCountry());
            }
        }
    }

    protected PSMLDocument fallbackList(ProfileLocator original, RunData rundata) {
        try {
            LinkedList<Object> locators = new LinkedList<Object>();
            ProfileLocator locator = (ProfileLocator)original.clone();
            locators.add(locator.clone());
            if (null != original.getCountry()) {
                locator.setCountry(null);
                locators.add(locator.clone());
            }
            if (null != original.getLanguage()) {
                locator.setLanguage(null);
                locators.add(locator.clone());
            }
            if (null != original.getMediaType()) {
                locator.setMediaType(null);
                locators.add(locator.clone());
            }
            if (null != original.getGroup()) {
                locator.setGroup(null);
                locators.add(locator.clone());
            } else if (null != original.getRole()) {
                locator.setRole(null);
                locators.add(locator.clone());
            } else if (null != original.getUser()) {
                locator.setUser(null);
                locators.add(locator.clone());
            }
            PSMLDocument doc = PsmlManager.getDocument(locators);
            return doc;
        }
        catch (CloneNotSupportedException e) {
            logger.error("Profiler: Could not clone profile locator object", e);
            return null;
        }
    }

    protected PSMLDocument fallback(ProfileLocator locator) {
        PSMLDocument doc;
        if (logger.isDebugEnabled()) {
            logger.debug("Profiler: fallback called with: " + locator);
        }
        if (null != (doc = PsmlManager.getDocument(locator))) {
            return doc;
        }
        if (null != locator.getCountry() && !locator.getCountry().equals("-1")) {
            locator.setCountry(null);
            doc = PsmlManager.getDocument(locator);
            if (null != doc) {
                return doc;
            }
        }
        if (null != locator.getLanguage() && !locator.getLanguage().equals("-1")) {
            locator.setLanguage(null);
            doc = PsmlManager.getDocument(locator);
            if (null != doc) {
                return doc;
            }
        }
        if (this.useFallbackToRoot && null != locator.getMediaType()) {
            locator.setMediaType(null);
            doc = PsmlManager.getDocument(locator);
            if (null != doc) {
                return doc;
            }
        }
        if (!this.useRoleFallback) {
            if (null != locator.getGroup()) {
                locator.setGroup(null);
                doc = PsmlManager.getDocument(locator);
                if (null != doc) {
                    return doc;
                }
            } else if (null != locator.getRole()) {
                locator.setRole(null);
                doc = PsmlManager.getDocument(locator);
                if (null != doc) {
                    return doc;
                }
            } else if (null != locator.getUser()) {
                locator.setUser(null);
                doc = PsmlManager.getDocument(locator);
                if (null != doc) {
                    return doc;
                }
            }
        }
        return doc;
    }

    protected String getMediaType(RunData rundata, CapabilityMap cm) {
        String paramMediaType;
        String media = null;
        if (null != rundata && null != (paramMediaType = rundata.getParameters().getString("media-type"))) {
            return paramMediaType;
        }
        if (cm != null) {
            media = cm.getPreferredMediaType();
        }
        return media;
    }

    private void initConfiguration() throws InitializationException {
        this.profileClass = ServiceHelper.loadModelClass(this, "profile.impl");
        this.locatorClass = ServiceHelper.loadModelClass(this, "locator.impl");
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("Profiler");
        this.resourceDefault = serviceConf.getString(CONFIG_RESOURCE_DEFAULT, DEFAULT_CONFIG_RESOURCE_DEFAULT);
        this.resourceExt = serviceConf.getString(CONFIG_RESOURCE_EXT, DEFAULT_CONFIG_RESOURCE_EXT);
        if (-1 == this.resourceExt.indexOf(PATH_EXTENSION_DELIMITER)) {
            this.resourceExt = PATH_EXTENSION_DELIMITER + this.resourceExt;
        }
        this.useSecurity = serviceConf.getBoolean(CONFIG_SECURITY, false);
        this.useRoleFallback = serviceConf.getBoolean(CONFIG_ROLE_FALLBACK, true);
        this.newUserTemplate = serviceConf.getString(CONFIG_NEWUSER_TEMPLATE, DEFAULT_CONFIG_NEWUSER_TEMPLATE);
        this.useFallbackToRoot = serviceConf.getBoolean(CONFIG_FALLBACK_TO_ROOT, this.useFallbackToRoot);
        this.useFallbackLanguage = serviceConf.getBoolean(CONFIG_FALLBACK_LANGUAGE, this.useFallbackLanguage);
        this.useRoleMerge = serviceConf.getBoolean(CONFIG_ROLE_MERGE, this.useRoleMerge);
        this.rolemergeControl = serviceConf.getString(CONFIG_ROLE_MERGE_CONTROL, DEFAULT_CONFIG_ROLE_MERGE_CONTROL);
        this.rolemergeController = serviceConf.getString(CONFIG_ROLE_MERGE_CONTROLLER, DEFAULT_CONFIG_ROLE_MERGE_CONTROLLER);
        this.useFallbackCountry = !this.useFallbackLanguage ? false : serviceConf.getBoolean(CONFIG_FALLBACK_COUNTRY, this.useFallbackCountry);
        try {
            this.mediaTypes = serviceConf.getStringArray(CONFIG_NEWUSER_MEDIA);
        }
        catch (Exception e) {
            logger.error("Error getting media types", e);
        }
        if (null == this.mediaTypes || this.mediaTypes.length == 0) {
            this.mediaTypes = DEFAULT_CONFIG_NEWUSER_MEDIA;
        }
    }

    public DynamicURI makeDynamicURI(RunData data, ProfileLocator locator) throws ProfileException {
        String page;
        JetspeedUser user;
        String country;
        String language;
        DynamicURI uri = new DynamicURI(data);
        String mtype = locator.getMediaType();
        if (null != mtype) {
            uri.addPathInfo("media-type", mtype);
        }
        if (null != (language = locator.getLanguage())) {
            uri.addPathInfo("language", language);
        }
        if (null != (country = locator.getCountry())) {
            uri.addPathInfo("country", country);
        }
        if (null != (user = locator.getUser())) {
            if (user.getUserName() != null) {
                uri.addPathInfo("user", user.getUserName());
            }
        } else {
            Group group = locator.getGroup();
            if (null != group) {
                uri.addPathInfo("group", group.getName());
            } else {
                Role role = locator.getRole();
                if (null != role) {
                    uri.addPathInfo("role", role.getName());
                }
            }
        }
        if (null != (page = locator.getName())) {
            uri.addPathInfo("page", page);
        }
        return uri;
    }

    public Profile createProfile() {
        return (Profile)ServiceHelper.createObject(this.profileClass);
    }

    public Profile createProfile(ProfileLocator locator) {
        Profile profile = (Profile)ServiceHelper.createObject(this.profileClass);
        profile.init(locator);
        return profile;
    }

    public ProfileLocator createLocator() {
        return (ProfileLocator)ServiceHelper.createObject(this.locatorClass);
    }

    public Profile createProfile(ProfileLocator locator, Portlets portlets) throws ProfileException {
        if (portlets == null) {
            portlets = new PsmlPortlets();
        }
        Profile profile = this.createProfile(locator);
        PSMLDocument doc = new BasePSMLDocument(null, portlets);
        profile.setDocument(doc);
        doc = PsmlManager.createDocument(profile);
        profile.setDocument(doc);
        return profile;
    }

    public Profile createProfile(RunData data, Profile profile, String contentType, String from) throws ProfileException {
        if (contentType == null || contentType.length() < 2) {
            contentType = "html";
        }
        if (from == null || from.length() < 2) {
            from = "turbine";
        }
        if (null == profile.getDocument() || !profile.getMediaType().equalsIgnoreCase(contentType)) {
            try {
                ProfileLocator locator = this.createLocator();
                locator.setUser(JetspeedSecurity.getUser(from));
                locator.setMediaType(contentType);
                PSMLDocument doc = this.fallback(locator);
                if (doc != null) {
                    PSMLDocument clonedDoc = (PSMLDocument)SerializationUtils.clone((Serializable)doc);
                    PortletUtils.regenerateIds(clonedDoc.getPortlets());
                    profile.setDocument(clonedDoc);
                }
                profile.setName(this.resourceDefault + this.resourceExt);
            }
            catch (Exception e) {
                logger.error("Error creating profile", e);
                throw new ProfileException(e.toString());
            }
        }
        try {
            profile.setMediaType(contentType);
            PSMLDocument doc = PsmlManager.createDocument(profile);
            Profile newProfile = (Profile)profile.clone();
            newProfile.setDocument(doc);
            return newProfile;
        }
        catch (CloneNotSupportedException e) {
            logger.error("Could not clone profile locator object: ", e);
            return null;
        }
    }

    public Profile createProfile(RunData data, Profile profile, MimeType mt) throws ProfileException {
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap(mt.getContentType());
        profile.setMediaType(this.getMediaType(data, cm));
        return this.createProfile(data, profile);
    }

    public void removeProfile(ProfileLocator locator) {
        PsmlManager.removeDocument(locator);
    }

    public Iterator query(QueryLocator locator) {
        return PsmlManager.query(locator);
    }

    public boolean useRoleProfileMerging() {
        return this.useRoleFallback && this.useRoleMerge;
    }
}

