/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.portletstats;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.portletstats.PortletStatsService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.util.RunData;

public class JetspeedPortletStatsService
extends TurbineBaseService
implements PortletStatsService {
    protected static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedPortletStatsService.class.getName());
    protected static final String defaultLogFormat = "{0} {1} {2} [{3}] \"{4} {5}/{6} {7}\" {8} {9}";
    private boolean enabled = false;
    protected String dateFormat = null;
    protected SimpleDateFormat formatter = null;
    protected boolean logLoadTime = false;

    public void init(ServletConfig conf) throws InitializationException {
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("PortletStats");
        this.enabled = serviceConf.getBoolean("enabled");
        this.dateFormat = serviceConf.getString("dateFormat", "dd/MM/yyyy:hh:mm:ss z");
        this.formatter = new SimpleDateFormat(this.dateFormat);
        this.logLoadTime = serviceConf.getBoolean("logLoadTime", false);
        this.setInit(true);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean setEnabled(boolean state) {
        boolean oldState = this.enabled;
        this.enabled = state;
        return oldState;
    }

    public void logAccess(RunData data, Portlet portlet, String statusCode, long time) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            logger.info(this.getLogMessage(data, portlet, statusCode, time));
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
    }

    protected String getLogMessage(RunData data, Portlet portlet, String statusCode, long time) throws Exception {
        HttpServletRequest req = data.getRequest();
        Object[] args = new Object[]{req.getRemoteAddr(), "-", data.getUser().getUserName(), this.formatter.format(new Date()), req.getMethod(), req.getContextPath(), portlet.getName(), req.getProtocol(), statusCode, this.logLoadTime ? String.valueOf(time) : "-"};
        return MessageFormat.format(defaultLogFormat, args).toString();
    }

    public void logAccess(RunData data, Portlet portlet, String statusCode) {
        this.logAccess(data, portlet, statusCode, 0L);
    }
}

