/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.logging;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;

public class JetspeedLogFactoryService
extends TurbineBaseService {
    public String SERVICE_NAME = "JetspeedLogFactoryService";
    private static final String CONFIG_LOG4J_PROPERTIES = "log4j.properties";
    private static final String CONFIG_LOG4J_PROPERTIES_DEFAULT = "/WEB-INF/conf/log4j.properties";
    private static final String CONFIG_LOG4J_AND_WATCH = "log4j.configureAndWatch";
    private static final boolean CONFIG_LOG4J_AND_WATCH_DEFAULT = true;
    private static final String CONFIG_LOG4J_WATCHINTERVAL = "log4j.watchInterval";
    private static final long CONFIG_LOG4J_WATCHINTERVAL_DEFAULT = 60000L;
    private ServletContext context = null;
    private static boolean initDone = false;

    public void init() throws InitializationException {
        ServletConfig conf = Turbine.getTurbineServletConfig();
        if (conf != null) {
            this.init(conf);
        }
    }

    public void init(ServletConfig config) throws InitializationException {
        this.context = config.getServletContext();
        String log4jProperties = JetspeedResources.getString(CONFIG_LOG4J_PROPERTIES, CONFIG_LOG4J_PROPERTIES_DEFAULT);
        if (log4jProperties != null) {
            try {
                String fileName = Turbine.getRealPath((String)log4jProperties);
                boolean watch = JetspeedResources.getBoolean(CONFIG_LOG4J_AND_WATCH, true);
                long watchInterval = JetspeedResources.getLong(CONFIG_LOG4J_WATCHINTERVAL, 60000L);
                System.setProperty("webappRoot", this.context.getRealPath("/"));
                if (fileName.endsWith(".properties")) {
                    if (watch) {
                        PropertyConfigurator.configureAndWatch((String)fileName, (long)watchInterval);
                    } else {
                        PropertyConfigurator.configure((String)fileName);
                    }
                } else if (watch) {
                    DOMConfigurator.configureAndWatch((String)fileName, (long)watchInterval);
                } else {
                    DOMConfigurator.configure((String)fileName);
                }
            }
            catch (Exception e) {
                throw new InitializationException("Failed to load " + log4jProperties + " - " + e.toString());
            }
        }
        this.setInit(true);
        initDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static JetspeedLogger getLogger(String loggerName) {
        if (!initDone) {
            Class<JetspeedLogFactoryService> clazz = JetspeedLogFactoryService.class;
            // MONITORENTER : org.apache.jetspeed.services.logging.JetspeedLogFactoryService.class
            if (!initDone) {
                try {
                    new JetspeedLogFactoryService().init();
                }
                catch (Exception e) {
                    System.err.println("Init failed no logging available" + e.getMessage());
                    e.printStackTrace();
                }
            }
            // MONITOREXIT : clazz
        }
        Logger newLog = LogManager.getLogger((String)loggerName);
        return new JetspeedLogger(newLog);
    }
}

