/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.ldap;

import java.net.MalformedURLException;
import java.net.URLDecoder;

public class LDAPURL {
    private String host;
    private int port;
    private String dn;
    private String base;

    public LDAPURL() {
        this.base = null;
        this.dn = null;
        this.host = null;
        this.port = 389;
    }

    public LDAPURL(String url) throws MalformedURLException {
        try {
            url = URLDecoder.decode(url);
        }
        catch (Exception e) {
            throw new MalformedURLException(e.getMessage());
        }
        int p1 = url.indexOf("://");
        if (p1 == -1) {
            throw new MalformedURLException("Missing '[protocol]://'");
        }
        String protocol = url.substring(0, p1);
        int p2 = url.indexOf(47, p1 += 3);
        String base = null;
        if (p2 == -1) {
            base = url.substring(p1);
            this.parseHostPort(base);
            this.dn = "";
        } else {
            base = url.substring(p1, p2);
            this.dn = url.substring(++p2);
            int p3 = this.dn.indexOf(63);
            if (p3 != -1) {
                this.dn = this.dn.substring(0, p3);
            }
            this.parseHostPort(base);
        }
    }

    public LDAPURL(String host, int port, String dn) {
        this.host = host;
        this.port = port;
        this.dn = dn;
    }

    public static String encode(String toEncode) {
        StringBuffer encoded = new StringBuffer(toEncode.length() + 10);
        for (int currPos = 0; currPos < toEncode.length(); ++currPos) {
            char currChar = toEncode.charAt(currPos);
            if (currChar >= 'a' && currChar <= 'z' || currChar >= 'A' && currChar <= 'Z' || currChar >= '0' && currChar <= '9' || "$-_.+!*'(),".indexOf(currChar) > 0) {
                encoded.append(currChar);
                continue;
            }
            encoded.append("%");
            encoded.append(LDAPURL.hexChar((currChar & 0xF0) >> 4));
            encoded.append(LDAPURL.hexChar(currChar & 0xF));
        }
        return encoded.toString();
    }

    public String getBase() {
        if (this.base == null) {
            this.base = "ldap://" + this.host + ":" + this.port;
        }
        return this.base;
    }

    public String getDN() {
        return this.dn;
    }

    public String getEncodedUrl() {
        return this.getBase() + "/" + LDAPURL.encode(this.dn);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUrl() {
        return this.getBase() + "/" + this.dn;
    }

    private static char hexChar(int hexValue) {
        if (hexValue < 0 || hexValue > 15) {
            return 'x';
        }
        if (hexValue < 10) {
            return (char)(hexValue + 48);
        }
        return (char)(hexValue - 10 + 97);
    }

    private void parseHostPort(String str) throws MalformedURLException {
        int p1 = str.indexOf(58);
        if (p1 == -1) {
            this.host = str;
            this.port = 389;
        } else {
            this.host = str.substring(0, p1);
            String pp = str.substring(p1 + 1);
            try {
                this.port = Integer.parseInt(pp);
            }
            catch (NumberFormatException _ex) {
                throw new MalformedURLException("Invalid port number: " + pp);
            }
        }
    }

    public boolean sameHosts(LDAPURL url) {
        return this.getHost().equalsIgnoreCase(url.getHost()) && this.getPort() == url.getPort();
    }

    public void setDN(String dn) {
        this.dn = dn;
    }

    public void setHost(String host) {
        this.host = host;
        this.base = null;
    }

    public void setPort(int port) {
        this.port = port;
        this.base = null;
    }

    public static String toUrl(String host, int port, String dn, boolean ssl) {
        StringBuffer msg = new StringBuffer();
        msg.append(ssl ? "ldaps://" : "ldap://");
        msg.append(host);
        if (ssl && port != 636 || !ssl && port != 389) {
            msg.append(":");
            msg.append(String.valueOf(port));
        }
        msg.append("/");
        msg.append(dn);
        return msg.toString();
    }

    public String toString() {
        return "LDAPURL: base = " + this.base + ", url = " + LDAPURL.toUrl(this.host, this.port, this.dn, false);
    }
}

