/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.ldap.Connector;
import org.apache.jetspeed.services.ldap.LDAPURL;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class LDAPService
extends TurbineBaseService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(LDAPService.class.getName());
    public static final String SERVICE_NAME = "ldap";
    private static final String[] DEFAULT_ATTR = new String[]{"objectclass"};
    public static final int BASE = 0;
    public static final int ONE = 1;
    public static final int SUB = 2;
    public static final int DEFAULT_PORT = 389;
    public static final int DEFAULT_SSLPORT = 636;
    public static final int DEFAULT_LIMIT = 0;
    public static final int DEFAULT_TIMEOUT = 0;
    public static final int DEFAULT_VERSION = 3;
    private static String DEFAULT_CTX = "com.sun.jndi.ldap.LdapCtxFactory";
    private Hashtable connections;
    private Connector connector;
    private int limit;
    private int timeout;
    private int version;
    private String host;
    private int port;
    private int sslport;
    private String basedn;
    private String managerdn;
    private String password;
    private String managerlogin;
    private int batchsize;
    private String securityAuthentication;
    private String securityProtocol;
    private String socketFactory;
    private String saslclientpckgs;
    private String jndiprovider;
    private boolean anonymousBind;
    private String listFilter;
    private String[] attributesList;
    private NameParser parser;
    private boolean showOpAttributes;
    private boolean useCachedDirContexts;
    private Properties env;

    private boolean mainConnect(LDAPURL url) {
        this.setDefaultEnv();
        String base = url.getBase();
        this.env.put("java.naming.provider.url", base);
        try {
            InitialDirContext ctx = new InitialDirContext(this.env);
            if (this.useCachedDirContexts) {
                this.connections.put(this.basedn, ctx);
            }
            if (this.parser == null) {
                this.parser = ctx.getNameParser("");
            }
            return true;
        }
        catch (NamingException e) {
            logger.error("LDAP Service: Failed to connect to " + url.getUrl(), e);
            return false;
        }
    }

    public DirContext connect(LDAPURL url) {
        String base = url.getBase();
        DirContext ctx = (DirContext)this.connections.get(base);
        if (ctx != null) {
            return ctx;
        }
        this.setDefaultEnv();
        this.env.put("java.naming.provider.url", base);
        while (true) {
            try {
                ctx = new InitialDirContext(this.env);
                if (this.useCachedDirContexts) {
                    this.connections.put(base, ctx);
                }
                return ctx;
            }
            catch (AuthenticationException e) {
                logger.error("LDAP Service: Authentication error: " + base, e);
                if (this.connector == null) {
                    return null;
                }
                Properties pr = this.connector.referralConnection(this.env, url, this.anonymousBind);
                if (pr == null) break;
                this.env = pr;
                continue;
            }
            catch (CommunicationException e) {
                logger.error("LDAP Service: Communication error: " + base, e);
                if (this.connector == null) {
                    return null;
                }
                if (!this.connector.connectionFailed(url)) break;
                this.resetConnection(url);
                continue;
            }
            catch (NamingException e) {
                logger.error("LDAP Service:Failed to connect to " + base, e);
            }
            break;
        }
        return ctx;
    }

    private void resetConnection(LDAPURL url) {
        this.connections.remove(url.getBase());
    }

    private void setDefaultEnv() {
        this.showOpAttributes = this.attributesList != null;
        this.env.put("java.naming.referral", "ignore");
        this.env.put("java.naming.batchsize", String.valueOf(this.batchsize));
        if (this.anonymousBind) {
            this.env.remove("java.naming.security.principal");
            this.env.remove("java.naming.security.credentials");
        } else {
            this.env.put("java.naming.security.principal", this.managerdn);
            this.env.put("java.naming.security.credentials", this.password);
        }
        this.env.put("java.naming.security.authentication", this.securityAuthentication);
        if (this.saslclientpckgs != null) {
            this.env.put("javax.security.sasl.client.pkgs", this.saslclientpckgs);
        } else {
            this.env.remove("javax.security.sasl.client.pkgs");
        }
        this.env.put("java.naming.ldap.derefAliases", "never");
        this.env.put("java.naming.ldap.deleteRDN", "true");
        this.env.put("java.naming.ldap.version", String.valueOf(this.version));
        if (this.securityProtocol != null) {
            this.env.put("java.naming.security.protocol", this.securityProtocol);
            if (this.securityProtocol.equalsIgnoreCase("ssl")) {
                this.env.put("java.naming.ldap.factory.socket", this.socketFactory);
            }
        } else {
            this.env.remove("java.naming.security.protocol");
            this.env.remove("java.naming.ldap.factory.socket");
        }
        this.env.put("java.naming.factory.initial", this.jndiprovider);
    }

    public boolean disconnect() {
        DirContext ctx = null;
        Enumeration enu = this.connections.elements();
        while (enu.hasMoreElements()) {
            try {
                ctx = (DirContext)enu.nextElement();
                ctx.close();
            }
            catch (NamingException e) {
                logger.error("LDAP Service: Disconnect failed", e);
            }
        }
        this.connections.clear();
        return true;
    }

    public boolean checkAndCloseContext(Context context) {
        try {
            if (!this.useCachedDirContexts) {
                context.close();
            }
            return true;
        }
        catch (NamingException e) {
            logger.error("LDAP Service: closeContext() failed", e);
            return false;
        }
    }

    public boolean deleteAttribute(LDAPURL url, Attribute at) {
        try {
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, at)};
            return this.modifyAttribute(url, mods);
        }
        catch (NamingException e) {
            logger.debug("LDAP Service: Failed to delete '" + at.getID() + "' attribute for " + url.getUrl(), e);
            return false;
        }
    }

    public boolean addAttribute(LDAPURL url, Attribute at) {
        try {
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, at)};
            return this.modifyAttribute(url, mods);
        }
        catch (NamingException e) {
            logger.debug("LDAP Service: Failed to add '" + at.getID() + "' attribute for " + url.getUrl(), e);
            return false;
        }
    }

    public boolean addEntry(LDAPURL url, Attributes at) {
        DirContext ctx = this.connect(url);
        if (ctx == null) {
            return false;
        }
        try {
            ctx.createSubcontext(url.getDN(), at);
            this.checkAndCloseContext(ctx);
        }
        catch (ReferralException e) {
            LDAPURL myurl = this.getReferralUrl(e);
            return this.addEntry(myurl, at);
        }
        catch (NamingException e) {
            e.printStackTrace();
            logger.error("LDAP Service: Failed to add new entry " + url.getDN(), e);
            return false;
        }
        return true;
    }

    public boolean exists(LDAPURL url) {
        DirContext ctx = this.connect(url);
        if (ctx == null) {
            return false;
        }
        try {
            NamingEnumeration results = this.search(ctx, url.getDN(), "(objectclass=*)", DEFAULT_ATTR, 0, false);
            this.checkAndCloseContext(ctx);
            return true;
        }
        catch (NameNotFoundException _ex) {
            return false;
        }
        catch (NamingException _ex) {
            return false;
        }
    }

    public int compare(LDAPURL srcUrl, LDAPURL dstUrl) {
        if (!srcUrl.sameHosts(dstUrl)) {
            return 0;
        }
        Name src = this.parse(srcUrl.getDN());
        Name dst = this.parse(dstUrl.getDN());
        if (dst.compareTo(src) == 0) {
            return 1;
        }
        if (dst.startsWith(src)) {
            return 2;
        }
        Name prefix = src.getPrefix(src.size() - 1);
        return dst.compareTo(prefix) != 0 ? 0 : 3;
    }

    public int importEntry(LDAPURL url, String dn, Attributes entry, int type) {
        boolean rs = false;
        LDAPURL myurl = new LDAPURL(url.getHost(), url.getPort(), dn);
        if (type == 0) {
            rs = this.addEntry(myurl, entry);
        } else if (type == 1) {
            rs = this.updateEntry(myurl, entry);
        } else if (type == 2) {
            rs = this.synchEntry(myurl, entry);
        } else {
            return 0;
        }
        return !rs ? -1 : 1;
    }

    private boolean modifyAttribute(LDAPURL url, ModificationItem[] mods) throws NamingException {
        DirContext ctx = this.connect(url);
        if (ctx == null) {
            return false;
        }
        try {
            ctx.modifyAttributes(url.getDN(), mods);
            this.checkAndCloseContext(ctx);
        }
        catch (ReferralException e) {
            LDAPURL myurl = this.getReferralUrl(e);
            return this.modifyAttribute(myurl, mods);
        }
        return true;
    }

    public LDAPURL buildURL(String DN) {
        return new LDAPURL(this.host, this.port, DN + "," + this.basedn);
    }

    public Attributes read(LDAPURL url) {
        DirContext ctx = this.connect(url);
        if (ctx == null) {
            return null;
        }
        Attributes attrs = null;
        try {
            attrs = this.showOpAttributes ? ctx.getAttributes(url.getDN(), this.attributesList) : ctx.getAttributes(url.getDN());
            this.checkAndCloseContext(ctx);
        }
        catch (ReferralException e) {
            LDAPURL myurl = this.getReferralUrl(e);
            if (myurl.getDN().length() == 0) {
                myurl.setDN(url.getDN());
            }
            return this.read(myurl);
        }
        catch (CommunicationException e) {
            if (this.connector == null) {
                logger.debug("LDAP Service: Communication error : " + url.getBase(), e);
                return null;
            }
            if (this.connector.connectionFailed(url)) {
                this.resetConnection(url);
            }
        }
        catch (NamingException e) {
            logger.debug("LDAP Service: Failed to read entry " + url.getDN(), e);
            return null;
        }
        return attrs;
    }

    public boolean renameEntry(LDAPURL url, String newDN) {
        DirContext ctx = this.connect(url);
        if (ctx == null) {
            return false;
        }
        try {
            ctx.rename(url.getDN(), newDN);
            this.checkAndCloseContext(ctx);
        }
        catch (ReferralException e) {
            logger.debug("LDAP Service: Failed to rename entry. (not supported for referrals)", e);
            return false;
        }
        catch (NamingException e) {
            logger.debug("LDAP Service: Failed to rename entry " + url.getDN(), e);
            return false;
        }
        return true;
    }

    public boolean synchEntry(LDAPURL url, Attributes ats) {
        DirContext ctx = this.connect(url);
        if (ctx == null) {
            return false;
        }
        try {
            ctx.modifyAttributes(url.getDN(), 2, ats);
            this.checkAndCloseContext(ctx);
        }
        catch (ReferralException e) {
            LDAPURL myurl = this.getReferralUrl(e);
            return this.synchEntry(url, ats);
        }
        catch (NameNotFoundException _ex) {
            try {
                ctx.createSubcontext(url.getDN(), ats);
            }
            catch (NamingException _ex2) {
                return false;
            }
        }
        catch (NamingException e) {
            logger.debug("LDAP Service: Failed to synchronize entries", e);
            return false;
        }
        return true;
    }

    public boolean deleteAttrs(LDAPURL url, Attributes ats) {
        DirContext ctx = this.connect(url);
        if (ctx == null) {
            return false;
        }
        try {
            ctx.modifyAttributes(url.getDN(), 3, ats);
            this.checkAndCloseContext(ctx);
        }
        catch (ReferralException e) {
            LDAPURL myurl = this.getReferralUrl(e);
            return this.synchEntry(url, ats);
        }
        catch (NameNotFoundException _ex) {
            try {
                ctx.createSubcontext(url.getDN(), ats);
                this.checkAndCloseContext(ctx);
            }
            catch (NamingException _ex2) {
                return false;
            }
        }
        catch (NamingException e) {
            logger.debug("LDAP Service: Failed to delete Attributes", e);
            return false;
        }
        return true;
    }

    public boolean deleteEntry(LDAPURL url) {
        DirContext ctx = this.connect(url);
        if (ctx == null) {
            return false;
        }
        try {
            ctx.destroySubcontext(url.getDN());
            this.checkAndCloseContext(ctx);
        }
        catch (ReferralException e) {
            LDAPURL myurl = this.getReferralUrl(e);
            return this.deleteEntry(myurl);
        }
        catch (NamingException e) {
            logger.debug("LDAP Service: Failed to delete entry " + url.getDN(), e);
            return false;
        }
        return true;
    }

    public LDAPURL findEntryName(LDAPURL url) {
        DirContext ctx = this.connect(url);
        if (ctx == null) {
            return null;
        }
        Name name = this.parse(url.getDN());
        String base = name.getPrefix(name.size() - 1).toString();
        String dn = url.getDN();
        String rdn = name.get(name.size() - 1);
        int i = 1;
        boolean foundName = true;
        while (foundName) {
            try {
                NamingEnumeration results = this.search(ctx, dn, "(objectclass=*)", DEFAULT_ATTR, 0, false);
                if (i == 1) {
                    rdn = rdn + " copy";
                } else if (i == 2) {
                    rdn = rdn + " " + i;
                } else if (i >= 3) {
                    rdn = rdn.substring(0, rdn.length() - 1) + i;
                }
                dn = rdn + ", " + base;
                ++i;
            }
            catch (NameNotFoundException _ex) {
                foundName = false;
                return new LDAPURL(url.getHost(), url.getPort(), dn);
            }
            catch (NamingException _ex) {
                return null;
            }
        }
        this.checkAndCloseContext(ctx);
        return null;
    }

    public boolean deleteTree(LDAPURL url) {
        DirContext ctx = this.connect(url);
        if (ctx == null) {
            return false;
        }
        String entryDN = null;
        LDAPURL myurl = null;
        String baseDN = url.getDN();
        try {
            NamingEnumeration results = this.search(ctx, baseDN, "(objectclass=*)", DEFAULT_ATTR, 1, false);
            while (results.hasMore()) {
                SearchResult si = (SearchResult)results.next();
                entryDN = this.getFixedDN(si.getName(), baseDN);
                myurl = new LDAPURL(url.getHost(), url.getPort(), entryDN);
                if (this.deleteTree(myurl)) continue;
                return false;
            }
            this.checkAndCloseContext(ctx);
        }
        catch (NamingException e) {
            logger.debug("LDAP Service: Delete tree failed", e);
            return false;
        }
        return this.deleteEntry(url);
    }

    public boolean transfer(LDAPURL fromUrl, LDAPURL toUrl, boolean delete, boolean replace, boolean withChildren) {
        LDAPURL dstUrl = toUrl;
        int rc = this.compare(fromUrl, toUrl);
        if (rc == 1) {
            dstUrl = this.findEntryName(dstUrl);
        }
        if (withChildren) {
            return this.transferTreeSub(fromUrl, dstUrl, delete, replace);
        }
        return this.transferEntry(fromUrl, dstUrl, delete, replace);
    }

    public boolean transferEntry(LDAPURL fromUrl, Attributes ats, LDAPURL toUrl, boolean delete, boolean replace) {
        if (delete && !this.deleteEntry(fromUrl)) {
            return false;
        }
        if (this.updateEntry(toUrl, ats, replace)) {
            return true;
        }
        if (delete) {
            this.addEntry(fromUrl, ats);
        }
        return false;
    }

    public boolean transferEntry(LDAPURL fromUrl, LDAPURL toUrl, boolean delete, boolean replace) {
        Attributes ats = this.read(fromUrl);
        if (ats == null) {
            return false;
        }
        return this.transferEntry(fromUrl, ats, toUrl, delete, replace);
    }

    private boolean transferTreeSub(LDAPURL fromUrl, LDAPURL toUrl, boolean delete, boolean replace) {
        DirContext ctx = this.connect(fromUrl);
        if (ctx == null) {
            return false;
        }
        Attributes ats = this.read(fromUrl);
        if (ats == null) {
            return false;
        }
        String srcDN = fromUrl.getDN();
        String dstDN = toUrl.getDN();
        boolean createdBase = false;
        boolean rc = false;
        boolean moreReferrals = true;
        while (moreReferrals) {
            LDAPURL dstUrl;
            try {
                NamingEnumeration results = this.search(ctx, srcDN, "(objectclass=*)", DEFAULT_ATTR, 1, false);
                if (!results.hasMore()) {
                    if (!this.transferEntry(fromUrl, ats, toUrl, delete, replace)) {
                        return false;
                    }
                } else {
                    String name = null;
                    if (!createdBase) {
                        if (!this.updateEntry(toUrl, ats, replace)) {
                            return false;
                        }
                        createdBase = true;
                    }
                    while (results.hasMore()) {
                        SearchResult si = (SearchResult)results.next();
                        name = this.fixName(si.getName());
                        String tmpSrcDN = this.getDN(name, srcDN);
                        LDAPURL srcUrl = new LDAPURL(fromUrl.getHost(), fromUrl.getPort(), tmpSrcDN);
                        String tmpDstDN = this.getDN(name, dstDN);
                        dstUrl = new LDAPURL(toUrl.getHost(), toUrl.getPort(), tmpDstDN);
                        this.transferTreeSub(srcUrl, dstUrl, delete, replace);
                    }
                    if (delete && !this.deleteEntry(fromUrl)) {
                        return false;
                    }
                }
                moreReferrals = false;
            }
            catch (ReferralException e) {
                if (delete) {
                    moreReferrals = false;
                    continue;
                }
                if (!createdBase) {
                    if (!this.updateEntry(toUrl, ats, replace)) {
                        return false;
                    }
                    createdBase = true;
                }
                LDAPURL srcUrl = this.getReferralUrl(e);
                String tmpDstDN = this.getName(srcUrl.getDN()) + ", " + dstDN;
                dstUrl = new LDAPURL(toUrl.getHost(), toUrl.getPort(), tmpDstDN);
                boolean rs = this.transferTreeSub(srcUrl, dstUrl, delete, replace);
                if (!rs) {
                    return false;
                }
                moreReferrals = e.skipReferral();
                try {
                    this.checkAndCloseContext(ctx);
                    ctx = (DirContext)e.getReferralContext();
                }
                catch (NamingException _ex) {}
            }
            catch (NamingException e) {
                logger.debug("LDAP Service: Transfer Tree failed", e);
                return false;
            }
        }
        this.checkAndCloseContext(ctx);
        return true;
    }

    public boolean updateAttribute(LDAPURL url, Attribute at) {
        try {
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, at)};
            return this.modifyAttribute(url, mods);
        }
        catch (NamingException e) {
            logger.debug("LDAP Service: Failed to update '" + at.getID() + "' attribute for " + url.getUrl(), e);
            return false;
        }
    }

    public boolean updateEntry(LDAPURL url, Attributes at) {
        DirContext ctx = this.connect(url);
        if (ctx == null) {
            return false;
        }
        try {
            ctx.modifyAttributes(url.getDN(), 2, at);
            this.checkAndCloseContext(ctx);
        }
        catch (ReferralException e) {
            LDAPURL myurl = this.getReferralUrl(e);
            return this.updateEntry(myurl, at);
        }
        catch (NamingException e) {
            logger.error("LDAP Service: Failed to update entry " + url.getDN(), e);
            return false;
        }
        return true;
    }

    public boolean updateEntry(LDAPURL url, Attributes ats, boolean replace) {
        return replace ? this.synchEntry(url, ats) : this.addEntry(url, ats);
    }

    public NamingEnumeration search(DirContext ctx, String dn, String filter, String[] attribs, int type) throws NamingException {
        return this.search(ctx, dn, filter, attribs, type, true);
    }

    private NamingEnumeration search(DirContext ctx, String dn, String filter, String[] attribs, int type, boolean setLimits) throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(type);
        constraints.setReturningAttributes(attribs);
        if (setLimits) {
            constraints.setCountLimit(this.limit);
            constraints.setTimeLimit(this.timeout);
        }
        NamingEnumeration<SearchResult> results = ctx.search(dn, filter, constraints);
        return results;
    }

    public Vector search(LDAPURL url, String filter, String[] attribs, boolean subTreeScope) {
        Vector results = new Vector();
        String[] attrs = new String[attribs.length + 1];
        attrs[0] = "objectclass";
        System.arraycopy(attribs, 0, attrs, 1, attribs.length);
        int scope = subTreeScope ? 2 : 1;
        this.subSearch(url, filter, attrs, scope, results);
        return results;
    }

    private boolean subSearch(LDAPURL url, String filter, String[] attribs, int scope, Vector rs) {
        DirContext ctx = this.connect(url);
        if (ctx == null) {
            return false;
        }
        String entryDN = null;
        Attributes at = null;
        Attribute a = null;
        LDAPURL myurl = null;
        int subscope = 0;
        String baseDN = url.getDN();
        boolean moreReferrals = true;
        while (moreReferrals) {
            try {
                NamingEnumeration results = this.search(ctx, baseDN, filter, attribs, scope);
                while (results.hasMore()) {
                    SearchResult si = (SearchResult)results.next();
                    Vector<Object> vl = new Vector<Object>(attribs.length);
                    entryDN = this.getFixedDN(si.getName(), baseDN);
                    myurl = new LDAPURL(url.getHost(), url.getPort(), entryDN);
                    vl.addElement(myurl);
                    at = si.getAttributes();
                    for (int i = 1; i < attribs.length; ++i) {
                        a = at.get(attribs[i]);
                        if (a == null) {
                            vl.addElement("N/A");
                            continue;
                        }
                        Object v = a.get();
                        if (v instanceof byte[]) {
                            vl.addElement(v);
                            continue;
                        }
                        vl.addElement(a.get().toString());
                    }
                    rs.addElement(vl);
                }
                moreReferrals = false;
            }
            catch (ReferralException e) {
                myurl = this.getReferralUrl(e);
                subscope = scope != 1 ? scope : 0;
                boolean error = this.subSearch(myurl, filter, attribs, subscope, rs);
                if (!error) {
                    return error;
                }
                moreReferrals = e.skipReferral();
                try {
                    this.checkAndCloseContext(ctx);
                    ctx = (DirContext)e.getReferralContext();
                }
                catch (NamingException _ex) {}
            }
            catch (NamingException e) {
                logger.debug("LDAP Service: Search failed", e);
                return false;
            }
        }
        this.checkAndCloseContext(ctx);
        return true;
    }

    public String removeAttrName(String attrvalue) {
        StringTokenizer token = new StringTokenizer(attrvalue, "=");
        if (token.countTokens() == 2) {
            token.nextToken();
            return token.nextToken();
        }
        return attrvalue;
    }

    private String getFixedDN(String rdn, String base) {
        return this.getDN(this.fixName(rdn), base);
    }

    public String getName(String dn) {
        try {
            Name nm = this.parser.parse(dn);
            return nm.get(nm.size() - 1);
        }
        catch (NamingException _ex) {
            return null;
        }
    }

    private String fixName(String name) {
        if (name.length() > 0 && name.charAt(0) == '\"') {
            int size = name.length() - 1;
            StringBuffer buf = new StringBuffer();
            for (int i = 1; i < size; ++i) {
                if (name.charAt(i) == '/') {
                    buf.append("\\");
                }
                buf.append(name.charAt(i));
            }
            return buf.toString();
        }
        return name;
    }

    private String getDN(String rdn, String base) {
        if (rdn.length() == 0) {
            return base;
        }
        if (base.length() == 0) {
            return rdn;
        }
        return rdn + ", " + base;
    }

    public Name parse(String dn) {
        try {
            return this.parser.parse(dn);
        }
        catch (NamingException _ex) {
            return null;
        }
    }

    public LDAPURL getReferralUrl(ReferralException e) {
        String url = (String)e.getReferralInfo();
        try {
            return new LDAPURL(url);
        }
        catch (Exception ex) {
            logger.debug("Invalid url: " + ex.getMessage() + " " + url);
            return null;
        }
    }

    public void init(ServletConfig conf) throws InitializationException {
        this.connections = new Hashtable();
        this.connector = null;
        this.parser = null;
        this.env = new Properties();
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources(SERVICE_NAME);
        this.host = serviceConf.getString("host");
        this.port = serviceConf.getInt("port", 389);
        this.sslport = serviceConf.getInt("sslport", 636);
        this.limit = serviceConf.getInt("limit", 0);
        this.timeout = serviceConf.getInt("timeout", 0);
        this.version = serviceConf.getInt("version", 3);
        this.listFilter = this.repair(serviceConf.getString("listfilter", "(objectclass=*)"));
        this.basedn = this.repair(serviceConf.getString("basedn"));
        this.managerdn = this.repair(serviceConf.getString("managerdn"));
        this.password = serviceConf.getString("password");
        this.attributesList = this.getList(serviceConf.getString("attributeslist"), " ");
        this.showOpAttributes = serviceConf.getBoolean("showopattributes", false);
        this.anonymousBind = serviceConf.getBoolean("anonymousbind", false);
        this.securityAuthentication = serviceConf.getString("securityauthentication", "simple");
        this.securityProtocol = serviceConf.getString("securityprotocol");
        this.socketFactory = serviceConf.getString("socketfactory");
        this.useCachedDirContexts = serviceConf.getBoolean("contextcache", false);
        this.jndiprovider = serviceConf.getString("jndiprovider", DEFAULT_CTX);
        this.saslclientpckgs = serviceConf.getString("saslclientpckgs");
        this.mainConnect(new LDAPURL(this.host, this.port, this.basedn));
        this.setInit(true);
    }

    public void init() throws InitializationException {
        while (!this.getInit()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                logger.error(ie);
            }
        }
    }

    private String repair(String value) {
        value = value.replace('/', '=');
        value = value.replace('%', ',');
        return value;
    }

    private String[] getList(String value, String separator) {
        if (value == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(value, separator);
        String[] at = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            at[i] = tokens.nextToken();
            ++i;
        }
        return at;
    }
}

