/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.jsp.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.portal.PortletURIManager;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.URILookup;
import org.apache.turbine.util.RunData;

public class URILookupTag
extends TagSupport {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(URILookupTag.class.getName());
    private String type;

    public void setType(String type) {
        this.type = type;
    }

    public int doStartTag() throws JspException {
        RunData data = (RunData)this.pageContext.getAttribute("rundata", 2);
        try {
            String result = null;
            if (this.type.equalsIgnoreCase("Home")) {
                result = URILookup.getURI(0, 0, data);
            }
            if (this.type.equalsIgnoreCase("Login")) {
                result = URILookup.getURI(5, 0, data);
            }
            if (this.type.equalsIgnoreCase("Enrollment")) {
                result = URILookup.getURI(7, 0, data);
            }
            if (this.type.equalsIgnoreCase("Logout")) {
                result = URILookup.getURI(0, 4, data);
            }
            if (this.type.equalsIgnoreCase("Customize")) {
                result = URILookup.getURI(4, 0, data);
            }
            if (this.type.equalsIgnoreCase("EditAccount")) {
                result = URILookup.getURI(3, 0, data);
            }
            if (this.type.equalsIgnoreCase("Applications")) {
                PortletEntry entry = null;
                entry = (PortletEntry)Registry.getEntry(Registry.PORTLET, "Applications");
                result = PortletURIManager.getPortletMaxURI(entry, data).toString();
            }
            if (this.type.equalsIgnoreCase("BaseURL")) {
                result = URILookup.getWebAppBaseDirURI(data);
            }
            if (result == null) {
                throw new Exception("jetspeed-URILookup tag: Unknown parameter!");
            }
            this.pageContext.getOut().print(result);
        }
        catch (Exception e) {
            String message = "Error processing uriLookup-tag, parameter: " + this.type;
            logger.error(message, e);
            try {
                data.getOut().print("Error processing uriLookup-tag, parameter: " + this.type);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return 1;
    }
}

