/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.idgenerator;

import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.idgenerator.IdGeneratorService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class JetspeedIdGeneratorService
extends TurbineBaseService
implements IdGeneratorService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedIdGeneratorService.class.getName());
    private static final String CONFIG_COUNTER_START = "counter.start";
    private static final String CONFIG_PEID_PREFIX = "peid.prefix";
    private static final String CONFIG_PEID_SUFFIX = "peid.suffix";
    private static final long DEFAULT_CONFIG_COUNTER_START = 65536L;
    private static final String DEFAULT_CONFIG_PEID_PREFIX = "P-";
    private static final String DEFAULT_CONFIG_PEID_SUFFIX = "";
    private static String peidPrefix = null;
    private static String peidSuffix = null;
    protected static long idCounter;

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        this.initConfiguration();
        this.setInit(true);
    }

    public void init() throws InitializationException {
        logger.info("Late init for JetspeedIdGeneratorService called");
        while (!this.getInit()) {
            try {
                Thread.sleep(100L);
                logger.info("Waiting for init of JetspeedIdGeneratorService...");
            }
            catch (InterruptedException ie) {
                logger.error("Exception", ie);
            }
        }
    }

    public void shutdown() {
        logger.info("Shutdown for JetspeedIdGeneratorService called. idCounter = " + idCounter + " (" + Long.toHexString(idCounter) + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfiguration() throws InitializationException {
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("IdGenerator");
        peidPrefix = serviceConf.getString(CONFIG_PEID_PREFIX, DEFAULT_CONFIG_PEID_PREFIX);
        peidSuffix = serviceConf.getString(CONFIG_PEID_SUFFIX, DEFAULT_CONFIG_PEID_SUFFIX);
        Class<JetspeedIdGeneratorService> clazz = JetspeedIdGeneratorService.class;
        synchronized (JetspeedIdGeneratorService.class) {
            idCounter = serviceConf.getLong(CONFIG_COUNTER_START, 65536L);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextPeid() {
        Class<JetspeedIdGeneratorService> clazz = JetspeedIdGeneratorService.class;
        synchronized (JetspeedIdGeneratorService.class) {
            long newid = idCounter++;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            return peidPrefix + Long.toHexString(System.currentTimeMillis()) + "-" + Long.toHexString(newid) + peidSuffix;
        }
    }
}

