/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.customlocalization;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.jetspeed.services.customlocalization.CustomLocalization;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.RunData;

public class CustomLocalizationTool
implements ApplicationTool {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(CustomLocalizationTool.class.getName());
    protected Locale locale;
    private ResourceBundle bundle;
    private String bundleName;
    boolean debug;

    public CustomLocalizationTool() {
        this.refresh();
    }

    public String get(String key) {
        try {
            String s = CustomLocalization.getString(this.getBundleName(null), this.getLocale(), key);
            return s;
        }
        catch (MissingResourceException noKey) {
            logger.error("Exception", noKey);
            return null;
        }
    }

    public String get(String key, Locale locale) {
        if (locale == null) {
            locale = this.getLocale();
        }
        String s = null;
        try {
            s = CustomLocalization.getString(this.getBundleName(null), locale, key);
        }
        catch (MissingResourceException noKey) {
            logger.error("Exception", noKey);
        }
        return s;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected String getBundleName(Object data) {
        return CustomLocalization.getDefaultBundleName();
    }

    public final void init(Object data) {
        if (data instanceof RunData) {
            this.locale = CustomLocalization.getLocale((RunData)data);
            this.bundleName = this.getBundleName(data);
        }
    }

    public void refresh() {
        this.locale = null;
        this.bundle = null;
        this.bundleName = null;
    }
}

