/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets.admin;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class JavaRuntimePortlet
extends AbstractPortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JavaRuntimePortlet.class.getName());

    public ConcreteElement getContent(RunData rundata) {
        Table table = new Table().setWidth("100%");
        try {
            Runtime jvm = Runtime.getRuntime();
            table.addElement((Element)new TR().addElement((Element)new TD("Free Memory (in bytes)")).addElement((Element)new TD(Long.toString(jvm.freeMemory()))));
            table.addElement((Element)new TR().addElement((Element)new TD("Total Memory (in bytes)")).addElement((Element)new TD(Long.toString(jvm.totalMemory()))));
            Properties props = System.getProperties();
            Enumeration<?> enu = props.propertyNames();
            while (enu.hasMoreElements()) {
                Object key = enu.nextElement();
                if (!(key instanceof String)) continue;
                String value = props.getProperty(key.toString());
                table.addElement((Element)new TR().addElement((Element)new TD(key.toString())).addElement((Element)new TD(value.toString())));
            }
        }
        catch (Throwable t) {
            logger.error("Throwable", t);
            table.addElement((Element)new TR().addElement((Element)new TD("Error")).addElement((Element)new TD("Could not read system properties")));
        }
        return table;
    }

    public void init() throws PortletException {
        this.setTitle("Java Runtime");
        this.setDescription("Information about your Java Runtime");
    }

    public boolean getAllowEdit(RunData rundata) {
        return false;
    }

    public boolean getAllowMaximize(RunData rundata) {
        return false;
    }
}

