/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractInstancePortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.Base64;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.jetspeed.util.rewriter.HTMLRewriter;
import org.apache.jetspeed.util.rewriter.Rewriter;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.RunData;

public class WebPagePortlet2
extends AbstractInstancePortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(WebPagePortlet2.class.getName());
    protected Rewriter rewriter = null;
    protected boolean initDone = false;
    protected boolean contentStale = true;
    protected boolean cacheContent = false;
    protected String username = null;
    protected String password = null;

    public void init() throws PortletException {
        if (this.initDone) {
            return;
        }
        PortletConfig config = this.getPortletConfig();
        try {
            this.rewriter = new HTMLRewriter();
            this.username = config.getInitParameter("username");
            this.password = config.getInitParameter("password");
            this.contentStale = true;
            this.initDone = true;
        }
        catch (Exception e) {
            logger.info("Exception occurred:" + e.toString(), e);
            throw new PortletException(e.toString());
        }
    }

    protected Reader getReader(String url) throws IOException {
        URL pageUrl = new URL(url);
        URLConnection pageConn = pageUrl.openConnection();
        try {
            if (this.username != null && this.password != null) {
                pageConn.setRequestProperty("Authorization", "Basic " + Base64.encodeAsString(this.username + ":" + this.password));
            }
        }
        catch (Exception e) {
            logger.info("Exception occurred:" + e.toString(), e);
        }
        long pageExpiration = pageConn.getExpiration();
        String encoding = "iso-8859-1";
        String contentType = pageConn.getContentType();
        String tempString = null;
        String noCache = "no-cache";
        if (contentType != null) {
            StringTokenizer st = new StringTokenizer(contentType, "; =");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equalsIgnoreCase("charset")) continue;
                try {
                    encoding = st.nextToken();
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
        }
        this.cacheContent = true;
        if (pageExpiration == 0L) {
            this.cacheContent = false;
        }
        if ((tempString = pageConn.getHeaderField("Cache-Control")) != null && tempString.toLowerCase().indexOf(noCache) >= 0) {
            this.cacheContent = false;
        }
        if ((tempString = pageConn.getHeaderField("Pragma")) != null && tempString.toLowerCase().indexOf(noCache) >= 0) {
            this.cacheContent = false;
        }
        InputStreamReader rdr = new InputStreamReader(pageConn.getInputStream(), encoding);
        if (pageExpiration > System.currentTimeMillis() && this.cacheContent) {
            this.contentStale = false;
            if (logger.isDebugEnabled()) {
                logger.debug("WebPagePortlet caching URL: " + url + " Expiration: " + pageExpiration + ", " + (pageExpiration - System.currentTimeMillis()) + " milliseconds into the future");
            }
            this.setExpirationMillis(pageExpiration);
        } else {
            this.contentStale = true;
        }
        return rdr;
    }

    public ConcreteElement getContent(RunData data) {
        PortletConfig config = this.getPortletConfig();
        if (this.contentStale) {
            return this.getWebPageContent(data, config);
        }
        if (null == this.getExpirationMillis()) {
            return this.getContent(data, null, true);
        }
        if (this.getExpirationMillis() <= System.currentTimeMillis()) {
            return this.getWebPageContent(data, config);
        }
        return this.getContent(data, null, true);
    }

    private ConcreteElement getWebPageContent(RunData data, PortletConfig config) {
        String convertedString = null;
        JetspeedClearElement element = null;
        String url = this.selectUrl(data, config);
        try {
            JetspeedLink jsLink = JetspeedLinkFactory.getInstance(data);
            Reader htmlReader = this.getReader(url);
            convertedString = this.rewriter.rewrite(htmlReader, ((Object)jsLink).toString());
            element = new JetspeedClearElement(convertedString);
            System.out.println("js link = " + ((Object)jsLink).toString());
            JetspeedLinkFactory.putInstance(jsLink);
            this.clearContent();
            this.setContent((ConcreteElement)element);
            htmlReader.close();
        }
        catch (Exception e) {
            logger.info("Exception occurred:" + e.toString(), e);
        }
        return element;
    }

    public void refresh() {
        if (this.cacheContent) {
            this.getWebPageContent(null, this.getPortletConfig());
        }
    }

    protected String selectUrl(RunData data, PortletConfig config) {
        String url = config.getURL();
        return url;
    }
}

