/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.io.IOException;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.FileWatchPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.jetspeed.util.SimpleTransform;
import org.xml.sax.SAXException;

public class JetspeedContent
extends FileWatchPortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedContent.class.getName());
    public static final String PROVIDER_NAME_KEY = "provider-name";
    private String provider = "";
    private String stylesheet = "";
    private String url = null;
    private long lastModified;

    public void init() throws PortletException {
        PortletConfig config = this.getPortletConfig();
        this.provider = config.getInitParameter(PROVIDER_NAME_KEY);
        if (this.provider == null) {
            throw new PortletException("You need to specify provider-name");
        }
        this.url = JetspeedResources.getString("content.provider." + this.provider + ".url");
        this.stylesheet = JetspeedResources.getString("content.provider." + this.provider + ".stylesheet.url");
        String title = JetspeedResources.getString("content.provider." + this.provider + ".title");
        String description = JetspeedResources.getString("content.provider." + this.provider + ".description");
        this.setTitle(title);
        this.setDescription(description);
        this.setContent(this.parse(this.url));
        if (this.url == null || this.stylesheet == null || title == null || description == null) {
            throw new PortletException("Not all properties defined in JetspeedResources.  See JetspeedResources.properties notes.");
        }
        this.getPortletConfig().setURL(this.url);
        try {
            this.lastModified = JetspeedDiskCache.getInstance().getEntry(this.url).getLastModified();
        }
        catch (IOException e) {
            logger.error("Exception", e);
        }
    }

    private ConcreteElement parse(String url) throws PortletException {
        try {
            url = JetspeedDiskCache.getInstance().getEntry(url).getURL();
            this.stylesheet = JetspeedDiskCache.getInstance().getEntry(this.stylesheet).getURL();
        }
        catch (IOException e) {
            logger.error("Couldn't transform content.", e);
            throw new PortletException("Couldn't transform content.  Please see error log");
        }
        try {
            return new JetspeedClearElement(SimpleTransform.transform(url, this.stylesheet));
        }
        catch (SAXException e) {
            logger.error("Couldn't transform content.", e);
            throw new PortletException("Couldn't transform content.  Please see error log");
        }
    }
}

