/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.controls;

import com.aimluck.eip.util.ALEipUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.PanedPortletController;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.PortletState;
import org.apache.jetspeed.portal.controls.VelocityPortletControl;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class VelocityPortletSetControl
extends VelocityPortletControl {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(VelocityPortletSetControl.class.getName());

    public void buildContext(RunData rundata, Context context) {
        if (this.getPortlet() instanceof PortletSet) {
            context.put("tabs", (Object)this.getTabs((PortletSet)this.getPortlet(), rundata, context));
        }
    }

    private Collection getTabs(PortletSet portlets, RunData rundata, Context context) {
        TreeSet<PortletTab> tabs = new TreeSet<PortletTab>(new PortletTabComparator());
        PanedPortletController controller = null;
        if (portlets.getController() instanceof PanedPortletController) {
            controller = (PanedPortletController)portlets.getController();
        }
        boolean hasAuthority = ALEipUtils.getHasAuthority(rundata, context, 1);
        int count = 0;
        Enumeration en = portlets.getPortlets();
        while (en.hasMoreElements()) {
            String mstate;
            Portlet p = (Portlet)en.nextElement();
            PortalResource portalResource = new PortalResource(p);
            try {
                JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
                portalResource.setOwner(jsLink.getUserName());
                JetspeedLinkFactory.putInstance(jsLink);
            }
            catch (Exception e) {
                logger.warn(e.toString(), e);
                portalResource.setOwner(null);
            }
            JetspeedRunData jdata = (JetspeedRunData)rundata;
            boolean hasView = JetspeedSecurity.checkPermission((JetspeedUser)jdata.getUser(), portalResource, "view");
            if (!(!hasView || p instanceof PortletState && ((PortletState)((Object)p)).isClosed(rundata) || (mstate = p.getAttribute("_menustate", "open", rundata)).equals("closed"))) {
                PortletTab tab = new PortletTab();
                String title = null;
                PortletInstance pi = PersistenceManager.getInstance(p, rundata);
                if (pi != null && (title = pi.getTitle()) == null) {
                    title = p.getTitle() != null ? p.getTitle() : p.getName();
                }
                tab.setTitle(title);
                tab.setPosition(p.getPortletConfig().getPosition());
                if (tabs.contains(tab)) {
                    PortletTab lastTab = (PortletTab)tabs.last();
                    int nextPos = lastTab.getPosition() + 1;
                    tab.setPosition(nextPos);
                }
                if (controller != null) {
                    tab.setSelected(controller.isSelected(p, rundata));
                    tab.setLink(controller.getPortletURI(p, rundata).toString() + "?action=controls.Restore");
                }
                tab.setActions(this.buildActionList(rundata, p, context));
                tab.setAuthority(hasAuthority);
                tabs.add(tab);
            }
            ++count;
        }
        return tabs;
    }

    public class PortletTabComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            try {
                PortletTab pt1 = (PortletTab)o1;
                PortletTab pt2 = (PortletTab)o2;
                int pos1 = pt1.getPosition();
                int pos2 = pt2.getPosition();
                if (pos1 < pos2) {
                    return -1;
                }
                if (pos1 > pos2) {
                    return 1;
                }
                return 0;
            }
            catch (ClassCastException e) {
                logger.error("Exception in compare", e);
                return 0;
            }
        }
    }

    public class PortletTab {
        private String title = null;
        private boolean selected = false;
        private String link = null;
        private List actions = null;
        private int position = -1;
        private boolean authority = true;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public List getActions() {
            return this.actions == null ? new Vector() : this.actions;
        }

        public void setActions(List actions) {
            this.actions = actions;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int pos) {
            this.position = pos;
        }

        public boolean getAuthority() {
            return this.authority;
        }

        public void setAuthority(boolean flg) {
            this.authority = flg;
        }
    }
}

