/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.controls;

import com.aimluck.eip.common.ALFunction;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.PanedPortletController;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.PortletState;
import org.apache.jetspeed.portal.controls.AbstractPortletControl;
import org.apache.jetspeed.portal.security.portlets.PortletWrapper;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.jetspeed.util.template.JetspeedTool;
import org.apache.turbine.services.pull.TurbinePull;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.velocity.context.Context;

public class VelocityPortletControl
extends AbstractPortletControl {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(VelocityPortletControl.class.getName());

    public boolean isCacheable() {
        return false;
    }

    public ConcreteElement getContent(RunData rundata) {
        PortletWrapper wrapper;
        Portlet portlet = this.getPortlet();
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        if (portlet instanceof PortletWrapper && !(wrapper = (PortletWrapper)portlet).getAllowView(rundata) && JetspeedResources.getBoolean("defaultportletcontrol.hide.decorator", true)) {
            return new StringElement("");
        }
        Context context = TurbineVelocity.getContext();
        context.put("data", (Object)rundata);
        context.put("actions", (Object)this.buildActionList(rundata, portlet, context));
        context.put("functions", (Object)this.buildFunctionList(rundata, portlet));
        context.put("conf", (Object)this.getConfig());
        context.put("skin", (Object)portlet.getPortletConfig().getPortletSkin());
        context.put("utils", (Object)new ALCommonUtils());
        TurbinePull.populateContext((Context)context, (RunData)rundata);
        if (jdata.getCustomized() != null && portlet.getName().equals(jdata.getCustomized().getName()) && !portlet.providesCustomization()) {
            context.put("portlet", (Object)JetspeedTool.getCustomizer(portlet));
            context.put("portlet_instance", (Object)JetspeedTool.getCustomizer(portlet));
        } else {
            context.put("portlet", (Object)portlet);
            if (PersistenceManager.getInstance(portlet, (RunData)jdata) == null) {
                context.put("portlet_instance", (Object)portlet);
            } else {
                context.put("portlet_instance", (Object)PersistenceManager.getInstance(portlet, (RunData)jdata));
            }
        }
        this.buildContext(rundata, context);
        String showTab = rundata.getParameters().getString("showTab");
        if (showTab == null || showTab.equals("") || !showTab.equals("false")) {
            showTab = "true";
        }
        context.put("showTab", (Object)showTab);
        try {
            boolean maximized;
            boolean customized = jdata.getMode() == 1;
            boolean bl = maximized = customized || jdata.getMode() == 2;
            if (maximized && "true".equals(showTab)) {
                Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
                context.put("tabs", (Object)this.getTabs(PortalToolkit.getSet(portlets), rundata, context));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String theme = this.getConfig().getInitParameter("theme", "default.vm");
        String s = "";
        try {
            String template = TemplateLocator.locateControlTemplate(rundata, theme);
            TurbineVelocity.handleRequest((Context)context, (String)template, (Writer)rundata.getOut());
        }
        catch (Exception e) {
            logger.error("Exception while creating content ", e);
            s = e.toString();
        }
        TurbineVelocity.requestFinished((Context)context);
        return new StringElement(s);
    }

    public void buildContext(RunData rundata, Context context) {
    }

    protected List buildActionList(RunData rundata, Portlet portlet, Context context) {
        Vector<PortletAction> actions = new Vector<PortletAction>();
        JetspeedLink jsLink = null;
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        if (JetspeedSecurity.areActionsDisabledForAllUsers()) {
            return actions;
        }
        JetspeedUser user = jdata.getJetspeedUser();
        if (JetspeedSecurity.areActionsDisabledForAnon() && !user.hasLoggedIn()) {
            return actions;
        }
        if (portlet instanceof PortletState) {
            PortletState state = (PortletState)((Object)portlet);
            boolean customized = jdata.getMode() == 1;
            boolean maximized = customized || jdata.getMode() == 2;
            context.put("isMaximized", (Object)maximized);
            boolean infoAdded = false;
            if (state.allowCustomize(rundata)) {
                actions.add(new PortletAction("customize", "\u30ab\u30b9\u30bf\u30de\u30a4\u30ba"));
            } else if (state.allowInfo(rundata)) {
                actions.add(new PortletAction("info", "Information"));
                infoAdded = true;
            }
            if (!customized && state.allowPrintFriendly(rundata)) {
                actions.add(new PortletAction("print", "Print Friendly Format"));
            }
            if (!customized && state.allowInfo(rundata) && !infoAdded) {
                actions.add(new PortletAction("info", "Information"));
            }
            if (!customized && !maximized && state.allowClose(rundata)) {
                actions.add(new PortletAction("close", "Close"));
            }
            if (!state.isMinimized(rundata) && !maximized) {
                if (state.allowMinimize(rundata)) {
                    actions.add(new PortletAction("minimize", "Minimize"));
                }
                if (state.allowMaximize(rundata)) {
                    actions.add(new PortletAction("maximize", "Maximize"));
                }
            }
        } else {
            if (portlet.getAllowEdit(rundata)) {
                actions.add(new PortletAction("info", "Information"));
            }
            if (portlet.getAllowMaximize(rundata)) {
                actions.add(new PortletAction("maximize", "Maximize"));
            }
        }
        for (PortletAction action : actions) {
            try {
                jsLink = JetspeedLinkFactory.getInstance(rundata);
            }
            catch (Exception e) {
                logger.error("Exception in buildActionList", e);
            }
            action.setLink(jsLink.setAction(VelocityPortletControl.getAction(action.getName()), portlet).toString());
            JetspeedLinkFactory.putInstance(jsLink);
            jsLink = null;
        }
        return actions;
    }

    protected List buildFunctionList(RunData rundata, Portlet portlet) {
        ArrayList<ALFunction> functions = new ArrayList<ALFunction>();
        try {
            int i = 1;
            Map map = portlet.getPortletConfig().getInitParameters();
            while (map.containsKey("function_mode" + i)) {
                ALFunction function = new ALFunction();
                function.setMode(portlet.getPortletConfig().getInitParameter("function_mode" + i));
                function.setImage(portlet.getPortletConfig().getInitParameter("function_image" + i));
                function.setCaption(portlet.getPortletConfig().getInitParameter("function_caption" + i));
                if (map.containsKey("function_screen" + i)) {
                    function.setScreen(true);
                }
                if (map.containsKey("function_before_function" + i)) {
                    function.setBeforeFunction(portlet.getPortletConfig().getInitParameter("function_before_function" + i));
                }
                if (map.containsKey("function_after_function" + i)) {
                    function.setAfterFunction(portlet.getPortletConfig().getInitParameter("function_after_function" + i));
                }
                functions.add(function);
                ++i;
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
        return functions;
    }

    protected static String getAction(String name) {
        StringBuffer buffer = new StringBuffer("controls.");
        buffer.append(name.substring(0, 1).toUpperCase());
        buffer.append(name.substring(1, name.length()));
        return buffer.toString();
    }

    private Collection getTabs(PortletSet portlets, RunData rundata, Context context) {
        TreeSet<PortletTab> tabs = new TreeSet<PortletTab>(new PortletTabComparator());
        PanedPortletController controller = null;
        if (portlets.getController() instanceof PanedPortletController) {
            controller = (PanedPortletController)portlets.getController();
        }
        boolean hasAuthority = ALEipUtils.getHasAuthority(rundata, context, 1);
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        int count = 0;
        Enumeration en = portlets.getPortlets();
        while (en.hasMoreElements()) {
            String mstate;
            Portlet p = (Portlet)en.nextElement();
            PortalResource portalResource = new PortalResource(p);
            try {
                JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
                portalResource.setOwner(jsLink.getUserName());
                JetspeedLinkFactory.putInstance(jsLink);
            }
            catch (Exception e) {
                logger.warn(e.toString(), e);
                portalResource.setOwner(null);
            }
            boolean hasView = JetspeedSecurity.checkPermission((JetspeedUser)jdata.getUser(), portalResource, "view");
            if (!(!hasView || p instanceof PortletState && ((PortletState)((Object)p)).isClosed(rundata) || (mstate = p.getAttribute("_menustate", "open", rundata)).equals("closed"))) {
                PortletTab tab = new PortletTab();
                String title = null;
                PortletInstance pi = PersistenceManager.getInstance(p, rundata);
                if (pi != null && (title = pi.getTitle()) == null) {
                    title = p.getTitle() != null ? p.getTitle() : p.getName();
                }
                tab.setTitle(title);
                tab.setPosition(p.getPortletConfig().getPosition());
                if (tabs.contains(tab)) {
                    PortletTab lastTab = (PortletTab)tabs.last();
                    int nextPos = lastTab.getPosition() + 1;
                    tab.setPosition(nextPos);
                }
                if (controller != null) {
                    boolean isSelected = false;
                    if (jdata.getMode() == 1) {
                        PortletSet set = (PortletSet)jdata.getCustomized();
                        if (this.isTab(rundata, set.getID())) {
                            if (p.getID().equals(set.getID())) {
                                isSelected = true;
                                controller.savePaneID(rundata, p.getID());
                            }
                        } else {
                            isSelected = controller.isSelected(p, rundata);
                        }
                    } else if (jdata.getMode() == 2) {
                        isSelected = this.containsPeid(rundata, (PortletSet)p, (String)jdata.getUser().getTemp("js_peid"));
                    }
                    tab.setSelected(isSelected);
                    if (this.getPortlet() == null) {
                        tab.setLink(controller.getPortletURI(p, rundata).toString() + "?action=controls.Restore");
                    } else {
                        try {
                            JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
                            DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                            isSelected = this.containsPeid(rundata, (PortletSet)p, this.getPortlet().getID());
                            if (isSelected) {
                                duri = duri.addPathInfo("js_pane", this.getPortlet().getID()).addQueryData("action", "controls.Restore");
                                tab.setLink(duri.toString());
                            } else {
                                tab.setLink(controller.getPortletURI(p, rundata).addQueryData("action", "controls.Restore").toString());
                            }
                        }
                        catch (TurbineException e) {
                            tab.setLink(controller.getPortletURI(p, rundata).addQueryData("action", "controls.Restore").toString());
                        }
                    }
                }
                tab.setActions(this.buildActionList(rundata, p, context));
                tab.setAuthority(hasAuthority);
                tabs.add(tab);
            }
            ++count;
        }
        return tabs;
    }

    private boolean containsPeid(RunData rundata, PortletSet portlets, String selectedPeid) {
        int count = 0;
        Enumeration en = portlets.getPortlets();
        while (en.hasMoreElements()) {
            Portlet p = (Portlet)en.nextElement();
            if (p.getID().equals(selectedPeid)) {
                PortletSet set = PortalToolkit.getSet(((JetspeedRunData)rundata).getProfile().getDocument().getPortlets());
                SessionState state = ((JetspeedRunData)rundata).getPortletSessionState(portlets.getID());
                state.setAttribute("js_pane", portlets.getID());
                return true;
            }
            ++count;
        }
        return false;
    }

    private boolean isTab(RunData rundata, String peid) {
        if (peid == null || peid.equals("")) {
            return false;
        }
        Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
        Portlets[] tabList = portlets.getPortletsArray();
        int length = tabList.length;
        for (int i = 0; i < length; ++i) {
            if (!tabList[i].getId().equals(peid)) continue;
            return true;
        }
        return false;
    }

    protected String retrievePaneIDFromSession(RunData rundata, PortletSet portlets) {
        SessionState state = ((JetspeedRunData)rundata).getPortletSessionState(portlets.getID());
        String pane = (String)state.getAttribute("js_pane");
        if (pane == null && portlets.size() > 0) {
            pane = portlets.getPortletAt(0).getID();
        }
        return pane;
    }

    public class PortletTabComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            try {
                PortletTab pt1 = (PortletTab)o1;
                PortletTab pt2 = (PortletTab)o2;
                int pos1 = pt1.getPosition();
                int pos2 = pt2.getPosition();
                if (pos1 < pos2) {
                    return -1;
                }
                if (pos1 > pos2) {
                    return 1;
                }
                return 0;
            }
            catch (ClassCastException e) {
                logger.error("Exception in compare", e);
                return 0;
            }
        }
    }

    public class PortletTab {
        private String title = null;
        private boolean selected = false;
        private String link = null;
        private List actions = null;
        private int position = -1;
        private final String paneid;
        private boolean authority = true;

        public PortletTab() {
            this.paneid = null;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public List getActions() {
            return this.actions == null ? new Vector() : this.actions;
        }

        public void setActions(List actions) {
            this.actions = actions;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int pos) {
            this.position = pos;
        }

        public boolean getAuthority() {
            return this.authority;
        }

        public void setAuthority(boolean flg) {
            this.authority = flg;
        }
    }

    public class PortletAction {
        String name = null;
        String link = null;
        String alt = null;

        protected PortletAction(String name, String alt) {
            this.name = name;
            this.alt = alt;
        }

        public String getName() {
            return this.name;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String getAlt() {
            return this.alt;
        }
    }
}

