/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.controls;

import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.A;
import org.apache.ecs.html.B;
import org.apache.ecs.html.IMG;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.ecs.wml.P;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.portal.controls.AbstractPortletControl;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.JetspeedException;
import org.apache.jetspeed.util.MimeType;
import org.apache.jetspeed.util.URILookup;
import org.apache.turbine.util.ContentURI;
import org.apache.turbine.util.RunData;

public class TitleControl
extends AbstractPortletControl {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(TitleControl.class.getName());

    public ConcreteElement getContent(RunData rundata) {
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap(rundata);
        if (cm.getPreferredType().equals(MimeType.HTML)) {
            return this.getHTMLContent(rundata);
        }
        if (cm.getPreferredType().equals(MimeType.WML)) {
            return this.getWMLContent(rundata);
        }
        logger.error("The Given MIME-Type is not supportet for this control");
        return null;
    }

    public ConcreteElement getHTMLContent(RunData rundata) {
        ElementContainer base = new ElementContainer();
        Table t = new Table().setBgColor(this.getColor()).setBorder(0).setCellPadding(1).setCellSpacing(0).setWidth(this.getWidth()).setAlign("center");
        ConcreteElement[] options = this.getPortletOptions(rundata);
        TR finalTitle = new TR().setBgColor(this.getTitleColor()).addElement((Element)new TD().setBgColor(this.getTitleColor()).setNoWrap(true).setWidth("100%").setVAlign("middle").addElement((Element)new B().addElement(this.getPortlet().getTitle()).addElement("  ")));
        if (options.length > 0) {
            ElementContainer alloptions = new ElementContainer();
            for (int i = 0; i < options.length; ++i) {
                alloptions.addElement((Element)options[i]);
            }
            finalTitle.addElement((Element)new TD().setBgColor(this.getTitleColor()).setNoWrap(true).setAlign("right").setVAlign("middle").addElement((Element)alloptions));
        }
        t.addElement((Element)finalTitle);
        base.addElement((Element)t);
        return base;
    }

    public ConcreteElement getWMLContent(RunData rundata) {
        ElementContainer ec = new ElementContainer();
        try {
            ec.addElement((Element)new P().addElement((Element)new org.apache.ecs.wml.A(URILookup.getURI(0, 2, this.getName(), rundata)).addElement(this.getTitle())));
        }
        catch (JetspeedException e) {
            logger.error("Exception", e);
        }
        return ec;
    }

    public String getTitle() {
        return this.getPortlet().getTitle();
    }

    public boolean supportsType(MimeType mimeType) {
        if (!MimeType.HTML.equals(mimeType) && !MimeType.WML.equals(mimeType)) {
            return false;
        }
        return this.getPortlet().supportsType(mimeType);
    }

    private ConcreteElement[] getPortletOptions(RunData rundata) {
        Vector<A> v = new Vector<A>();
        ContentURI content = new ContentURI(rundata);
        int type = URILookup.getURIType(this.getPortlet(), rundata);
        int subtype = 0;
        try {
            subtype = URILookup.getURISubType(this.getPortlet(), rundata);
        }
        catch (JetspeedException e) {
            logger.error("Exception", e);
        }
        if (type != 3) {
            if (rundata.getUser() != null && rundata.getUser().hasLoggedIn() && this.getPortlet().getAllowEdit(rundata) && type != 1) {
                try {
                    A edit = new A(URILookup.getURI(1, 3, this.getPortlet(), rundata)).addElement((Element)new IMG(content.getURI(JetspeedResources.INFO_IMAGE)).setBorder(0));
                    v.addElement(edit);
                }
                catch (JetspeedException e) {
                    logger.error("Exception", e);
                }
            }
            if (this.getPortlet().getAllowMaximize(rundata)) {
                try {
                    if (subtype != 2) {
                        A max = new A(URILookup.getURI(0, 2, this.getPortlet(), rundata)).addElement((Element)new IMG(content.getURI(JetspeedResources.MAX_IMAGE)).setBorder(0));
                        v.addElement(max);
                    }
                }
                catch (JetspeedException e) {
                    logger.error("Exception", e);
                }
            }
        }
        Object[] elements = new ConcreteElement[v.size()];
        v.copyInto(elements);
        return elements;
    }
}

