/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.controllers;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletControllerConfig;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.controllers.AbstractPortletController;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class GridPortletController
extends AbstractPortletController {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(GridPortletController.class.getName());
    private int columns = 0;
    private int rows = 0;
    private Vector rowHeights = new Vector();
    private Vector colWidths = new Vector();

    private void calculateControllerLayout(Portlet portlet) {
        int row;
        if (portlet instanceof PortletSet) {
            Enumeration more = ((PortletSet)portlet).getPortlets();
            while (more.hasMoreElements()) {
                this.calculateControllerLayout((Portlet)more.nextElement());
            }
            return;
        }
        PortletConfig portletConf = portlet.getPortletConfig();
        Integer colObj = portletConf.getConstraints().getColumn();
        Integer rowObj = portletConf.getConstraints().getRow();
        int col = colObj != null ? colObj : 0;
        int n = row = rowObj != null ? rowObj : 0;
        if (col + 1 > this.getColumn()) {
            this.setColumn(col + 1);
        }
        if (row + 1 > this.getRow()) {
            this.setRow(row + 1);
        }
    }

    public ConcreteElement getContent(RunData rundata) {
        ElementContainer base = new ElementContainer();
        try {
            int i;
            PortletSet portlets = this.getPortlets();
            PortletConfig pc = portlets.getPortletConfig();
            Enumeration en = portlets.getPortlets();
            while (en.hasMoreElements()) {
                Portlet portlet = (Portlet)en.nextElement();
                this.calculateControllerLayout(portlet);
            }
            this.setWidth(pc.getLayout("width", this.getWidth()));
            int rows = this.getRow();
            int cols = this.getColumn();
            if (0 == rows || 0 == cols) {
                return base;
            }
            Table t = new Table().setWidth(this.getWidth()).setCellPadding(this.getPadding()).setAlign("center");
            base.addElement((Element)t);
            ElementContainer[][] elements = new ElementContainer[rows][cols];
            for (i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    elements[i][j] = new ElementContainer();
                }
            }
            en = portlets.getPortlets();
            while (en.hasMoreElements()) {
                Portlet p = (Portlet)en.nextElement();
                PortletConfig pConf = p.getPortletConfig();
                Integer colObj = pConf.getConstraints().getColumn();
                Integer rowObj = pConf.getConstraints().getRow();
                int colnum = colObj != null ? colObj : 0;
                int rownum = rowObj != null ? rowObj : 0;
                elements[rownum % rows][colnum % cols].addElement((Element)p.getContent(rundata));
            }
            for (i = 0; i < rows; ++i) {
                TR row = new TR();
                TD td = null;
                for (int j = 0; j < cols; ++j) {
                    td = new TD().setVAlign("top").addElement((Element)elements[i][j]);
                    row.addElement((Element)td);
                    if (this.getRowHeight(i) != null) {
                        td.setHeight(this.getRowHeight(i));
                    }
                    if (this.getColumnWidth(j) == null) continue;
                    td.setWidth(this.getColumnWidth(j));
                }
                t.addElement((Element)row);
            }
        }
        catch (Exception e) {
            logger.error("getContent():", e);
        }
        return base;
    }

    public void init() {
        super.init();
        PortletControllerConfig conf = this.getConfig();
        if (conf != null) {
            this.setColumn(Integer.parseInt(conf.getInitParameter("column", "0")));
            this.setRow(Integer.parseInt(conf.getInitParameter("row", "0")));
            this.setColumnsWidth(this.parseList(conf.getInitParameter("columnWidths")));
            this.setRowsHeight(this.parseList(conf.getInitParameter("rowHeights")));
        }
    }

    public void setColumn(int col) {
        this.columns = col;
    }

    public int getColumn() {
        return this.columns;
    }

    public void setRow(int row) {
        this.rows = row;
    }

    public int getRow() {
        return this.rows;
    }

    public void setColumnsWidth(Vector widths) {
        this.colWidths = widths;
    }

    public Enumeration getColumnsWidth() {
        return this.colWidths.elements();
    }

    public String getColumnWidth(int pos) {
        if (pos < this.colWidths.size()) {
            return (String)this.colWidths.elementAt(pos);
        }
        return null;
    }

    public void setRowsHeight(Vector heights) {
        this.rowHeights = heights;
    }

    public Enumeration getRowsHeight() {
        return this.rowHeights.elements();
    }

    public String getRowHeight(int pos) {
        if (pos < this.rowHeights.size()) {
            return (String)this.rowHeights.elementAt(pos);
        }
        return null;
    }

    private Vector parseList(String list) {
        Vector<String> v = new Vector<String>();
        if (list != null) {
            StringTokenizer st = new StringTokenizer(list, ",");
            while (st.hasMoreTokens()) {
                v.addElement(st.nextToken());
            }
        }
        return v;
    }
}

