/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.security.ldap;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.ldap.BaseLDAPObject;
import org.apache.jetspeed.services.JetspeedAuthentication;
import org.apache.jetspeed.services.JetspeedLDAP;
import org.apache.jetspeed.services.JetspeedUserManagement;
import org.apache.jetspeed.services.ldap.LDAPURL;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.UserException;
import org.apache.turbine.util.ObjectUtils;

public class LDAPUser
extends BaseLDAPObject
implements JetspeedUser,
HttpSessionBindingListener {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(LDAPUser.class.getName());
    protected static final String OBJECT_CLASS = "jetspeeduser";
    protected static final String ORGANIZATIONAL_UNIT = "ou=users";
    protected static final String ATTR_UID = "uid";
    protected static final String ATTR_UID_NUMBER = "uidNumber";
    protected static final String ATTR_USER_PASSWORD = "userPassword";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_GIVEN_NAME = "givenName";
    protected static final String ATTR_SN = "sn";
    protected static final String ATTR_MAIL = "mail";
    protected static final String ATTR_OBJECT_DATA = "objectdata";
    protected static final String ATTR_OBJECT_CLASS = "objectClass";
    protected static final String ATTR_USER_GROUP_ROLE = "usergrouprole";
    protected static final String ATTR_LAST_LOGIN_DATE = "lastlogindate";
    protected static final String ATTR_LAST_MODIFIED_DATE = "lastmodifieddate";
    protected static final String ATTR_CREATION_DATE = "creationdate";
    protected static final String ATTR_CONFIRMED = "confirm";
    protected static final String ATTR_DISABLED = "disabled";
    private Date createDate = null;
    private Date lastAccessDate = null;
    private Date passwordChanged = null;
    private Hashtable permStorage = null;
    private Hashtable tempStorage = null;
    protected String name = "";
    protected Vector groupRoles = null;

    public LDAPUser() {
        this("TempUser", true);
    }

    public LDAPUser(String username, boolean isNew) {
        this.ldapurl = JetspeedLDAP.buildURL("uid=" + username + "," + ORGANIZATIONAL_UNIT);
        this.isNew = isNew;
        this.lastAccessDate = this.createDate = new Date();
        this.tempStorage = new Hashtable(20);
        this.permStorage = new Hashtable(50);
        this.groupRoles = new Vector();
        this.setHasLoggedIn(Boolean.FALSE);
        if (isNew) {
            this.setDisabled(false);
            this.setUserName(username);
            String uidNumber = Long.valueOf(System.currentTimeMillis()).toString();
            this.setUserId(uidNumber);
            this.myAttrs = new BasicAttributes();
            this.myAttrs.put(ATTR_UID, username);
            this.myAttrs.put(ATTR_UID_NUMBER, uidNumber);
            BasicAttribute oc = new BasicAttribute(ATTR_OBJECT_CLASS);
            oc.add(OBJECT_CLASS);
            this.myAttrs.put(oc);
        } else {
            this.myAttrs = JetspeedLDAP.read(this.ldapurl);
            this.fillObject(this.myAttrs);
        }
    }

    public LDAPUser(LDAPURL ldapurl) {
        this.fillObject(JetspeedLDAP.read(ldapurl));
    }

    public LDAPUser(Attributes attributes) {
        this.fillObject(attributes);
    }

    private void fillObject(Attributes attributes) {
        this.tempStorage = new Hashtable(20);
        this.permStorage = new Hashtable(50);
        this.setHasLoggedIn(Boolean.FALSE);
        this.myAttrs = attributes;
        try {
            this.setPermStorage(this.deserializePerm(this.getutil(ATTR_OBJECT_DATA, attributes)));
        }
        catch (Exception e) {
            logger.error("fillobject()", e);
        }
        this.setUserName(this.getutil(ATTR_UID, attributes));
        this.setUserId(this.getutil(ATTR_UID_NUMBER, attributes));
        this.setEmail(this.getutil(ATTR_MAIL, attributes));
        this.setFirstName(this.getutil(ATTR_GIVEN_NAME, attributes));
        this.setLastName(this.getutil(ATTR_SN, attributes));
        this.setConfirmed(this.getutil(ATTR_CONFIRMED, attributes));
        this.setLastLogin(this.parseDate(this.getutil(ATTR_LAST_LOGIN_DATE, attributes)));
        this.lastAccessDate = this.parseDate(this.getutil(ATTR_LAST_MODIFIED_DATE, attributes));
        this.setCreateDate(this.parseDate(this.getutil(ATTR_CREATION_DATE, attributes)));
        String temp = this.getutil(ATTR_DISABLED, attributes);
        if (temp != null && temp.equals("TRUE")) {
            this.setDisabled(true);
        } else {
            this.setDisabled(false);
        }
        try {
            this.setPassword(new String((byte[])attributes.get(ATTR_USER_PASSWORD).getAll().nextElement()));
        }
        catch (Exception e) {
            logger.error("fillobject() could not set password", e);
        }
        this.groupRoles = this.getutil(ATTR_USER_GROUP_ROLE, attributes, true);
        this.ldapurl = JetspeedLDAP.buildURL("uid=" + this.getUserName() + "," + ORGANIZATIONAL_UNIT);
    }

    public void update(boolean create) throws JetspeedSecurityException {
        this.removeutil("createTimeStamp", false);
        this.removeutil("modifyTimeStamp", false);
        this.setutil(ATTR_USER_PASSWORD, (String)this.getPerm("PASSWORD_VALUE"));
        this.setutil(ATTR_MAIL, (String)this.getPerm("EMAIL"));
        this.setutil(ATTR_CONFIRMED, (String)this.getPerm("CONFIRM_VALUE"));
        this.setutil(ATTR_SN, (String)this.getPerm("LAST_NAME"));
        this.setutil(ATTR_GIVEN_NAME, (String)this.getPerm("FIRST_NAME"));
        this.setutil(ATTR_USER_GROUP_ROLE, this.getGroupRoles(), create);
        this.setutil(ATTR_LAST_LOGIN_DATE, this.formatDate(this.getLastLogin()));
        this.setutil(ATTR_LAST_MODIFIED_DATE, this.formatDate(this.getLastAccessDate()));
        this.setutil(ATTR_CREATION_DATE, this.formatDate(this.getCreateDate()));
        if (this.getDisabled()) {
            this.setutil(ATTR_DISABLED, "TRUE");
        } else {
            this.setutil(ATTR_DISABLED, "FALSE");
        }
        try {
            this.setutil(ATTR_OBJECT_DATA, this.serializePerm(this.permStorage));
        }
        catch (Exception e) {
            logger.warn("Could not serialize object data!", e);
        }
        if (create) {
            this.ldapurl = JetspeedLDAP.buildURL("uid=" + (String)this.getPerm("LOGIN_NAME") + ",ou=users");
            this.setutil(ATTR_UID, (String)this.getPerm("LOGIN_NAME"));
            if (!JetspeedLDAP.addEntry(this.ldapurl, this.myAttrs)) {
                throw new UserException("Could not insert user data to LDAP!");
            }
        } else if (JetspeedLDAP.exists(this.ldapurl)) {
            JetspeedLDAP.deleteAttrs(this.ldapurl, this.rmAttrs);
            if (!JetspeedLDAP.updateEntry(this.ldapurl, this.myAttrs)) {
                throw new UserException("Could not update user data to LDAP!");
            }
        }
    }

    public Vector getGroupRoles() {
        return this.groupRoles;
    }

    public void addGroupRole(String groupName, String roleName) {
        this.groupRoles.add(groupName + "," + roleName);
    }

    public void removeGroup(String groupName) {
        Enumeration enu = this.groupRoles.elements();
        while (enu.hasMoreElements()) {
            String groupRoleStr = (String)enu.nextElement();
            if (!groupRoleStr.startsWith(groupName + ",")) continue;
            this.groupRoles.remove(groupRoleStr);
        }
    }

    public void removeGroupRole(String groupName, String roleName) {
        Enumeration enu = this.groupRoles.elements();
        while (enu.hasMoreElements()) {
            String groupRoleStr = (String)enu.nextElement();
            if (!groupRoleStr.equalsIgnoreCase(groupName + "," + roleName)) continue;
            this.groupRoles.remove(groupRoleStr);
        }
    }

    public String getUserId() {
        String tmp = null;
        try {
            tmp = (String)this.getPerm("USER_ID");
            if (tmp.length() == 0) {
                tmp = null;
            }
        }
        catch (Exception e) {
            logger.error("getUserId():", e);
        }
        return tmp;
    }

    public void setUserId(String id) {
        if (this.getUserId() == null) {
            this.setPerm("USER_ID", id);
        }
    }

    public int getAccessCounterForSession() {
        try {
            return (Integer)this.getTemp("_session_access_counter");
        }
        catch (Exception e) {
            logger.error("getAccessCounterForSession():", e);
            return 0;
        }
    }

    public int getAccessCounter() {
        try {
            return (Integer)this.getPerm("_access_counter");
        }
        catch (Exception e) {
            logger.error("getAccessCounter():", e);
            return 0;
        }
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getLastAccessDate() {
        if (this.lastAccessDate == null) {
            this.setLastAccessDate();
        }
        return this.lastAccessDate;
    }

    public Date getLastLogin() {
        return (Date)this.getPerm("LAST_LOGIN");
    }

    public String getPassword() {
        return (String)this.getPerm("PASSWORD_VALUE");
    }

    public Object getPerm(String name) {
        return this.permStorage.get(name);
    }

    public Object getPerm(String name, Object def) {
        try {
            Object val = this.permStorage.get(name);
            return val == null ? def : val;
        }
        catch (Exception e) {
            logger.error("getPerm():", e);
            return def;
        }
    }

    public Hashtable getPermStorage() {
        if (this.permStorage == null) {
            this.permStorage = new Hashtable(50);
        }
        return this.permStorage;
    }

    public Object getTemp(String name) {
        return this.tempStorage.get(name);
    }

    public Object getTemp(String name, Object def) {
        Object val;
        try {
            val = this.tempStorage.get(name);
            if (val == null) {
                val = def;
            }
        }
        catch (Exception e) {
            logger.error("getTemp():", e);
            val = def;
        }
        return val;
    }

    public String getUserName() {
        String tmp = null;
        try {
            tmp = (String)this.getPerm("LOGIN_NAME");
            if (tmp.length() == 0) {
                tmp = null;
            }
        }
        catch (Exception e) {
            logger.error("getUserName():", e);
        }
        return tmp;
    }

    public String getFirstName() {
        String tmp = null;
        try {
            tmp = (String)this.getPerm("FIRST_NAME");
            if (tmp.length() == 0) {
                tmp = null;
            }
        }
        catch (Exception e) {
            logger.error("getFirstName():", e);
        }
        return tmp;
    }

    public String getLastName() {
        String tmp = null;
        try {
            tmp = (String)this.getPerm("LAST_NAME");
            if (tmp.length() == 0) {
                tmp = null;
            }
        }
        catch (Exception e) {
            logger.error("getLastName():", e);
        }
        return tmp;
    }

    public boolean hasLoggedIn() {
        Boolean loggedIn = this.getHasLoggedIn();
        return loggedIn != null && loggedIn != false;
    }

    public String getEmail() {
        return (String)this.getPerm("EMAIL");
    }

    public void incrementAccessCounter() {
        this.setAccessCounter(this.getAccessCounter() + 1);
    }

    public void incrementAccessCounterForSession() {
        this.setAccessCounterForSession(this.getAccessCounterForSession() + 1);
    }

    public Object removeTemp(String name) {
        return this.tempStorage.remove(name);
    }

    public void setAccessCounter(int cnt) {
        this.setPerm("_access_counter", cnt);
    }

    public void setAccessCounterForSession(int cnt) {
        this.setTemp("_session_access_counter", cnt);
    }

    public void setLastAccessDate() {
        this.lastAccessDate = new Date();
    }

    public void setCreateDate(Date date) {
        this.createDate = date;
    }

    public void setLastLogin(Date date) {
        this.setPerm("LAST_LOGIN", date);
    }

    public void setPassword(String password) {
        this.setPerm("PASSWORD_VALUE", password);
    }

    public void setPerm(String name, Object value) {
        ObjectUtils.safeAddToHashtable((Hashtable)this.getPermStorage(), (Object)name, (Object)value);
    }

    public void setPermStorage(Hashtable stuff) {
        this.permStorage = stuff;
    }

    public Hashtable getTempStorage() {
        if (this.tempStorage == null) {
            this.tempStorage = new Hashtable(20);
        }
        return this.tempStorage;
    }

    public void setTempStorage(Hashtable storage) {
        this.tempStorage = storage;
    }

    private Boolean getHasLoggedIn() {
        return (Boolean)this.getTemp("_has_logged_in");
    }

    public void setHasLoggedIn(Boolean value) {
        this.setTemp("_has_logged_in", value);
    }

    public void setTemp(String name, Object value) {
        ObjectUtils.safeAddToHashtable((Hashtable)this.tempStorage, (Object)name, (Object)value);
    }

    public void setUserName(String username) {
        this.setPerm("LOGIN_NAME", username);
    }

    public void setFirstName(String firstName) {
        this.setPerm("FIRST_NAME", firstName);
    }

    public void setLastName(String lastName) {
        this.setPerm("LAST_NAME", lastName);
    }

    public void setEmail(String address) {
        this.setPerm("EMAIL", address);
    }

    public boolean isConfirmed() {
        String value = this.getConfirmed();
        return value != null && value.equals("CONFIRMED");
    }

    public void setConfirmed(String value) {
        String val = "";
        if (value != null) {
            val = value;
        }
        this.setPerm("CONFIRM_VALUE", val);
    }

    public String getConfirmed() {
        return (String)this.getPerm("CONFIRM_VALUE");
    }

    public void updateLastLogin() throws Exception {
        this.setPerm("LAST_LOGIN", new Date());
    }

    public void valueBound(HttpSessionBindingEvent hsbe) {
    }

    public void valueUnbound(HttpSessionBindingEvent hsbe) {
        try {
            if (this.hasLoggedIn()) {
                if (JetspeedResources.getBoolean("automatic.logout.save", false)) {
                    JetspeedUserManagement.saveUser(this);
                }
                JetspeedAuthentication.logout();
            }
        }
        catch (Exception e) {
            logger.error("LDAPUser.valueUnbound(): " + e.getMessage(), e);
            ByteArrayOutputStream ostr = new ByteArrayOutputStream();
            e.printStackTrace(new PrintWriter(ostr, true));
            String stackTrace = ostr.toString();
            System.out.println(stackTrace);
        }
    }

    public void save() throws Exception {
        if (this.isNew()) {
            JetspeedUserManagement.saveUser(this);
        } else {
            JetspeedUserManagement.addUser(this);
        }
    }

    public boolean getDisabled() {
        boolean disabled = false;
        try {
            String tmp = (String)this.getPerm("DISABLED");
            if (tmp != null && tmp.length() > 0 && tmp.equalsIgnoreCase("T")) {
                disabled = true;
            }
        }
        catch (Exception e) {
            logger.error("getDisabled():", e);
        }
        return disabled;
    }

    public void setDisabled(boolean disabled) {
        this.setPerm("DISABLED", disabled ? "T" : "F");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNew() {
        return this.isNew;
    }

    void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public Date getPasswordChanged() {
        return this.passwordChanged;
    }

    public void setPasswordChanged(Date value) {
        this.passwordChanged = value;
    }
}

