/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.security.ldap;

import java.util.Vector;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.ldap.BaseLDAPObject;
import org.apache.jetspeed.services.JetspeedLDAP;
import org.apache.jetspeed.services.ldap.LDAPURL;
import org.apache.jetspeed.services.security.RoleException;

public class LDAPRole
extends BaseLDAPObject
implements Role {
    protected static final String OBJECT_CLASS = "jetspeedrole";
    protected static final String ORGANIZATIONAL_UNIT = "ou=roles";
    protected static final String ATTR_ROLE_PERMISSIONS = "rolepermissions";
    protected static final String ATTR_ROLE_NAME = "rolename";
    protected static final String ATTR_ROLE_ID = "uid";
    protected String name = null;
    protected String id = null;
    protected Vector rolePermissions = null;
    protected boolean isNew = true;

    public LDAPRole() {
        this.rolePermissions = new Vector();
        this.isNew = true;
    }

    public LDAPRole(String id) {
        this.setId(id);
        this.isNew = true;
        this.rolePermissions = new Vector();
    }

    public LDAPRole(String name, boolean isNew) {
        name = super.createId(name);
        this.ldapurl = JetspeedLDAP.buildURL("uid=" + name + "," + ORGANIZATIONAL_UNIT);
        this.isNew = isNew;
        if (isNew) {
            this.rolePermissions = new Vector();
            this.setName(name);
            this.myAttrs = new BasicAttributes();
            this.myAttrs.put(ATTR_ROLE_ID, this.id);
            this.myAttrs.put(ATTR_ROLE_NAME, this.name);
            super.setObjectClass(OBJECT_CLASS);
        } else {
            this.myAttrs = JetspeedLDAP.read(this.ldapurl);
            this.id = this.getutil(ATTR_ROLE_ID);
            this.name = this.getutil(ATTR_ROLE_NAME);
            this.rolePermissions = this.getutil(ATTR_ROLE_PERMISSIONS, true);
        }
    }

    public LDAPRole(LDAPURL ldapurl) {
        this.ldapurl = ldapurl;
        this.myAttrs = JetspeedLDAP.read(ldapurl);
        this.id = this.getutil(ATTR_ROLE_ID);
        this.name = this.getutil(ATTR_ROLE_NAME);
        this.rolePermissions = this.getutil(ATTR_ROLE_PERMISSIONS, true);
    }

    public void update(boolean create) throws RoleException {
        this.removeutil("createTimeStamp", false);
        this.removeutil("modifyTimeStamp", false);
        this.setutil(ATTR_ROLE_PERMISSIONS, this.rolePermissions, create);
        if (create) {
            if (!JetspeedLDAP.addEntry(this.ldapurl, this.myAttrs)) {
                throw new RoleException("Failed to insert role in LDAP!");
            }
        } else if (JetspeedLDAP.exists(this.ldapurl)) {
            JetspeedLDAP.deleteAttrs(this.ldapurl, this.rmAttrs);
            if (!JetspeedLDAP.updateEntry(this.ldapurl, this.myAttrs)) {
                throw new RoleException("Failed to update role in LDAP!");
            }
        }
    }

    public void removePreviousPermissionsFromLDAP() {
        Vector previousPermissions = this.getutil(ATTR_ROLE_PERMISSIONS, true);
        BasicAttributes attrs = new BasicAttributes();
        for (int i = 0; i < previousPermissions.size(); ++i) {
            String uid = (String)previousPermissions.get(i);
            attrs.put(ATTR_ROLE_PERMISSIONS, uid);
        }
        JetspeedLDAP.deleteAttrs(this.ldapurl, attrs);
    }

    public Attribute toAttribute(String id, Vector values) {
        BasicAttribute attr = new BasicAttribute(id);
        for (int i = 0; i < values.size(); ++i) {
            String uid = (String)values.get(i);
            attr.add(uid);
        }
        return attr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String roleName) {
        this.setId(roleName);
        this.name = super.createId(roleName);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (this.id == null) {
            this.id = super.createId(id);
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public Vector getRolePermissions() {
        return this.rolePermissions;
    }

    public void addRolePermissions(String rolePermission) {
        if (!this.permissionExists(rolePermission)) {
            this.rolePermissions.add(rolePermission);
        }
    }

    public void removeRolePermissions(String rolePermission) {
        this.rolePermissions.remove(rolePermission);
    }

    public boolean permissionExists(String rolePermission) {
        return this.rolePermissions.indexOf(rolePermission) != -1;
    }
}

