/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.security.ldap;

import javax.naming.directory.BasicAttributes;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.om.security.ldap.BaseLDAPObject;
import org.apache.jetspeed.services.JetspeedLDAP;
import org.apache.jetspeed.services.ldap.LDAPURL;
import org.apache.jetspeed.services.security.PermissionException;

public class LDAPPermission
extends BaseLDAPObject
implements Permission {
    protected static final String OBJECT_CLASS = "jetspeedpermission";
    protected static final String ORGANIZATIONAL_UNIT = "ou=permissions";
    protected static final String ATTR_PERMISSION_NAME = "permissionname";
    protected static final String ATTR_PERMISSION_ID = "uid";
    protected String name = null;
    protected String id = null;
    protected boolean isNew = true;

    public LDAPPermission() {
        this.isNew = true;
    }

    public LDAPPermission(String id) {
        this.setId(id);
        this.isNew = true;
    }

    public LDAPPermission(String name, boolean isNew) {
        name = super.createId(name);
        this.ldapurl = JetspeedLDAP.buildURL("uid=" + name + "," + ORGANIZATIONAL_UNIT);
        this.isNew = isNew;
        if (isNew) {
            this.setName(name);
            this.myAttrs = new BasicAttributes();
            this.myAttrs.put(ATTR_PERMISSION_ID, this.id);
            this.myAttrs.put(ATTR_PERMISSION_NAME, name);
            super.setObjectClass(OBJECT_CLASS);
        } else {
            this.myAttrs = JetspeedLDAP.read(this.ldapurl);
            this.id = super.getutil(ATTR_PERMISSION_ID);
            this.name = super.getutil(ATTR_PERMISSION_NAME);
        }
    }

    public LDAPPermission(LDAPURL ldapurl) {
        this.ldapurl = ldapurl;
        this.myAttrs = JetspeedLDAP.read(ldapurl);
        this.id = super.getutil(ATTR_PERMISSION_ID);
        this.name = super.getutil(ATTR_PERMISSION_NAME);
    }

    public void update(boolean create) throws PermissionException {
        this.removeutil("createTimeStamp", false);
        this.removeutil("modifyTimeStamp", false);
        if (create) {
            if (!JetspeedLDAP.addEntry(this.ldapurl, this.myAttrs)) {
                throw new PermissionException("Could not insert permission in LDAP!");
            }
        } else if (JetspeedLDAP.exists(this.ldapurl)) {
            JetspeedLDAP.deleteAttrs(this.ldapurl, this.rmAttrs);
            if (!JetspeedLDAP.updateEntry(this.ldapurl, this.myAttrs)) {
                throw new PermissionException("Could not update permission in LDAP!");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String permissionName) {
        this.setId(permissionName);
        this.name = super.createId(permissionName);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (this.id == null) {
            this.id = super.createId(id);
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    void setNew(boolean isNew) {
        this.isNew = isNew;
    }
}

