/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.security.ldap;

import javax.naming.directory.BasicAttributes;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.ldap.BaseLDAPObject;
import org.apache.jetspeed.services.JetspeedLDAP;
import org.apache.jetspeed.services.ldap.LDAPURL;
import org.apache.jetspeed.services.security.GroupException;

public class LDAPGroup
extends BaseLDAPObject
implements Group {
    protected static final String OBJECT_CLASS = "jetspeedgroup";
    protected static final String ORGANIZATIONAL_UNIT = "ou=groups";
    protected static final String ATTR_GROUP_NAME = "groupname";
    protected static final String ATTR_GROUP_ID = "uid";
    protected String name = null;
    protected String id = null;
    protected boolean isNew = true;

    public LDAPGroup() {
        this.isNew = true;
    }

    public LDAPGroup(String id) {
        this.setId(id);
        this.isNew = true;
    }

    public LDAPGroup(String name, boolean isNew) {
        name = super.createId(name);
        this.ldapurl = JetspeedLDAP.buildURL("uid=" + name + "," + ORGANIZATIONAL_UNIT);
        this.isNew = isNew;
        if (isNew) {
            this.setName(name);
            this.myAttrs = new BasicAttributes();
            this.myAttrs.put(ATTR_GROUP_ID, this.getId());
            this.myAttrs.put(ATTR_GROUP_NAME, this.getName());
            super.setObjectClass(OBJECT_CLASS);
        } else {
            this.myAttrs = JetspeedLDAP.read(this.ldapurl);
            this.id = this.getutil(ATTR_GROUP_ID);
            this.name = this.getutil(ATTR_GROUP_NAME);
        }
    }

    public LDAPGroup(LDAPURL ldapurl) {
        this.ldapurl = ldapurl;
        this.myAttrs = JetspeedLDAP.read(ldapurl);
        this.id = this.getutil(ATTR_GROUP_ID);
        this.name = this.getutil(ATTR_GROUP_NAME);
    }

    public void update(boolean create) throws GroupException {
        this.removeutil("createTimeStamp", false);
        this.removeutil("modifyTimeStamp", false);
        if (create) {
            if (!JetspeedLDAP.addEntry(this.ldapurl, this.myAttrs)) {
                throw new GroupException("Failed to insert group in LDAP!");
            }
        } else if (JetspeedLDAP.exists(this.ldapurl)) {
            JetspeedLDAP.deleteAttrs(this.ldapurl, this.rmAttrs);
            if (!JetspeedLDAP.updateEntry(this.ldapurl, this.myAttrs)) {
                throw new GroupException("Failed to update group in LDAP!");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String groupName) {
        this.setId(groupName);
        this.name = super.createId(groupName);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (this.id == null) {
            this.id = super.createId(id);
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    void setNew(boolean isNew) {
        this.isNew = isNew;
    }
}

