/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.security.ldap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.jetspeed.services.ldap.LDAPURL;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.Base64;

public class BaseLDAPObject
implements DirContext {
    protected static final String OK = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    protected static final String LDAP_DATE_PATTERN = "yyyyMMddmmHHss'Z'";
    protected LDAPURL ldapurl = null;
    protected boolean updated = false;
    protected String name = null;
    protected String id = null;
    protected Attributes myAttrs = null;
    protected boolean isNew = false;
    protected BasicAttributes rmAttrs = new BasicAttributes();
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BaseLDAPObject.class.getName());

    public String createId(String value) {
        value = value.replace('\u00e5', 'a');
        value = value.replace('\u00e4', 'a');
        value = value.replace('\u00f6', 'o');
        value = value.replace('\u00c5', 'A');
        value = value.replace('\u00c4', 'A');
        value = value.replace('\u00d6', 'O');
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            if (this.isOK(currentChar)) {
                buf.append(currentChar);
                continue;
            }
            buf.append('X');
        }
        return buf.toString();
    }

    public boolean isOK(char value) {
        for (int i = 0; i < OK.length(); ++i) {
            if (value != OK.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public void setObjectClass(String name) {
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add(name);
        this.myAttrs.put(oc);
    }

    public void setObjectClasses(String[] names) {
        BasicAttribute oc = new BasicAttribute("objectclass");
        for (int i = 0; i < names.length; ++i) {
            oc.add(names[i]);
        }
        this.myAttrs.put(oc);
    }

    protected String formatDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat formatter = new SimpleDateFormat(LDAP_DATE_PATTERN);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter.format(date);
    }

    protected Date parseDate(String value) {
        return this.parseDate(value, true);
    }

    protected Date parseDate(String value, boolean initializeIfNotSet) {
        try {
            SimpleDateFormat parser = new SimpleDateFormat(LDAP_DATE_PATTERN);
            parser.setTimeZone(TimeZone.getTimeZone("GMT"));
            return parser.parse(value);
        }
        catch (Exception e) {
            logger.warn("Could not parse date '" + value + "'");
            if (initializeIfNotSet) {
                return new Date();
            }
            return null;
        }
    }

    protected String serializePerm(Hashtable permStorage) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(baos);
        os.writeObject(permStorage);
        return Base64.encodeAsString(baos.toByteArray());
    }

    protected Hashtable deserializePerm(String permStorageContentsEncoded) throws Exception {
        byte[] decoded = Base64.decodeAsByteArray(permStorageContentsEncoded);
        ByteArrayInputStream bais = new ByteArrayInputStream(decoded);
        ObjectInputStream is = new ObjectInputStream(bais);
        return (Hashtable)is.readObject();
    }

    public boolean getupdated() {
        return this.updated;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String Id) {
        this.id = Id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
    }

    public LDAPURL getldapurl() {
        return this.ldapurl;
    }

    public void setLdapUrl(LDAPURL url) {
        this.ldapurl = url;
    }

    public boolean isNew() {
        return this.isNew;
    }

    protected void removeutil(String field, boolean updatable) {
        this.myAttrs.remove(field);
        if (updatable) {
            this.rmAttrs.remove(field);
        }
    }

    protected void setutil(String field, String value) {
        this.myAttrs.remove(field);
        if (value == null || value.length() == 0) {
            value = " ";
        }
        this.myAttrs.put(field, value);
        this.updated = true;
    }

    protected void setutil(String field, Vector values) {
        this.setutil(field, values, false);
    }

    protected void setutil(String field, Vector values, boolean create) {
        this.myAttrs.remove(field);
        if (values == null || values.size() == 0 && create) {
            this.updated = true;
            return;
        }
        BasicAttribute attr = new BasicAttribute(field);
        Enumeration enu = values.elements();
        while (enu.hasMoreElements()) {
            String nextValue = (String)enu.nextElement();
            attr.add(nextValue);
        }
        this.myAttrs.put(attr);
        this.updated = true;
    }

    protected void setutil(String field, Object value) {
        this.myAttrs.remove(field);
        this.myAttrs.put(field, value);
        this.updated = true;
    }

    protected String getutil(String field) {
        return this.getutil(field, this.myAttrs);
    }

    protected Vector getutil(String field, boolean empty) {
        return this.getutil(field, this.myAttrs, empty);
    }

    protected String getutil(String field, Attributes attrs) {
        if (attrs.get(field) == null) {
            return "";
        }
        try {
            return attrs.get(field).getAll().next().toString();
        }
        catch (NamingException e) {
            logger.warn("getUtil(): " + e.getMessage(), e);
            return "";
        }
    }

    protected String fastgetutil(String field, Attributes attrs) throws NamingException {
        Attribute values = attrs.get(field);
        if (values == null) {
            return "";
        }
        NamingEnumeration<?> e = values.getAll();
        if (e == null || !e.hasMore()) {
            return "";
        }
        return e.next().toString();
    }

    protected Vector getutil(String field, Attributes attrs, boolean empty) {
        Vector<String> values = null;
        if (empty) {
            values = new Vector<String>();
        }
        if (attrs.get(field) != null) {
            try {
                NamingEnumeration<?> enu = attrs.get(field).getAll();
                while (enu.hasMore()) {
                    String temp = (String)enu.nextElement();
                    if (null == temp) continue;
                    values.add(temp);
                }
            }
            catch (NamingException e) {
                logger.warn("getUtil(): " + e.getMessage(), e);
            }
        }
        return values;
    }

    public Attributes getAttributes(String name) throws NamingException {
        if (!name.equals("")) {
            throw new NameNotFoundException();
        }
        return this.myAttrs;
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(String name, String[] ids) throws NamingException {
        if (!name.equals("")) {
            throw new NameNotFoundException();
        }
        BasicAttributes answer = new BasicAttributes(true);
        for (int i = 0; i < ids.length; ++i) {
            Attribute target = this.myAttrs.get(ids[i]);
            if (target == null) continue;
            answer.put(target);
        }
        return answer;
    }

    public Attributes getAttributes(Name name, String[] ids) throws NamingException {
        return this.getAttributes(name.toString(), ids);
    }

    public String toString() {
        return this.ldapurl.getUrl();
    }

    public Object lookup(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookup(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void close() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchema(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }
}

