/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.security;

import org.apache.jetspeed.om.security.BaseJetspeedUser;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.security.UserException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class JetspeedUserFactory {
    private static final String CONFIG_USER_CLASSNAME = "user.class";
    private static String userClassName = null;
    private static Class userClass = null;

    public static JetspeedUser getInstance() throws UserException {
        return JetspeedUserFactory.getInstance(true);
    }

    public static JetspeedUser getInstance(boolean isNew) throws UserException {
        JetspeedUser user = null;
        if (null == userClassName) {
            try {
                ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
                userClassName = serviceConf.getString(CONFIG_USER_CLASSNAME);
                userClass = Class.forName(userClassName);
            }
            catch (Exception e) {
                throw new UserException("JetspeedUserFactory: Failed to create a Class object for User implementation: " + e.toString());
            }
        }
        try {
            user = (JetspeedUser)userClass.newInstance();
            if (user instanceof BaseJetspeedUser) {
                ((BaseJetspeedUser)user).setNew(isNew);
            }
        }
        catch (Exception e) {
            throw new UserException("Failed instantiate an User implementation object: " + e.toString());
        }
        return user;
    }
}

