/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.database;

import com.workingdogs.village.DataSetException;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.om.registry.DBRegistry;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.base.BaseMetaInfo;
import org.apache.jetspeed.om.registry.base.BaseSecurity;
import org.apache.jetspeed.om.registry.base.BaseSkinEntry;
import org.apache.jetspeed.om.registry.database.BaseJetspeedSkinParameterPeer;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class BaseJetspeedSkinPeer
extends BasePeer
implements DBRegistry {
    protected static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BaseJetspeedSkinPeer.class.getName());
    public static final String TABLE_NAME = "SKIN";
    public static final String ID = "SKIN.ID";
    public static final String NAME = "SKIN.NAME";
    public static final String HIDDEN = "SKIN.HIDDEN";
    public static final String ROLE = "SKIN.ROLE";
    public static final String TITLE = "SKIN.TITLE";
    public static final String DESCRIPTION = "SKIN.DESCRIPTION";
    public static final String IMAGE = "SKIN.IMAGE";
    public static final int numColumns = 7;
    protected static final String CLASSNAME_DEFAULT = "org.apache.jetspeed.om.registry.base.BaseSkinEntry";
    protected static final Class CLASS_DEFAULT = BaseJetspeedSkinPeer.initClass("org.apache.jetspeed.om.registry.base.BaseSkinEntry");

    private static Class initClass(String className) {
        Class<?> c;
        block2: {
            c = null;
            try {
                c = Class.forName(className);
            }
            catch (Throwable t) {
                logger.error("A FATAL ERROR has occurred which should not have happened under any circumstance.  Please notify the Turbine developers <turbine-dev@jakarta.apache.org> and give as many details as possible (including the error stack trace).", t);
                if (!(t instanceof Error)) break block2;
                throw (Error)t.fillInStackTrace();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List resultSet2Objects(ResultSet results) throws TorqueException {
        try {
            QueryDataSet qds = null;
            List rows = null;
            try {
                qds = new QueryDataSet(results);
                rows = BaseJetspeedSkinPeer.getSelectResults((QueryDataSet)qds);
            }
            finally {
                if (qds != null) {
                    qds.close();
                }
            }
            return BaseJetspeedSkinPeer.populateObjects(rows);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
        catch (DataSetException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public static void addSelectColumns(Criteria criteria) throws TorqueException {
        criteria.addSelectColumn(ID);
        criteria.addSelectColumn(NAME);
        criteria.addSelectColumn(HIDDEN);
        criteria.addSelectColumn(ROLE);
        criteria.addSelectColumn(TITLE);
        criteria.addSelectColumn(DESCRIPTION);
        criteria.addSelectColumn(IMAGE);
    }

    public static BaseSkinEntry row2Object(Record row, int offset, Class cls) throws TorqueException {
        try {
            BaseSkinEntry obj = (BaseSkinEntry)cls.newInstance();
            BaseJetspeedSkinPeer.populateObject(row, offset, obj);
            return obj;
        }
        catch (InstantiationException e) {
            throw new TorqueException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public static void populateObject(Record row, int offset, BaseSkinEntry obj) throws TorqueException {
        try {
            int id = row.getValue(offset + 0).asInt();
            obj.setName(row.getValue(offset + 1).asString());
            obj.setHidden(row.getValue(offset + 2).asBoolean());
            obj.setTitle(row.getValue(offset + 4).asString());
            obj.setDescription(row.getValue(offset + 5).asString());
            BaseSecurity security = new BaseSecurity(row.getValue(offset + 3).asString());
            obj.setSecurity(security);
            obj.setBaseSecurity(security);
            BaseMetaInfo baseMetaInfo = new BaseMetaInfo(row.getValue(offset + 4).asString(), row.getValue(offset + 5).asString(), row.getValue(offset + 6).asString());
            obj.setMetaInfo(baseMetaInfo);
            BaseJetspeedSkinPeer.buildSkinParameters(id, obj);
        }
        catch (DataSetException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public List getXREGDataFromDb() throws TorqueException {
        Criteria criteria = BaseJetspeedSkinPeer.buildCriteria();
        return BaseJetspeedSkinPeer.doSelect(criteria);
    }

    public boolean isModified(String lastUpdateDate) {
        return true;
    }

    public static List doSelect(Criteria criteria) throws TorqueException {
        return BaseJetspeedSkinPeer.populateObjects(BaseJetspeedSkinPeer.doSelectVillageRecords(criteria));
    }

    public static List doSelect(Criteria criteria, Connection con) throws TorqueException {
        return BaseJetspeedSkinPeer.populateObjects(BaseJetspeedSkinPeer.doSelectVillageRecords(criteria, con));
    }

    public static List doSelectVillageRecords(Criteria criteria) throws TorqueException {
        return BaseJetspeedSkinPeer.doSelectVillageRecords(criteria, null);
    }

    public static List doSelectVillageRecords(Criteria criteria, Connection con) throws TorqueException {
        if (criteria.getSelectColumns().size() == 0) {
            BaseJetspeedSkinPeer.addSelectColumns(criteria);
        }
        if (criteria.getDbName() == Torque.getDefaultDB()) {
            criteria.setDbName("default");
        }
        if (con == null) {
            return BasePeer.doSelect((Criteria)criteria);
        }
        return BasePeer.doSelect((Criteria)criteria, (Connection)con);
    }

    public static List populateObjects(List records) throws TorqueException {
        ArrayList<BaseSkinEntry> results = new ArrayList<BaseSkinEntry>(records.size());
        for (int i = 0; i < records.size(); ++i) {
            Record row = (Record)records.get(i);
            results.add(BaseJetspeedSkinPeer.row2Object(row, 1, BaseJetspeedSkinPeer.getOMClass()));
        }
        return results;
    }

    public static Criteria buildCriteria(ObjectKey pk) {
        Criteria criteria = new Criteria();
        criteria.add(ID, (Object)pk);
        return criteria;
    }

    public static Criteria buildCriteria() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public static Class getOMClass() throws TorqueException {
        return CLASS_DEFAULT;
    }

    public static void buildSkinParameters(int id, BaseSkinEntry obj) throws TorqueException {
        try {
            List list = BaseJetspeedSkinParameterPeer.retrieveById((ObjectKey)SimpleKey.keyFor((int)id));
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Parameter p = (Parameter)list.get(i);
                    if (obj.getParameter(p.getName()) != null) continue;
                    obj.addParameter(p);
                }
            }
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }
}

