/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.jetspeed.om.registry.SecurityAccess;
import org.apache.jetspeed.om.registry.SecurityAllow;
import org.apache.jetspeed.om.registry.SecurityEntry;
import org.apache.jetspeed.om.registry.base.BaseRegistryEntry;
import org.apache.jetspeed.om.registry.base.BaseSecurityAccess;
import org.apache.jetspeed.om.registry.base.BaseSecurityAllow;

public class BaseSecurityEntry
extends BaseRegistryEntry
implements SecurityEntry,
Serializable {
    private Vector accesses = new Vector();
    private transient Map accessMap = null;
    public static final String ALL_ACTIONS = "*";
    public static final String ALL_ROLES = "*";
    public static final String ALL_GROUPS = "*";
    public static final String ALL_GROUP_ROLES = "*";
    public static final String ALL_USERS = "*";
    private static final String OWNER_MAP = "owner";
    private static final String ROLE_MAP = "role";
    private static final String GROUP_MAP = "group";
    private static final String GROUP_ROLE_MAP = "grouprole";
    private static final String USER_MAP = "user";
    private static transient Object accessMapSync = new Object();

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        BaseSecurityEntry obj = (BaseSecurityEntry)object;
        Iterator i = this.accesses.iterator();
        Iterator i2 = obj.accesses.iterator();
        while (i.hasNext()) {
            BaseSecurityAccess c1 = (BaseSecurityAccess)i.next();
            BaseSecurityAccess c2 = null;
            if (!i2.hasNext()) {
                return false;
            }
            c2 = (BaseSecurityAccess)i2.next();
            if (c1.equals(c2)) continue;
            return false;
        }
        if (i2.hasNext()) {
            return false;
        }
        return super.equals(object);
    }

    public Vector getAccesses() {
        return this.accesses;
    }

    public void setAccesses(Vector accesses) {
        this.accesses = accesses;
        this.buildAccessMap();
    }

    public boolean allowsRole(String role, String action) {
        Map allowMap = null;
        boolean allow = false;
        if (this.accessMap == null) {
            this.buildAccessMap();
        }
        if (allow = this.isInAllowMap(allowMap = (Map)this.accessMap.get(action), ROLE_MAP, role, "*")) {
            return allow;
        }
        allowMap = (Map)this.accessMap.get("*");
        allow = this.isInAllowMap(allowMap, ROLE_MAP, role, "*");
        return allow;
    }

    public boolean allowsGroup(String group, String action) {
        Map allowMap = null;
        boolean allow = false;
        if (this.accessMap == null) {
            this.buildAccessMap();
        }
        if (allow = this.isInAllowMap(allowMap = (Map)this.accessMap.get(action), GROUP_MAP, group, "*")) {
            return allow;
        }
        allowMap = (Map)this.accessMap.get("*");
        allow = this.isInAllowMap(allowMap, GROUP_MAP, group, "*");
        return allow;
    }

    public boolean allowsGroupRole(String group, String role, String action) {
        Map allowMap = null;
        boolean allow = false;
        if (this.accessMap == null) {
            this.buildAccessMap();
        }
        if (allow = this.isInAllowMap(allowMap = (Map)this.accessMap.get(action), GROUP_ROLE_MAP, group + role, "*")) {
            return allow;
        }
        allowMap = (Map)this.accessMap.get("*");
        allow = this.isInAllowMap(allowMap, GROUP_ROLE_MAP, group + role, "*");
        return allow;
    }

    public boolean allowsUser(String userName, String action) {
        return this.allowsUser(userName, action, null);
    }

    public boolean allowsUser(String userName, String action, String owner) {
        Map allowMap = null;
        boolean allow = false;
        if (this.accessMap == null) {
            this.buildAccessMap();
        }
        if (owner != null && owner.equals(userName)) {
            allowMap = (Map)this.accessMap.get(action);
            allow = this.isInAllowMap(allowMap, OWNER_MAP, null, null);
            if (allow) {
                return allow;
            }
            allowMap = (Map)this.accessMap.get("*");
            allow = this.isInAllowMap(allowMap, OWNER_MAP, null, null);
            if (allow) {
                return allow;
            }
        }
        if (allow = this.isInAllowMap(allowMap = (Map)this.accessMap.get(action), USER_MAP, userName, "*")) {
            return allow;
        }
        allowMap = (Map)this.accessMap.get("*");
        allow = this.isInAllowMap(allowMap, USER_MAP, userName, "*");
        return allow;
    }

    public boolean allowsSpecificRole(String action, String role) {
        SecurityAccess access = this.getAccess(action);
        if (access.getAllAllows() != null) {
            for (SecurityAllow allow : access.getAllows()) {
                if (allow.getRole() == null || !allow.getRole().equals(role)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allowsSpecificGroup(String action, String group) {
        SecurityAccess access = this.getAccess(action);
        if (access.getAllAllows() != null) {
            for (SecurityAllow allow : access.getAllows()) {
                if (allow.getGroup() == null || !allow.getGroup().equals(group)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allowsSpecificGroupRole(String action, String group, String role) {
        SecurityAccess access = this.getAccess(action);
        if (access.getAllAllows() != null) {
            for (SecurityAllow allow : access.getAllows()) {
                if (allow.getGroup() == null || !allow.getGroup().equals(group) || allow.getRole() == null || !allow.getRole().equals(role)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allowsSpecificUser(String action, String user) {
        BaseSecurityAccess access = (BaseSecurityAccess)this.getAccess(action);
        if (access.getAllAllows() != null) {
            for (BaseSecurityAllow allow : access.getAllows()) {
                if (allow.getUser() == null || !allow.getUser().equals(user)) continue;
                return true;
            }
        }
        return false;
    }

    public SecurityAccess getAccess(String action) {
        for (BaseSecurityAccess access : this.getAccesses()) {
            if (!access.getAction().equals(action)) continue;
            return access;
        }
        return null;
    }

    public boolean grantRoleAccess(String action, String role) {
        if (!this.allowsSpecificRole(action, role)) {
            SecurityAccess access = this.getAccess(action);
            Vector<BaseSecurityAllow> allows = access.getAllows();
            if (allows == null) {
                allows = new Vector<BaseSecurityAllow>();
            }
            BaseSecurityAllow allow = new BaseSecurityAllow();
            allow.setRole(role);
            allows.add(allow);
            this.buildAccessMap();
            return true;
        }
        return false;
    }

    public boolean grantGroupAccess(String action, String group) {
        if (!this.allowsSpecificGroup(action, this.role)) {
            SecurityAccess access = this.getAccess(action);
            Vector<BaseSecurityAllow> allows = access.getAllows();
            if (allows == null) {
                allows = new Vector<BaseSecurityAllow>();
            }
            BaseSecurityAllow allow = new BaseSecurityAllow();
            allow.setGroup(group);
            allows.add(allow);
            this.buildAccessMap();
            return true;
        }
        return false;
    }

    public boolean grantGroupRoleAccess(String action, String group, String role) {
        if (!this.allowsSpecificGroupRole(action, group, role)) {
            SecurityAccess access = this.getAccess(action);
            Vector<BaseSecurityAllow> allows = access.getAllows();
            if (allows == null) {
                allows = new Vector<BaseSecurityAllow>();
            }
            BaseSecurityAllow allow = new BaseSecurityAllow();
            allow.setGroup(group);
            allow.setRole(role);
            allows.add(allow);
            this.buildAccessMap();
            return true;
        }
        return false;
    }

    public boolean grantUserAccess(String action, String user) {
        if (!this.allowsSpecificUser(action, user)) {
            SecurityAccess access = this.getAccess(action);
            Vector<BaseSecurityAllow> allows = access.getAllows();
            if (allows == null) {
                allows = new Vector<BaseSecurityAllow>();
            }
            BaseSecurityAllow allow = new BaseSecurityAllow();
            allow.setUser(user);
            allows.add(allow);
            this.buildAccessMap();
            return true;
        }
        return false;
    }

    public boolean revokeRoleAccess(String action, String role) {
        if (this.allowsSpecificRole(action, role)) {
            SecurityAccess access = this.getAccess(action);
            Vector allows = access.getAllows();
            if (allows == null || allows.isEmpty()) {
                this.revokeAccess(action);
                return false;
            }
            for (int i = 0; i < allows.size(); ++i) {
                BaseSecurityAllow allow = (BaseSecurityAllow)allows.get(i);
                if (allow.getRole() == null || !allow.getRole().equals(role)) continue;
                allows.remove(i);
                if (allows.isEmpty() && access.getOwnerAllows().isEmpty()) {
                    this.revokeAccess(action);
                }
                return true;
            }
        }
        return false;
    }

    public boolean revokeGroupAccess(String action, String group) {
        if (this.allowsSpecificGroup(action, group)) {
            SecurityAccess access = this.getAccess(action);
            Vector allows = access.getAllows();
            if (allows == null || allows.isEmpty()) {
                this.revokeAccess(action);
                return false;
            }
            for (int i = 0; i < allows.size(); ++i) {
                BaseSecurityAllow allow = (BaseSecurityAllow)allows.get(i);
                if (allow.getGroup() == null || !allow.getGroup().equals(group)) continue;
                allows.remove(i);
                if (allows.isEmpty() && access.getOwnerAllows().isEmpty()) {
                    this.revokeAccess(action);
                }
                return true;
            }
        }
        return false;
    }

    public boolean revokeGroupRoleAccess(String action, String group, String role) {
        if (this.allowsSpecificGroupRole(action, group, role)) {
            SecurityAccess access = this.getAccess(action);
            Vector allows = access.getAllows();
            if (allows == null || allows.isEmpty()) {
                this.revokeAccess(action);
                return false;
            }
            for (int i = 0; i < allows.size(); ++i) {
                BaseSecurityAllow allow = (BaseSecurityAllow)allows.get(i);
                if (allow.getGroup() == null || !allow.getGroup().equals(group) || allow.getRole() == null || !allow.getRole().equals(role)) continue;
                allows.remove(i);
                if (allows.isEmpty() && access.getOwnerAllows().isEmpty()) {
                    this.revokeAccess(action);
                }
                return true;
            }
        }
        return false;
    }

    public boolean revokeUserAccess(String action, String user) {
        if (this.allowsSpecificUser(action, user)) {
            SecurityAccess access = this.getAccess(action);
            Vector allows = access.getAllows();
            if (allows == null || allows.isEmpty()) {
                this.revokeAccess(action);
                return false;
            }
            for (int i = 0; i < allows.size(); ++i) {
                BaseSecurityAllow allow = (BaseSecurityAllow)allows.get(i);
                if (allow.getUser() == null || !allow.getUser().equals(user)) continue;
                allows.remove(i);
                if (allows.isEmpty() && access.getOwnerAllows().isEmpty()) {
                    this.revokeAccess(action);
                }
                return true;
            }
        }
        return false;
    }

    public void revokeAccess(String action) {
        Vector list = this.getAccesses();
        for (int i = 0; i < list.size(); ++i) {
            BaseSecurityAccess access = (BaseSecurityAccess)list.get(i);
            if (!access.getAction().equals(action)) continue;
            list.remove(i);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildAccessMap() {
        HashMap actionMap = null;
        SecurityAccess accessElement2 = null;
        Object object = accessMapSync;
        synchronized (object) {
            if (this.accessMap == null) {
                this.accessMap = new HashMap();
            }
            this.accessMap.clear();
        }
        for (SecurityAccess accessElement2 : this.getAccesses()) {
            String action = accessElement2.getAction();
            if (action == null) {
                action = "*";
            }
            if ((actionMap = (HashMap)this.accessMap.get(action)) == null) {
                actionMap = new HashMap();
                this.accessMap.put(action, actionMap);
            }
            this.addAllows(actionMap, accessElement2);
        }
    }

    private void addAllows(Map accessMap, SecurityAccess accessElement) {
        SecurityAllow allowElement2 = null;
        String role = null;
        String group = null;
        HashMap<Object, Object> ownerMap = null;
        HashMap<String, Object> roleMap = null;
        HashMap<String, Object> groupMap = null;
        HashMap<String, Object> groupRoleMap = null;
        HashMap<String, Object> userMap = null;
        String userName = null;
        if (accessElement.getAllAllows() == null) {
            return;
        }
        for (SecurityAllow allowElement2 : accessElement.getAllAllows()) {
            role = null;
            userName = null;
            group = null;
            if (allowElement2.isOwner()) {
                ownerMap = (HashMap<Object, Object>)accessMap.get(OWNER_MAP);
                if (ownerMap == null) {
                    ownerMap = new HashMap<Object, Object>();
                    accessMap.put(OWNER_MAP, ownerMap);
                }
                ownerMap.put(null, null);
            }
            if ((role = allowElement2.getRole()) != null) {
                roleMap = (HashMap<String, Object>)accessMap.get(ROLE_MAP);
                if (roleMap == null) {
                    roleMap = new HashMap<String, Object>();
                    accessMap.put(ROLE_MAP, roleMap);
                }
                roleMap.put(role, null);
                groupRoleMap = (HashMap<String, Object>)accessMap.get(GROUP_ROLE_MAP);
                if (groupRoleMap == null) {
                    groupRoleMap = new HashMap<String, Object>();
                    accessMap.put(GROUP_ROLE_MAP, groupRoleMap);
                }
                if (group == null) {
                    group = "Jetspeed";
                }
                groupRoleMap.put(group + role, null);
            }
            if ((group = allowElement2.getGroup()) != null) {
                groupMap = (HashMap<String, Object>)accessMap.get(GROUP_MAP);
                if (groupMap == null) {
                    groupMap = new HashMap<String, Object>();
                    accessMap.put(GROUP_MAP, groupMap);
                }
                groupMap.put(group, null);
                groupRoleMap = (Map)accessMap.get(GROUP_ROLE_MAP);
                if (groupRoleMap == null) {
                    groupRoleMap = new HashMap();
                    accessMap.put(GROUP_ROLE_MAP, groupRoleMap);
                }
                if (role == null) {
                    role = USER_MAP;
                }
                groupRoleMap.put(group + role, null);
            }
            if ((userName = allowElement2.getUser()) == null) continue;
            userMap = (HashMap<String, Object>)accessMap.get(USER_MAP);
            if (userMap == null) {
                userMap = new HashMap<String, Object>();
                accessMap.put(USER_MAP, userMap);
            }
            userMap.put(userName, null);
        }
    }

    private boolean isInAllowMap(Map allowMap, String mapType, String mapKey, String allKey) {
        boolean allow = false;
        if (allowMap != null) {
            Map allowTypeMap = (Map)allowMap.get(mapType);
            if (allowTypeMap == null) {
                return allowMap.isEmpty();
            }
            allow = allowTypeMap.containsKey(mapKey);
            if (!allow) {
                allow = allowTypeMap.containsKey(allKey);
            }
            return allow;
        }
        return allow;
    }
}

