/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.om.registry.InvalidEntryException;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.om.registry.MediaTypeRegistry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.RegistryException;
import org.apache.jetspeed.om.registry.base.BaseMediaTypeEntry;
import org.apache.jetspeed.om.registry.base.BaseOrderedRegistry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class BaseMediaTypeRegistry
extends BaseOrderedRegistry
implements MediaTypeRegistry {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BaseMediaTypeRegistry.class.getName());

    public Iterator findForCapability(CapabilityMap cm) {
        if (cm == null) {
            return null;
        }
        String type = cm.getPreferredType().getContentType();
        ArrayList<MediaTypeEntry> result = new ArrayList<MediaTypeEntry>();
        if (logger.isDebugEnabled()) {
            logger.debug("MediaTypeRegistry: looking for type " + type);
        }
        if (type == null) {
            return result.iterator();
        }
        try {
            Enumeration en = this.getEntries();
            while (en.hasMoreElements()) {
                MediaTypeEntry mte = (MediaTypeEntry)en.nextElement();
                if (logger.isDebugEnabled()) {
                    logger.debug("MediaTypeRegistry: found MediaTypeEntry for type " + mte.getMimeType());
                }
                if (!type.equals(mte.getMimeType())) continue;
                result.add(mte);
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("MediaTypeRegistry: found " + result.size() + " entries.");
        }
        return result.iterator();
    }

    public void setEntry(RegistryEntry entry) throws InvalidEntryException {
        try {
            Registry.addEntry(Registry.MEDIA_TYPE, entry);
        }
        catch (RegistryException e) {
            logger.error("Exception", e);
        }
    }

    public void addEntry(RegistryEntry entry) throws InvalidEntryException {
        try {
            Registry.addEntry(Registry.MEDIA_TYPE, entry);
        }
        catch (RegistryException e) {
            logger.error("Exception", e);
        }
    }

    public void removeEntry(String name) {
        Registry.removeEntry(Registry.MEDIA_TYPE, name);
    }

    public void removeEntry(RegistryEntry entry) {
        if (entry != null) {
            Registry.removeEntry(Registry.MEDIA_TYPE, entry.getName());
        }
    }

    public RegistryEntry createEntry() {
        return new BaseMediaTypeEntry();
    }
}

