/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import java.util.Enumeration;
import org.apache.jetspeed.om.registry.ClientEntry;
import org.apache.jetspeed.om.registry.ClientRegistry;
import org.apache.jetspeed.om.registry.InvalidEntryException;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.RegistryException;
import org.apache.jetspeed.om.registry.base.BaseClientEntry;
import org.apache.jetspeed.om.registry.base.BaseOrderedRegistry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class BaseClientRegistry
extends BaseOrderedRegistry
implements ClientRegistry {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BaseClientRegistry.class.getName());

    public void setEntry(RegistryEntry entry) throws InvalidEntryException {
        try {
            Registry.addEntry(Registry.CLIENT, entry);
        }
        catch (RegistryException e) {
            logger.error("Exception", e);
        }
    }

    public void addEntry(RegistryEntry entry) throws InvalidEntryException {
        try {
            Registry.addEntry(Registry.CLIENT, entry);
        }
        catch (RegistryException e) {
            logger.error("Exception", e);
        }
    }

    public void removeEntry(String name) {
        Registry.removeEntry(Registry.CLIENT, name);
    }

    public void removeEntry(RegistryEntry entry) {
        if (entry != null) {
            Registry.removeEntry(Registry.CLIENT, entry.getName());
        }
    }

    public ClientEntry findEntry(String useragent) {
        ClientEntry clientEntry = null;
        Enumeration clients = this.getEntries();
        if (logger.isDebugEnabled()) {
            logger.debug("ClientRegistry: Looking for client with useragent :" + useragent);
        }
        if (clients != null) {
            while (clients.hasMoreElements()) {
                ClientEntry client = (ClientEntry)clients.nextElement();
                if (client.getUseragentpattern() == null) continue;
                try {
                    RE r = new RE(client.getUseragentpattern());
                    r.setMatchFlags(1);
                    if (r.match(useragent)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ClientRegistry: " + useragent + " matches " + client.getUseragentpattern());
                        }
                        return client;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("ClientRegistry: " + useragent + " does not match " + client.getUseragentpattern());
                }
                catch (RESyntaxException e) {
                    String message = "ClientRegistryService: UserAgentPattern not valid : " + client.getUseragentpattern() + " : " + e.getMessage();
                    logger.error(message, e);
                }
            }
        }
        return clientEntry;
    }

    public RegistryEntry createEntry() {
        return new BaseClientEntry();
    }
}

