/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.profile;

import java.util.StringTokenizer;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.JetspeedUserFactory;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class BaseProfileLocator
implements ProfileLocator {
    private String name = null;
    private String mediaType = null;
    private String language = null;
    private String country = null;
    private JetspeedUser user = null;
    private Role role = null;
    private Group group = null;
    private boolean anonymous = false;
    private String roleName = null;
    private String userName = null;
    private String groupName = null;
    private String orgName = null;
    private static final String DELIM = "/";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BaseProfileLocator.class.getName());

    public String getId() {
        StringBuffer id = new StringBuffer(128);
        if (!this.anonymous && this.user != null) {
            id.append("user").append(DELIM);
            id.append(this.user.getUserName());
        } else if (this.group != null) {
            id.append("group").append(DELIM);
            id.append(this.group.getName());
        } else if (this.role != null) {
            id.append("role").append(DELIM);
            id.append(this.role.getName());
        } else {
            id.append("anon");
        }
        if (this.language != null) {
            id.append(DELIM);
            id.append(this.language);
        }
        if (this.country != null) {
            id.append(DELIM);
            id.append(this.country);
        }
        if (this.mediaType != null) {
            id.append(DELIM);
            id.append(this.mediaType);
        }
        if (this.name != null) {
            id.append(DELIM);
            id.append(this.name);
        }
        return id.toString();
    }

    public String getPath() {
        StringBuffer id = new StringBuffer(128);
        if (!this.anonymous && this.user != null) {
            id.append("user").append(DELIM);
            id.append(this.user.getUserName()).append(DELIM);
        } else if (this.group != null) {
            id.append("group").append(DELIM);
            id.append(this.group.getName()).append(DELIM);
        } else if (this.role != null) {
            id.append("role").append(DELIM);
            id.append(this.role.getName()).append(DELIM);
        } else {
            id.append("user").append(DELIM);
            id.append("anon").append(DELIM);
        }
        if (this.language != null) {
            id.append("language").append(DELIM);
            id.append(this.language).append(DELIM);
        }
        if (this.country != null) {
            id.append("country").append(DELIM);
            id.append(this.country).append(DELIM);
        }
        if (this.mediaType != null) {
            id.append("media-type").append(DELIM);
            id.append(this.mediaType).append(DELIM);
        }
        if (this.name != null) {
            id.append("page").append(DELIM);
            id.append(this.name).append(DELIM);
        }
        id.deleteCharAt(id.length() - 1);
        return id.toString();
    }

    public void createFromPath(String path) {
        StringTokenizer tok = new StringTokenizer(path, DELIM);
        while (tok.hasMoreTokens()) {
            String name = tok.nextToken();
            if (name.equals("user") && tok.hasMoreTokens()) {
                try {
                    this.userName = tok.nextToken();
                    this.setUser(JetspeedSecurity.getUser(this.userName));
                }
                catch (Exception e) {
                    logger.error("ProfileLocator: Failed to set User: ", e);
                }
                continue;
            }
            if (name.equals("group") && tok.hasMoreTokens()) {
                try {
                    this.groupName = tok.nextToken();
                    this.setGroup(JetspeedSecurity.getGroup(this.groupName));
                }
                catch (Exception e) {
                    logger.error("ProfileLocator: Failed to set Group: ", e);
                }
                continue;
            }
            if (name.equals("role") && tok.hasMoreTokens()) {
                try {
                    this.roleName = tok.nextToken();
                    this.setRole(JetspeedSecurity.getRole(this.roleName));
                }
                catch (Exception e) {
                    logger.error("ProfileLocator: Failed to set Role: ", e);
                }
                continue;
            }
            if (name.equals("page") && tok.hasMoreTokens()) {
                this.setName(tok.nextToken());
                continue;
            }
            if (name.equals("media-type") && tok.hasMoreTokens()) {
                this.setMediaType(tok.nextToken());
                continue;
            }
            if (name.equals("language") && tok.hasMoreTokens()) {
                this.setLanguage(tok.nextToken());
                continue;
            }
            if (!name.equals("country") || !tok.hasMoreTokens()) continue;
            this.setCountry(tok.nextToken());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getAnonymous() {
        return this.anonymous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnonymous(boolean anonymous) {
        try {
            JetspeedUser user = JetspeedUserFactory.getInstance();
            user.setUserName(JetspeedSecurity.getAnonymousUserName());
            this.setUser(user);
        }
        catch (Exception e) {
            logger.error("Could not get Anonymous user", e);
        }
        finally {
            this.anonymous = anonymous;
        }
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public JetspeedUser getUser() {
        return this.user;
    }

    public String getUserName() {
        if (null == this.user) {
            return this.userName;
        }
        return this.user.getUserName();
    }

    public void setUser(JetspeedUser user) {
        this.user = user;
    }

    public Role getRole() {
        return this.role;
    }

    public String getRoleName() {
        if (null == this.role) {
            return this.roleName;
        }
        return this.role.getName();
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public void setRoleByName(String roleName) {
        try {
            Role temp = JetspeedSecurity.getRole(roleName);
            if (null != temp) {
                this.role = temp;
            }
        }
        catch (Exception e) {
            logger.error("ProfileLocator: Failed to set Role " + roleName, e);
        }
    }

    public Group getGroup() {
        return this.group;
    }

    public String getGroupName() {
        if (null == this.group) {
            return this.groupName;
        }
        return this.group.getName();
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public void setGroupByName(String groupName) {
        try {
            Group temp = JetspeedSecurity.getGroup(groupName);
            if (null != temp) {
                this.group = temp;
            }
        }
        catch (Exception e) {
            logger.error("ProfileLocator: Failed to set Group: " + e);
        }
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Object object = obj;
        synchronized (object) {
            if (!(obj instanceof ProfileLocator)) {
                return false;
            }
            ProfileLocator locator = (ProfileLocator)obj;
            String name = locator.getName();
            String mediaType = locator.getMediaType();
            String language = locator.getLanguage();
            String country = locator.getCountry();
            Group group = locator.getGroup();
            Role role = locator.getRole();
            return this.nameEquals(name) && this.mediaTypeEquals(mediaType) && this.languageEquals(language) && this.countryEquals(country) && this.userEquals(locator) && this.groupEquals(group) && this.roleEquals(role);
        }
    }

    private boolean userEquals(ProfileLocator locator) {
        JetspeedUser user = locator.getUser();
        if (this.exclusiveOr(this.user, user)) {
            return false;
        }
        if (this.assertNotNull(this.user) && this.assertNotNull(user)) {
            return this.stringEquals(this.user.getUserName(), user.getUserName());
        }
        return this.anonymous == locator.getAnonymous();
    }

    private boolean groupEquals(Group group) {
        if (this.exclusiveOr(this.group, group)) {
            return false;
        }
        if (this.assertNotNull(this.group) && this.assertNotNull(group)) {
            return this.stringEquals(this.group.getName(), group.getName());
        }
        return true;
    }

    private boolean roleEquals(Role role) {
        if (this.exclusiveOr(this.role, role)) {
            return false;
        }
        if (this.assertNotNull(this.role) && this.assertNotNull(role)) {
            return this.stringEquals(this.role.getName(), role.getName());
        }
        return true;
    }

    private boolean languageEquals(String language) {
        return this.stringEquals(this.language, language);
    }

    private boolean countryEquals(String country) {
        return this.stringEquals(this.country, country);
    }

    private boolean nameEquals(String name) {
        return this.stringEquals(this.name, name);
    }

    private boolean orgNameEquals(String orgName) {
        return this.stringEquals(this.orgName, orgName);
    }

    private boolean mediaTypeEquals(String mediaType) {
        return this.stringEquals(this.mediaType, mediaType);
    }

    private boolean stringEquals(String str1, String str2) {
        if (this.exclusiveOr(str1, str2)) {
            return false;
        }
        if (this.assertNotNull(str1) && this.assertNotNull(str2)) {
            return str1.equals(str2);
        }
        return true;
    }

    private boolean assertNotNull(Object object) {
        return object != null;
    }

    private boolean exclusiveOr(Object obj1, Object obj2) {
        return this.assertNotNull(obj1) && !this.assertNotNull(obj2) || !this.assertNotNull(obj1) && this.assertNotNull(obj2);
    }
}

