/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.profile;

import org.apache.jetspeed.om.profile.BaseProfileLocator;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.PsmlManager;

public class BaseProfile
extends BaseProfileLocator
implements Profile {
    protected PSMLDocument document = null;

    public BaseProfile() {
    }

    public BaseProfile(ProfileLocator locator) {
        this.init(locator);
    }

    public void init(ProfileLocator locator) {
        this.setAnonymous(locator.getAnonymous());
        this.setCountry(locator.getCountry());
        this.setGroup(locator.getGroup());
        this.setLanguage(locator.getLanguage());
        this.setMediaType(locator.getMediaType());
        this.setName(locator.getName());
        this.setRole(locator.getRole());
        this.setUser(locator.getUser());
        this.setOrgName(locator.getOrgName());
    }

    public Object clone() throws CloneNotSupportedException {
        Object cloned = super.clone();
        ((BaseProfile)cloned).document = this.document == null ? null : (PSMLDocument)this.document.clone();
        return cloned;
    }

    public PortletSet getRootSet() {
        return PortalToolkit.getSet(this.getDocument().getPortlets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PSMLDocument getDocument() {
        BaseProfile baseProfile = this;
        synchronized (baseProfile) {
            if (this.document == null || this.document.getPortlets() == null) {
                this.document = PsmlManager.getDocument(this);
            }
        }
        return this.document;
    }

    public void setDocument(PSMLDocument document) {
        this.document = document;
    }

    public void store() throws ProfileException {
        if (this.document != null) {
            PsmlManager.store(this);
        }
    }

    public String toString() {
        return "BaseProfile[" + this.getId() + "]";
    }
}

