/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.pages;

import com.aimluck.eip.common.ALEipConstants;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.MimeType;
import org.apache.turbine.modules.pages.DefaultPage;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;

public class JetspeedTemplatePage
extends DefaultPage {
    private static int httpLifetime = JetspeedResources.getInt("http.lifetime", -1);
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedTemplatePage.class.getName());

    protected void doBuildBeforeAction(RunData data) throws Exception {
        switch (httpLifetime) {
            case -1: {
                break;
            }
            case 0: {
                data.getResponse().setHeader("Cache-Control", "no-cache");
                data.getResponse().setHeader("Pragma", "no-cache");
                data.getResponse().setDateHeader("Expires", 0L);
                data.getResponse().setDateHeader("Last-Modified", System.currentTimeMillis());
                break;
            }
            default: {
                data.getResponse().setHeader("Cache-Control", "max-age=" + httpLifetime);
                data.getResponse().setDateHeader("Expires", System.currentTimeMillis() + (long)(httpLifetime * 1000));
                data.getResponse().setDateHeader("Last-Modified", System.currentTimeMillis());
            }
        }
        CapabilityMap cm = ((JetspeedRunData)data).getCapability();
        MimeType mime = cm.getPreferredType();
        String characterSet = ALEipConstants.DEF_CONTENT_ENCODING;
        if (mime != null) {
            data.setContentType(mime.getContentType());
            MediaTypeEntry media = (MediaTypeEntry)Registry.getEntry(Registry.MEDIA_TYPE, cm.getPreferredMediaType());
            if (media != null && media.getCharacterSet() != null) {
                characterSet = media.getCharacterSet();
            }
        }
        data.setCharSet(characterSet);
        if (logger.isDebugEnabled()) {
            logger.debug("JetspeedTemplatePage: Setting type to: " + cm.getPreferredType().getContentType() + "; charset=" + ALEipConstants.DEF_CONTENT_ENCODING);
        }
    }

    protected void doBuildAfterAction(RunData data) throws Exception {
        if (!data.hasScreen()) {
            String screen;
            String layout_template;
            if (data.getTemplateInfo().getScreenTemplate() == null) {
                String screen2 = TurbineTemplate.getDefaultScreen();
                data.setScreenTemplate(screen2);
            }
            String ext = TurbineTemplate.getDefaultExtension();
            String template = data.getTemplateInfo().getScreenTemplate();
            ((JetspeedRunData)data).setRequestedTemplate(template);
            if (template.lastIndexOf(46) < 0) {
                template = template + "." + ext;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("JetspeedTemplatePage: requested template = " + template);
            }
            String locatedScreen = TemplateLocator.locateScreenTemplate(data, template);
            data.setScreenTemplate(locatedScreen);
            if (logger.isDebugEnabled()) {
                logger.debug("JetspeedTemplatePage: calculated template = " + locatedScreen);
            }
            layout_template = (layout_template = data.getParameters().getString("layout_template")) != null && !layout_template.equals("") ? "/" + layout_template + ".vm" : template;
            String layout = TemplateLocator.locateLayoutTemplate(data, layout_template);
            data.setLayoutTemplate(layout);
            if (logger.isDebugEnabled()) {
                logger.debug("JetspeedTemplatePage: layoutTemplate is finally " + layout);
            }
            if ((screen = TurbineTemplate.getScreenName((String)template)) == null) {
                throw new Exception("Screen could not be determined. \nNo matches were found by TemplateService and the \nservices.TurbineTemplateService.default.screen \nproperty was not set.");
            }
            data.setScreen(screen);
        }
    }
}

