/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets.security;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.modules.actions.portlets.SecureVelocityPortletAction;
import org.apache.jetspeed.modules.actions.portlets.security.SecurityConstants;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class UserGroupUpdateAction
extends SecureVelocityPortletAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(UserGroupUpdateAction.class.getName());

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            int id;
            Object group = null;
            String mode = rundata.getParameters().getString("mode");
            String entityid = rundata.getParameters().getString("entityid");
            if (entityid == null || entityid.trim().length() == 0) {
                return;
            }
            this.buildUserGroupsContext(portlet, context, rundata, entityid);
            String msgid = rundata.getParameters().getString("msgid");
            if (msgid != null && (id = Integer.parseInt(msgid)) < SecurityConstants.MESSAGES.length) {
                context.put("msg", (Object)SecurityConstants.MESSAGES[id]);
            }
        }
        catch (Exception e) {
            logger.error("Error in Jetspeed User Group Security", e);
            rundata.setMessage("Error in Jetspeed User Group Security: " + e.toString());
            rundata.setStackTrace(StringUtils.stackTrace((Throwable)e), (Throwable)e);
            rundata.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }

    public void doUpdate(RunData rundata, Context context) throws Exception {
        String entityid = rundata.getParameters().getString("entityid");
        if (entityid == null || entityid.trim().length() == 0) {
            logger.error("UserGroupBrowser: Failed to get entity: " + entityid);
            DynamicURI duri = new DynamicURI(rundata);
            duri.addPathInfo("js_panename", "UserGroupForm");
            duri.addPathInfo("msgid", 5);
            rundata.setRedirectURI(duri.toString());
            return;
        }
        JetspeedUser user = JetspeedSecurity.getUser(entityid);
        if (null == user) {
            logger.error("UserGroupBrowser: Failed to get user: " + entityid);
            DynamicURI duri = new DynamicURI(rundata);
            duri.addPathInfo("js_panename", "UserGroupForm");
            duri.addPathInfo("msgid", 5);
            rundata.setRedirectURI(duri.toString());
            return;
        }
        try {
            List groups = (List)rundata.getUser().getTemp("groups");
            List selected = (List)rundata.getUser().getTemp("selected");
            if (groups == null || selected == null) {
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "UserGroupForm");
                duri.addPathInfo("msgid", 5);
                rundata.setRedirectURI(duri.toString());
                return;
            }
            for (int ix = 0; ix < groups.size(); ++ix) {
                boolean oldValue;
                boolean newValue = rundata.getParameters().getBoolean("box_" + ((Group)groups.get(ix)).getName(), false);
                if (newValue == (oldValue = ((Boolean)selected.get(ix + 1)).booleanValue())) continue;
                if (newValue) {
                    JetspeedSecurity.joinGroup(user.getUserName(), ((Group)groups.get(ix)).getName());
                    continue;
                }
                JetspeedSecurity.unjoinGroup(user.getUserName(), ((Group)groups.get(ix)).getName());
            }
            rundata.getUser().setTemp("groups", null);
            rundata.getUser().setTemp("selected", null);
        }
        catch (Exception e) {
            logger.error("Failed update role+permission: ", e);
            DynamicURI duri = new DynamicURI(rundata);
            duri.addPathInfo("js_panename", "UserGroupForm");
            duri.addPathInfo("msgid", 0);
            if (user != null) {
                duri.addPathInfo("entityid", user.getUserName());
            }
            rundata.setRedirectURI(duri.toString());
        }
    }

    private void buildUserGroupsContext(VelocityPortlet portlet, Context context, RunData rundata, String userid) throws Exception {
        JetspeedUser user = JetspeedSecurity.getUser(userid);
        if (null == user) {
            logger.error("UserGroupBrowser: Failed to get user: " + userid);
            return;
        }
        Iterator groups = JetspeedSecurity.getGroups();
        ArrayList<Group> masterGroups = new ArrayList<Group>();
        ArrayList<Boolean> selected = new ArrayList<Boolean>();
        int ix = 0;
        boolean sel = false;
        selected.add(ix, new Boolean(sel));
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            masterGroups.add(group);
            sel = JetspeedSecurity.inGroup(user.getUserName(), group.getName());
            selected.add(++ix, new Boolean(sel));
        }
        masterGroups.trimToSize();
        selected.trimToSize();
        rundata.getUser().setTemp("groups", masterGroups);
        rundata.getUser().setTemp("selected", selected);
        context.put("user", (Object)user);
        context.put("groups", masterGroups);
        context.put("selected", selected);
    }
}

