/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets.security;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.RESyntaxException;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.app.FieldMethodizer;
import org.apache.velocity.context.Context;

public class UserBrowserAction
extends VelocityPortletAction {
    public static final String NUMBER_PER_PAGE = "number-per-page";
    public static final String DISPLAY_PAGE = "ubpage";
    public static final String FILTER_VALUE = "filter_value";
    public static final String FILTER_REGEXP = "filter_regexp";
    public static final String FILTER_TYPE = "filter_type";
    public static final String FILTER_TYPE_USERNAME = "filter_type_username";
    public static final String FILTER_TYPE_LASTNAME = "filter_type_lastname";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(UserBrowserAction.class.getName());

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            int numberPerPage;
            context.put("s_config", (Object)new FieldMethodizer(context.get("config")));
            Iterator users = JetspeedSecurity.getUsers();
            ArrayList<JetspeedUser> userList = new ArrayList<JetspeedUser>();
            String filterValue = rundata.getParameters().getString(FILTER_VALUE);
            if (filterValue != null) {
                String filterType = rundata.getParameters().getString(FILTER_TYPE, FILTER_TYPE_USERNAME);
                boolean useRE = rundata.getParameters().getBoolean(FILTER_REGEXP);
                RE r = null;
                RECompiler rc = null;
                if (useRE) {
                    try {
                        rc = new RECompiler();
                        r = new RE();
                        r.setProgram(rc.compile(filterValue));
                    }
                    catch (RESyntaxException rex) {
                        logger.warn("UserBrowserAction: error processing regular expression [" + filterValue + "]: " + rex.toString());
                    }
                }
                while (users.hasNext()) {
                    JetspeedUser user = (JetspeedUser)users.next();
                    String compareValue = null;
                    if (filterType.equals(FILTER_TYPE_USERNAME)) {
                        compareValue = user.getUserName();
                    } else if (filterType.equals(FILTER_TYPE_LASTNAME)) {
                        compareValue = user.getLastName();
                    }
                    if (compareValue == null) continue;
                    if (useRE && r.match(compareValue)) {
                        userList.add(user);
                        continue;
                    }
                    if (!compareValue.startsWith(filterValue)) continue;
                    userList.add(user);
                }
            } else {
                while (users.hasNext()) {
                    userList.add((JetspeedUser)users.next());
                }
            }
            int currentPage = rundata.getParameters().getInt(DISPLAY_PAGE, 1);
            try {
                numberPerPage = Integer.parseInt(portlet.getPortletConfig().getInitParameter(NUMBER_PER_PAGE, "50"));
            }
            catch (NumberFormatException e) {
                numberPerPage = 50;
            }
            if (userList.size() > numberPerPage) {
                int numberOfPages = (userList.size() - 1 + numberPerPage) / numberPerPage;
                int from = (currentPage - 1) * numberPerPage;
                int to = Math.min(currentPage * numberPerPage, userList.size());
                context.put("users", userList.subList(from, to));
                StringBuffer pageLinks = new StringBuffer("page: ");
                for (int i = 1; i <= numberOfPages; ++i) {
                    if (i == currentPage) {
                        pageLinks.append("( " + i + " ) &nbsp;");
                        continue;
                    }
                    Object jslink = context.get("jslink");
                    if (jslink instanceof JetspeedLink) {
                        pageLinks.append("[ <a href=\"" + ((JetspeedLink)jslink).getPaneByName("UserBrowser").addQueryData(DISPLAY_PAGE, (Object)new Integer(i)).toString() + "\">" + i + "</a> ] &nbsp;");
                        continue;
                    }
                    pageLinks.append("[ <a href=\"./portal/ubpage/" + i + "\">" + i + "</a> ] &nbsp;");
                }
                context.put("pagelinks", (Object)pageLinks);
            } else {
                context.put("users", userList);
            }
            context.put(DISPLAY_PAGE, (Object)Integer.toString(currentPage));
        }
        catch (JetspeedSecurityException e) {
            logger.error("Exception", (Throwable)((Object)e));
            rundata.setMessage("Error in Jetspeed User Security: " + e.toString());
            rundata.setStackTrace(StringUtils.stackTrace((Throwable)((Object)e)), (Throwable)((Object)e));
            rundata.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }
}

