/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets.security;

import org.apache.jetspeed.modules.actions.portlets.SecureVelocityPortletAction;
import org.apache.jetspeed.modules.actions.portlets.security.SecurityConstants;
import org.apache.jetspeed.om.security.JetspeedRoleFactory;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.RoleException;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class RoleUpdateAction
extends SecureVelocityPortletAction {
    private static final String TEMP_ROLE = "tempRole";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(RoleUpdateAction.class.getName());

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            String msgid;
            Role role = null;
            String mode = rundata.getParameters().getString("mode");
            if (mode != null && (mode.equals("update") || mode.equals("delete"))) {
                String rolename = rundata.getParameters().getString("entityid");
                role = JetspeedSecurity.getRole(rolename);
                context.put("role", (Object)role);
            }
            if ((msgid = rundata.getParameters().getString("msgid")) != null) {
                Role tempRole;
                int id = Integer.parseInt(msgid);
                if (id < SecurityConstants.MESSAGES.length) {
                    context.put("msg", (Object)SecurityConstants.MESSAGES[id]);
                }
                if ((tempRole = (Role)rundata.getUser().getTemp(TEMP_ROLE)) != null) {
                    context.put("role", (Object)tempRole);
                }
            }
            context.put("mode", (Object)mode);
        }
        catch (Exception e) {
            logger.error("Error in Jetspeed User Security", e);
            rundata.setMessage("Error in Jetspeed User Security: " + e.toString());
            rundata.setStackTrace(StringUtils.stackTrace((Throwable)e), (Throwable)e);
            rundata.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }

    public void doInsert(RunData rundata, Context context) throws Exception {
        block3: {
            Role role = null;
            try {
                String name = rundata.getParameters().getString("name");
                if (name == null || name.trim().length() == 0) {
                    DynamicURI duri = new DynamicURI(rundata);
                    duri.addPathInfo("js_panename", "RoleForm");
                    duri.addPathInfo("msgid", 2);
                    rundata.setRedirectURI(duri.toString());
                    rundata.getUser().setTemp(TEMP_ROLE, null);
                    return;
                }
                role = JetspeedRoleFactory.getInstance();
                role.setName(name);
                JetspeedSecurity.addRole(role);
            }
            catch (RoleException e) {
                logger.error("Exception", (Throwable)((Object)e));
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "RoleForm");
                duri.addPathInfo("msgid", 3);
                rundata.setRedirectURI(duri.toString());
                if (role == null) break block3;
                rundata.getUser().setTemp(TEMP_ROLE, (Object)role);
            }
        }
    }

    public void doUpdate(RunData rundata, Context context) throws Exception {
        block3: {
            Role role = null;
            try {
                role = JetspeedSecurity.getRole(rundata.getParameters().getString("entityid"));
                JetspeedSecurity.saveRole(role);
            }
            catch (Exception e) {
                logger.error("Exception", e);
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "RoleForm");
                duri.addPathInfo("msgid", 0);
                if (role != null) {
                    duri.addPathInfo("entityid", role.getName());
                }
                duri.addQueryData("mode", "update");
                rundata.setRedirectURI(duri.toString());
                if (role == null) break block3;
                rundata.getUser().setTemp(TEMP_ROLE, (Object)role);
            }
        }
    }

    public void doDelete(RunData rundata, Context context) throws Exception {
        block3: {
            Role role = null;
            try {
                role = JetspeedSecurity.getRole(rundata.getParameters().getString("entityid"));
                JetspeedSecurity.removeRole(role.getName());
            }
            catch (Exception e) {
                logger.error("Exception", e);
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "RoleForm");
                duri.addPathInfo("msgid", 1);
                if (role != null) {
                    duri.addPathInfo("entityid", role.getName());
                }
                duri.addQueryData("mode", "delete");
                rundata.setRedirectURI(duri.toString());
                if (role == null) break block3;
                rundata.getUser().setTemp(TEMP_ROLE, (Object)role);
            }
        }
    }
}

