/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.PortletConfigState;
import org.apache.jetspeed.webservices.finance.stockmarket.StockQuote;
import org.apache.jetspeed.webservices.finance.stockmarket.StockQuoteService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class StockQuoteAction
extends VelocityPortletAction {
    private static final String SYMBOLS = "symbols";
    private static final String COLUMNS = "columns";
    private static final String QUOTES = "quotes";
    private static final String[] ALL_COLUMNS = new String[]{"Symbol", "Price", "Change", "Volume"};
    private static final String SELECTED_COLUMNS = "selected-columns";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(StockQuoteAction.class.getName());

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
        this.setTemplate(rundata, "stock-quote-customize");
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            StockQuoteService service = (StockQuoteService)TurbineServices.getInstance().getService("StockQuoteService");
            String symbols = PortletConfigState.getParameter(portlet, rundata, SYMBOLS, "IBM,MSFT,ORCL,SUNW");
            String columns = PortletConfigState.getParameter(portlet, rundata, COLUMNS, org.apache.jetspeed.util.StringUtils.arrayToString(ALL_COLUMNS, ","));
            String[] selectedColumnsArray = org.apache.jetspeed.util.StringUtils.stringToArray(columns, ",");
            String[] symbolArray = org.apache.jetspeed.util.StringUtils.stringToArray(symbols, ",");
            StockQuote[] quotes = service.fullQuotes(symbolArray);
            context.put(QUOTES, (Object)quotes);
            context.put(SELECTED_COLUMNS, (Object)selectedColumnsArray);
            context.put(COLUMNS, (Object)columns);
        }
        catch (Exception e) {
            logger.error("Exception", e);
            rundata.setMessage("Error in Jetspeed Stock Quotes: " + e.toString());
            rundata.setStackTrace(StringUtils.stackTrace((Throwable)e), (Throwable)e);
            rundata.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }
}

