/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import com.aimluck.eip.util.ALCommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.modules.actions.portlets.CustomizeSetAction;
import org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction;
import org.apache.jetspeed.om.BaseSecurityReference;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.Skin;
import org.apache.jetspeed.om.profile.psml.PsmlSkin;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.base.BaseParameter;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.PortletSkin;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.MetaData;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.jetspeed.util.StringUtils;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CustomizeAction
extends VelocityPortletAction {
    public static final String PARAM_NAMESPACE = "_param_";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(CustomizeAction.class.getName());

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        Profile profile;
        String currentTitle;
        context.put("skins", (Object)CustomizeSetAction.buildList(rundata, Registry.SKIN));
        context.put("securitys", (Object)CustomizeSetAction.buildList(rundata, Registry.SECURITY));
        Portlet p = ((JetspeedRunData)rundata).getCustomized();
        context.put("action", (Object)"portlets.CustomizeAction");
        PortletInstance instance = PersistenceManager.getInstance(p, rundata);
        context.put("portlet_instance", (Object)PersistenceManager.getInstance(p, rundata));
        if (p == null) {
            return;
        }
        PortletEntry entry = (PortletEntry)Registry.getEntry(Registry.PORTLET, p.getName());
        ArrayList<BaseParameter> params = new ArrayList<BaseParameter>();
        Iterator i = entry.getParameterNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            Parameter param = entry.getParameter(name);
            if (param.isHidden() || name.charAt(0) == '_' || !JetspeedSecurity.checkPermission((JetspeedUser)rundata.getUser(), new PortalResource(entry, param), "customize")) continue;
            BaseParameter clone = new BaseParameter();
            clone.setName(param.getName());
            clone.setTitle(param.getTitle());
            clone.setDescription(param.getDescription());
            clone.setType(param.getType());
            if (instance.getAttribute(name, null) != null) {
                clone.setValue(instance.getAttribute(name));
            } else if (p.getPortletConfig().getInitParameter(name) != null) {
                clone.setValue(p.getPortletConfig().getInitParameter(name));
            } else {
                clone.setValue(param.getValue());
            }
            params.add(clone);
        }
        Collections.sort(params, new Comparator(){

            public int compare(Object a, Object b) {
                Parameter p1 = (Parameter)a;
                Parameter p2 = (Parameter)b;
                return p1.getName().compareTo(p2.getName());
            }
        });
        SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
        customizationState.setAttribute("customize-parameters", params);
        context.put("parameters", params);
        context.put("portlet", (Object)p);
        context.put("customizer", (Object)portlet);
        context.put("utils", (Object)new ALCommonUtils());
        if (p.getPortletConfig().getSecurityRef() != null) {
            context.put("security_ref", (Object)p.getPortletConfig().getSecurityRef().getParent());
        }
        if (p.getPortletConfig().getSkin() != null) {
            context.put("current_skin", (Object)p.getPortletConfig().getPortletSkin().getName());
        }
        if ((currentTitle = (profile = ((JetspeedRunData)rundata).getCustomizedProfile()).getDocument().getEntryById(p.getID()).getTitle()) == null && p.getPortletConfig().getMetainfo() != null) {
            currentTitle = p.getPortletConfig().getMetainfo().getTitle();
        }
        context.put("current_title", (Object)currentTitle);
    }

    public void doCancel(RunData rundata, Context context) {
        ((JetspeedRunData)rundata).setCustomized(null);
        if (((JetspeedRunData)rundata).getCustomized() == null) {
            try {
                ActionLoader.getInstance().exec(rundata, "controls.EndCustomize");
            }
            catch (Exception e) {
                logger.error("Unable to load action controls.EndCustomize ", e);
            }
        }
    }

    public void doDefault(RunData rundata, Context context) {
        Portlet p = ((JetspeedRunData)rundata).getCustomized();
        try {
            Portlet portlet = ((JetspeedRunData)rundata).getCustomized();
            String defTitle = portlet.getPortletConfig().getMetainfo().getTitle();
            Profile profile = ((JetspeedRunData)rundata).getCustomizedProfile();
            Entry entry = profile.getDocument().getEntryById(p.getID());
            PortletConfig pc = p.getPortletConfig();
            MetaData md = pc.getMetainfo();
            if (md == null) {
                md = new MetaData();
                pc.setMetainfo(md);
            }
            md.setTitle(defTitle);
            entry.setTitle(defTitle);
            PortletInstance instance = PersistenceManager.getInstance(p, rundata);
            instance.removeAllAttributes();
            profile.store();
            p.init();
            try {
                PortletSessionState.setPortletConfigChanged(p, rundata);
                p.init();
            }
            catch (PortletException e) {
                logger.error("Customizer failed to reinitialize the portlet " + p.getName(), e);
            }
            this.doCancel(rundata, context);
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
    }

    public void doUpdate(RunData rundata, Context context) {
        SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
        Portlet p = ((JetspeedRunData)rundata).getCustomized();
        List params = (List)customizationState.getAttribute("customize-parameters");
        String newSecurityParent = rundata.getParameters().getString("_security_ref");
        String newSkinName = rundata.getParameters().getString("_skin");
        String newTitle = rundata.getParameters().getString("current_title");
        boolean changeRequested = params != null || newSkinName != null || newSecurityParent != null || newTitle != null;
        boolean madePsChange = false;
        boolean madePcChange = false;
        if (p == null || !changeRequested) {
            this.doCancel(rundata, context);
            return;
        }
        PortletConfig pc = p.getPortletConfig();
        Profile profile = ((JetspeedRunData)rundata).getCustomizedProfile();
        Entry entry = profile.getDocument().getEntryById(p.getID());
        if (newSecurityParent != null) {
            boolean securityChanged = false;
            SecurityReference currentSecurityRef = pc.getSecurityRef();
            if (currentSecurityRef != null) {
                securityChanged = !newSecurityParent.equals(currentSecurityRef.getParent());
            } else {
                boolean bl = securityChanged = newSecurityParent.trim().length() > 0;
            }
            if (securityChanged) {
                BaseSecurityReference securityRef = null;
                if (newSecurityParent.trim().length() > 0) {
                    securityRef = new BaseSecurityReference();
                    securityRef.setParent(newSecurityParent);
                }
                pc.setSecurityRef(securityRef);
                entry.setSecurityRef(securityRef);
                madePcChange = true;
            }
        }
        if (newSkinName != null) {
            boolean skinChanged = false;
            String currentSkinName = null;
            if (pc.getSkin() != null) {
                currentSkinName = pc.getPortletSkin().getName();
            }
            if (currentSkinName != null) {
                skinChanged = !newSkinName.equals(currentSkinName);
            } else {
                boolean bl = skinChanged = newSkinName.trim().length() > 0;
            }
            if (skinChanged) {
                PortletSkin skin = null;
                if (newSkinName.trim().length() > 0) {
                    skin = PortalToolkit.getSkin(newSkinName);
                    if (skin != null) {
                        pc.setPortletSkin(skin);
                        Skin psmlSkin = entry.getSkin();
                        if (psmlSkin == null) {
                            entry.setSkin(new PsmlSkin());
                        }
                        entry.getSkin().setName(newSkinName);
                    } else {
                        logger.warn("Unable to update skin for portlet entry " + entry.getId() + " because skin does not exist.");
                    }
                } else {
                    pc.setPortletSkin(null);
                    entry.setSkin(null);
                }
                madePcChange = true;
            }
        }
        if (newTitle != null) {
            boolean titleChanged = false;
            String currentTitle = entry.getTitle();
            MetaData md = pc.getMetainfo();
            if (currentTitle == null && md != null && md.getTitle() != null) {
                currentTitle = md.getTitle();
            }
            if (currentTitle != null) {
                titleChanged = !newTitle.equals(currentTitle);
            } else {
                boolean bl = titleChanged = newTitle.trim().length() > 0;
            }
            if (titleChanged && newTitle.trim().length() > 0) {
                if (md == null) {
                    md = new MetaData();
                    pc.setMetainfo(md);
                }
                md.setTitle(newTitle);
                entry.setTitle(newTitle);
                madePcChange = true;
            }
        }
        try {
            PortletInstance instance = PersistenceManager.getInstance(p, rundata);
            PortletEntry regEntry = (PortletEntry)Registry.getEntry(Registry.PORTLET, p.getName());
            for (Parameter param : params) {
                String name = param.getName();
                String newValue = null;
                String[] testArray = rundata.getParameters().getStrings(name);
                if (testArray != null && testArray.length > 1) {
                    newValue = StringUtils.arrayToString(testArray, ",");
                } else {
                    newValue = rundata.getParameters().getString(name);
                    if (newValue == null) {
                        newValue = "";
                    }
                }
                String regValue = regEntry.getParameter(name).getValue();
                String psmlValue = instance.getAttribute(name);
                if (newValue != null) {
                    if (!regValue.equals(newValue) || !psmlValue.equals(newValue)) {
                        instance.setAttribute(name, newValue);
                        psmlValue = newValue;
                    }
                    madePsChange = true;
                }
                if (psmlValue == null || !psmlValue.equals(regValue)) continue;
                instance.removeAttribute(name);
                madePsChange = true;
            }
            if (madePsChange || madePcChange) {
                try {
                    JetspeedRunData jdata = (JetspeedRunData)rundata;
                    profile.store();
                    p.init();
                    PortletSessionState.setPortletConfigChanged(p, rundata);
                }
                catch (PortletException e) {
                    logger.error("Customizer failed to reinitialize the portlet " + p.getName(), e);
                }
                catch (Exception e) {
                    logger.error("Unable to save profile ", e);
                }
            }
            this.doCancel(rundata, context);
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
    }
}

