/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import org.apache.jetspeed.modules.actions.portlets.RegistryUpdateAction;
import org.apache.jetspeed.om.registry.MediaTypeRegistry;
import org.apache.jetspeed.om.registry.PortletControllerEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ControllerUpdateAction
extends RegistryUpdateAction {
    private static final String CONTROLLER_UPDATE_PANE = "ControllerForm";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ControllerUpdateAction.class.getName());

    public ControllerUpdateAction() {
        this.registryEntryName = "controller_name";
        this.registry = Registry.PORTLET_CONTROLLER;
        this.pane = CONTROLLER_UPDATE_PANE;
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        super.buildNormalContext(portlet, context, rundata);
        String mode = rundata.getParameters().getString("mode");
        if (mode != null) {
            if (mode.equals("delete") || mode.equals("update")) {
                String controllerName = rundata.getParameters().getString(this.registryEntryName);
                PortletControllerEntry controllerEntry = (PortletControllerEntry)Registry.getEntry(this.registry, controllerName);
                context.put("entry", (Object)controllerEntry);
            }
            if (mode.equals("update")) {
                MediaTypeRegistry mediaTypeReg = (MediaTypeRegistry)Registry.get(Registry.MEDIA_TYPE);
                context.put("media_types", (Object)this.iteratorToCollection(mediaTypeReg.listEntryNames()));
            }
        }
    }

    protected void updateRegistryEntry(RunData rundata, RegistryEntry registryEntry) throws Exception {
        super.updateRegistryEntry(rundata, registryEntry);
        PortletControllerEntry controllerEntry = (PortletControllerEntry)registryEntry;
        String className = rundata.getParameters().getString("class_name");
        if (this.hasChanged(controllerEntry.getClassname(), className)) {
            controllerEntry.setClassname(className);
        }
    }

    protected void clearUserData(RunData rundata) {
        block2: {
            try {
                super.clearUserData(rundata);
                rundata.getUser().removeTemp("media_type_ref");
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("ControllerUpdateAction: Failed to clear user data");
            }
        }
    }

    protected void resetForm(RunData rundata) {
        super.resetForm(rundata);
        String mediaTypeRef = rundata.getParameters().getString("media_type_ref");
        rundata.getUser().setTemp("media_type_ref", (Object)mediaTypeRef);
    }
}

