/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.controls;

import com.aimluck.eip.util.ALSessionInitializer;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletState;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.modules.Action;
import org.apache.turbine.util.RunData;

public class Restore
extends Action {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(Restore.class.getName());

    public void doPerform(RunData rundata) throws Exception {
        JetspeedRunData jdata;
        if (rundata.getUser() == null) {
            return;
        }
        String peid = rundata.getParameters().getString("js_peid");
        if (peid == null && (peid = (String)(jdata = (JetspeedRunData)rundata).getUser().getTemp("js_peid")) == null) {
            return;
        }
        jdata = (JetspeedRunData)rundata;
        Entry entry = jdata.getProfile().getDocument().getEntryById(peid);
        if (entry == null) {
            logger.warn("Failed to get PEID (" + peid + ") entry for User (" + rundata.getUser().getName() + ")");
            return;
        }
        Portlet portlet = PortletFactory.getPortlet(entry);
        if (portlet != null && portlet instanceof PortletState) {
            ((PortletState)((Object)portlet)).setMinimized(false, rundata);
        }
        while (jdata.getCustomized() != null) {
            jdata.setCustomized(null);
        }
        jdata.getUser().removeTemp("js_peid");
        JetspeedUser user = (JetspeedUser)jdata.getUser();
        if (!(user != null && user.hasLoggedIn() || JetspeedResources.getBoolean("automatic.logon.enable", false))) {
            String uri = jdata.getRequest().getRequestURI().trim();
            String servername = jdata.getServletConfig().getServletName();
            if (!uri.equals("/" + servername + "/portal/") && !uri.equals("/" + servername + "/portal")) {
                jdata.setScreenTemplate("Timeout");
                if (jdata.getSession() != null) {
                    try {
                        jdata.getSession().invalidate();
                    }
                    catch (IllegalStateException ex) {
                        logger.debug("\u30bb\u30c3\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u524a\u9664\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                    }
                }
            }
        } else {
            jdata.setScreenTemplate("Home");
        }
        ALSessionInitializer sinit = new ALSessionInitializer();
        sinit.initializeSession(jdata, peid);
    }
}

