/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.controls;

import java.util.Enumeration;
import java.util.Stack;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletControl;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.modules.Action;
import org.apache.turbine.util.RunData;

public class Customize
extends Action {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(Customize.class.getName());
    protected boolean hasAuthority;

    public void doPerform(RunData rundata) throws Exception {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        jdata.cleanupFromCustomization();
        if (jdata.getUser() == null) {
            return;
        }
        if (jdata.getProfile() == null) {
            return;
        }
        String editMediaType = jdata.getParameters().getString("mtype");
        String resetStack = jdata.getParameters().getString("reset");
        String peid = jdata.getParameters().getString("js_peid");
        Profile profile = null;
        if (resetStack != null && (resetStack.equalsIgnoreCase("on") || resetStack.equalsIgnoreCase("1"))) {
            jdata.cleanupFromCustomization();
        }
        if (jdata.getCustomizedProfile() == null) {
            ProfileLocator locator = (ProfileLocator)jdata.getProfile().clone();
            if (editMediaType != null) {
                locator.setMediaType(editMediaType);
            }
            profile = (Profile)Profiler.getProfile(locator).clone();
            jdata.setCustomizedProfile(profile);
        } else {
            profile = jdata.getCustomizedProfile();
        }
        if (peid == null) {
            peid = profile.getRootSet().getID();
            jdata.setJs_peid(peid);
        }
        Portlet found = null;
        Stack<Portlet> sets = new Stack<Portlet>();
        sets.push(profile.getRootSet());
        while (found == null && sets.size() > 0) {
            PortletSet set = (PortletSet)sets.pop();
            if (set.getID().equals(peid)) {
                found = set;
                continue;
            }
            Enumeration en = set.getPortlets();
            while (found == null && en.hasMoreElements()) {
                Portlet p;
                Portlet real = p = (Portlet)en.nextElement();
                while (real instanceof PortletControl) {
                    real = ((PortletControl)p).getPortlet();
                }
                if (real instanceof PortletSet) {
                    if (real.getID().equals(peid)) {
                        found = real;
                        continue;
                    }
                    sets.push(real);
                    continue;
                }
                if (!p.getID().equals(peid)) continue;
                found = p;
            }
        }
        if (found != null) {
            PortalResource portalResource = new PortalResource(found);
            try {
                JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
                portalResource.setOwner(jsLink.getUserName());
                JetspeedLinkFactory.putInstance(jsLink);
            }
            catch (Exception e) {
                logger.warn(e.toString());
                portalResource.setOwner(null);
            }
            if (!JetspeedSecurity.checkPermission((JetspeedUser)jdata.getUser(), portalResource, "customize")) {
                logger.warn("User " + jdata.getUser().getUserName() + " has no customize permission for portlet with id " + peid);
                jdata.setMessage("Sorry, you have no customize permission for this portlet");
                return;
            }
            jdata.setCustomized(found);
            jdata.setScreenTemplate("Customize");
        }
        jdata.getUser().removeTemp("js_peid");
    }

    public static void save(RunData data) {
        try {
            Profile profile = ((JetspeedRunData)data).getCustomizedProfile();
            profile.store();
        }
        catch (Exception e) {
            logger.error("Error while saving profile", e);
        }
    }

    public static void exit(RunData data) {
        JetspeedLink jsLink = null;
        ((JetspeedRunData)data).cleanupFromCustomization();
        try {
            jsLink = JetspeedLinkFactory.getInstance(data);
            String mtype = data.getParameters().getString("mtype");
            if (mtype != null) {
                jsLink.setMediaType(mtype);
                jsLink.addQueryData("mtype", mtype);
            }
        }
        catch (Exception e) {
            logger.error("exit error", e);
        }
        data.setRedirectURI(((Object)jsLink).toString());
        JetspeedLinkFactory.putInstance(jsLink);
        jsLink = null;
    }
}

