/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.controllers;

import com.aimluck.eip.util.ALEipUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.jetspeed.modules.actions.controllers.VelocityControllerAction;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.IdentityElement;
import org.apache.jetspeed.om.profile.Layout;
import org.apache.jetspeed.om.profile.MetaInfo;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Reference;
import org.apache.jetspeed.om.profile.psml.PsmlControl;
import org.apache.jetspeed.om.profile.psml.PsmlLayout;
import org.apache.jetspeed.om.profile.psml.PsmlParameter;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MultiColumnControllerAction
extends VelocityControllerAction {
    private static final String REFERENCES_REMOVED = "references-removed";
    private static final String FS = File.separator;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(MultiColumnControllerAction.class.getName());

    protected void buildNormalContext(PortletController controller, Context context, RunData rundata) {
        try {
            String cols = controller.getConfig().getInitParameter("cols");
            int colNum = 0;
            int rowNum = 0;
            try {
                colNum = Integer.parseInt(cols);
            }
            catch (Exception e) {
                colNum = 3;
            }
            context.put("colNum", (Object)String.valueOf(colNum));
            String sizes = controller.getConfig().getInitParameter("sizes");
            context.put("sizes", (Object)MultiColumnControllerAction.getCellSizes(sizes));
            String columnClasses = controller.getConfig().getInitParameter("col_classes");
            context.put("col_classes", (Object)MultiColumnControllerAction.getCellClasses(columnClasses));
            PortletSet set = controller.getPortlets();
            Enumeration en = set.getPortlets();
            int row = 0;
            int col = 0;
            while (en.hasMoreElements()) {
                Portlet p = (Portlet)en.nextElement();
                PortletSet.Constraints constraints = p.getPortletConfig().getConstraints();
                if (constraints == null || constraints.getColumn() == null || constraints.getRow() == null) continue;
                col = constraints.getColumn();
                if (col > colNum) {
                    constraints.setColumn(col % colNum);
                }
                if ((row = constraints.getRow().intValue()) <= rowNum) continue;
                rowNum = row;
            }
            row = (int)Math.ceil((double)set.size() / (double)colNum);
            if (row > rowNum) {
                rowNum = row;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Controller calculated setSize " + set.size() + " row " + row + " colNum: " + colNum + " rowNum: " + rowNum);
            }
            List[] table = new List[colNum];
            List<Object> filler = Collections.nCopies(rowNum + 2, null);
            for (int i = 0; i < colNum; ++i) {
                table[i] = new ArrayList();
                table[i].addAll(filler);
            }
            ArrayList<Portlet> work = new ArrayList<Portlet>();
            for (int i = 0; i < set.size(); ++i) {
                Portlet p = set.getPortletAt(i);
                String name = p.getName();
                PortletSet.Constraints constraints = p.getPortletConfig().getConstraints();
                if (constraints != null && constraints.getColumn() != null && constraints.getRow() != null && constraints.getColumn() < colNum) {
                    row = constraints.getRow();
                    col = constraints.getColumn();
                    table[col].set(row + 1, p);
                    continue;
                }
                work.add(p);
            }
            Iterator i = work.iterator();
            for (row = 0; row < rowNum; ++row) {
                for (col = 0; i.hasNext() && col < colNum; ++col) {
                    if (table[col].get(row) != null) continue;
                    table[col].set(row, i.next());
                }
            }
            for (int j = 0; j < table.length; ++j) {
                i = table[j].iterator();
                while (i.hasNext()) {
                    Object obj = i.next();
                    if (obj != null) continue;
                    i.remove();
                }
            }
            if (logger.isDebugEnabled()) {
                this.dumpColumns(table);
            }
            context.put("portlets", (Object)table);
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
    }

    protected void buildCustomizeContext(PortletController controller, Context context, RunData rundata) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        int aclType = 0;
        aclType = 4;
        boolean hasAuthority = ALEipUtils.getHasAuthority(rundata, context, aclType);
        context.put("authority", (Object)hasAuthority);
        SessionState customizationState = jdata.getPageSessionState();
        super.buildCustomizeContext(controller, context, rundata);
        Object[] columns = null;
        String cols = controller.getConfig().getInitParameter("cols");
        int colNum = 0;
        try {
            colNum = Integer.parseInt(cols);
        }
        catch (Exception e) {
            colNum = 3;
        }
        context.put("colNum", (Object)String.valueOf(colNum));
        String sizes = controller.getConfig().getInitParameter("sizes");
        context.put("sizes", (Object)MultiColumnControllerAction.getCellSizes(sizes));
        String columnClasses = controller.getConfig().getInitParameter("col_classes");
        context.put("col_classes", (Object)MultiColumnControllerAction.getCellClasses(columnClasses));
        columns = (List[])customizationState.getAttribute("customize-columns");
        PortletSet customizedSet = (PortletSet)jdata.getCustomized();
        Portlets set = jdata.getCustomizedProfile().getDocument().getPortletsById(customizedSet.getID());
        if (logger.isDebugEnabled()) {
            logger.debug("MultiCol: columns " + Arrays.toString(columns) + " set " + set);
        }
        if (columns != null && columns.length == colNum) {
            int eCount = 0;
            for (int i = 0; i < columns.length; ++i) {
                eCount += columns[i].size();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("MultiCol: eCount " + eCount + " setCount" + set.getEntryCount() + set.getPortletsCount());
            }
            if (eCount != set.getEntryCount() + set.getPortletsCount()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("MultiCol: rebuilding columns ");
                }
                columns = MultiColumnControllerAction.buildColumns(set, colNum);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("MultiCol: rebuilding columns ");
            }
            columns = MultiColumnControllerAction.buildColumns(set, colNum);
        }
        customizationState.setAttribute("customize-columns", columns);
        context.put("portlets", (Object)columns);
        HashMap<String, String> titles = new HashMap<String, String>();
        for (int col = 0; col < columns.length; ++col) {
            for (int row = 0; row < columns[col].size(); ++row) {
                IdentityElement identityElement = (IdentityElement)columns[col].get(row);
                MetaInfo metaInfo = identityElement.getMetaInfo();
                if (metaInfo != null && metaInfo.getTitle() != null) {
                    titles.put(identityElement.getId(), metaInfo.getTitle());
                    continue;
                }
                if (identityElement instanceof Entry) {
                    Entry entry = (Entry)identityElement;
                    PortletEntry pentry = (PortletEntry)Registry.getEntry(Registry.PORTLET, entry.getParent());
                    if (pentry != null && pentry.getTitle() != null) {
                        titles.put(entry.getId(), pentry.getTitle());
                        continue;
                    }
                    titles.put(entry.getId(), entry.getParent());
                    continue;
                }
                if (identityElement instanceof Reference) {
                    titles.put(identityElement.getId(), Localization.getString((RunData)rundata, (String)"CUSTOMIZER_REF_DEFAULTTITLE"));
                    continue;
                }
                titles.put(identityElement.getId(), Localization.getString((RunData)rundata, (String)"CUSTOMIZER_NOTITLESET"));
            }
        }
        HashMap<String, String> descriptions = new HashMap<String, String>();
        for (int col = 0; col < columns.length; ++col) {
            for (int row = 0; row < columns[col].size(); ++row) {
                IdentityElement identityElement = (IdentityElement)columns[col].get(row);
                MetaInfo metaInfo = identityElement.getMetaInfo();
                if (metaInfo != null && metaInfo.getDescription() != null) {
                    descriptions.put(identityElement.getId(), metaInfo.getDescription());
                    continue;
                }
                if (identityElement instanceof Entry) {
                    Entry entry = (Entry)identityElement;
                    PortletEntry pentry = (PortletEntry)Registry.getEntry(Registry.PORTLET, entry.getParent());
                    if (pentry != null && pentry.getDescription() != null) {
                        descriptions.put(entry.getId(), pentry.getDescription());
                        continue;
                    }
                    descriptions.put(entry.getId(), entry.getParent());
                    continue;
                }
                descriptions.put(identityElement.getId(), "\u8aac\u660e\u306a\u3057");
            }
        }
        context.put("titles", titles);
        context.put("descriptions", descriptions);
        context.put("action", (Object)"controllers.MultiColumnControllerAction");
    }

    public void doCancel(RunData data, Context context) {
        ((JetspeedRunData)data).setCustomized(null);
        if (((JetspeedRunData)data).getCustomized() == null) {
            try {
                ActionLoader.getInstance().exec(data, "controls.EndCustomize");
            }
            catch (Exception e) {
                logger.error("Unable to load action controls.EndCustomize ", e);
            }
        }
    }

    public void doSave(RunData data, Context context) {
        SessionState customizationState = ((JetspeedRunData)data).getPageSessionState();
        List[] columns = (List[])customizationState.getAttribute("customize-columns");
        for (int col = 0; col < columns.length; ++col) {
            for (int row = 0; row < columns[col].size(); ++row) {
                MultiColumnControllerAction.setPosition((IdentityElement)columns[col].get(row), col, row);
            }
        }
        try {
            ((JetspeedRunData)data).getCustomizedProfile().store();
            String referencesRemoved = (String)customizationState.getAttribute(REFERENCES_REMOVED);
            if (referencesRemoved != null && referencesRemoved.equals("true")) {
                PsmlManager.refresh(((JetspeedRunData)data).getCustomizedProfile());
            }
        }
        catch (Exception e) {
            logger.error("Unable to save profile ", e);
        }
        try {
            ActionLoader.getInstance().exec(data, "controls.EndCustomize");
        }
        catch (Exception e) {
            logger.error("Unable to load action controls.EndCustomize ", e);
        }
    }

    public void doDelete(RunData data, Context context) {
        JetspeedRunData jdata = (JetspeedRunData)data;
        ALEipUtils.CheckAclPermissionForCustomize(data, context, 16);
        SessionState customizationState = jdata.getPageSessionState();
        PortletSet customizedSet = (PortletSet)jdata.getCustomized();
        customizationState.setAttribute(REFERENCES_REMOVED, "false");
        int col = data.getParameters().getInt("col", -1);
        int row = data.getParameters().getInt("row", -1);
        List[] columns = (List[])customizationState.getAttribute("customize-columns");
        if (columns == null) {
            return;
        }
        if (col > -1 && row > -1) {
            try {
                IdentityElement identityElement = (IdentityElement)columns[col].get(row);
                columns[col].remove(row);
                Portlets portlets = jdata.getCustomizedProfile().getDocument().getPortletsById(customizedSet.getID());
                if (portlets != null) {
                    if (identityElement instanceof Entry) {
                        for (int i = 0; i < portlets.getEntryCount(); ++i) {
                            if (portlets.getEntry(i) != identityElement) continue;
                            portlets.removeEntry(i);
                        }
                    } else if (identityElement instanceof Reference) {
                        for (int i = 0; i < portlets.getReferenceCount(); ++i) {
                            if (portlets.getReference(i) != identityElement) continue;
                            customizationState.setAttribute(REFERENCES_REMOVED, "true");
                            portlets.removeReference(i);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("MultiColumnControllerAction: Probably got wrong coordinates", e);
            }
        }
    }

    public void doLeft(RunData data, Context context) {
        ALEipUtils.CheckAclPermissionForCustomize(data, context, 8);
        SessionState customizationState = ((JetspeedRunData)data).getPageSessionState();
        List[] columns = (List[])customizationState.getAttribute("customize-columns");
        int col = data.getParameters().getInt("col", -1);
        int row = data.getParameters().getInt("row", -1);
        if (columns == null) {
            return;
        }
        if (col > 0 && row > -1) {
            MultiColumnControllerAction.move(columns, col, row, col - 1, row);
        }
    }

    public void doRight(RunData data, Context context) {
        ALEipUtils.CheckAclPermissionForCustomize(data, context, 8);
        SessionState customizationState = ((JetspeedRunData)data).getPageSessionState();
        List[] columns = (List[])customizationState.getAttribute("customize-columns");
        int col = data.getParameters().getInt("col", -1);
        int row = data.getParameters().getInt("row", -1);
        if (columns == null) {
            return;
        }
        if (col > -1 && row > -1 && col < columns.length - 1) {
            MultiColumnControllerAction.move(columns, col, row, col + 1, row);
        }
    }

    public void doUp(RunData data, Context context) {
        ALEipUtils.CheckAclPermissionForCustomize(data, context, 8);
        SessionState customizationState = ((JetspeedRunData)data).getPageSessionState();
        List[] columns = (List[])customizationState.getAttribute("customize-columns");
        int col = data.getParameters().getInt("col", -1);
        int row = data.getParameters().getInt("row", -1);
        if (columns == null) {
            return;
        }
        if (col > -1 && row > 0) {
            MultiColumnControllerAction.move(columns, col, row, col, row - 1);
        }
    }

    public void doDown(RunData data, Context context) {
        ALEipUtils.CheckAclPermissionForCustomize(data, context, 8);
        SessionState customizationState = ((JetspeedRunData)data).getPageSessionState();
        List[] columns = (List[])customizationState.getAttribute("customize-columns");
        int col = data.getParameters().getInt("col", -1);
        int row = data.getParameters().getInt("row", -1);
        if (columns == null) {
            return;
        }
        if (col > -1 && row > -1 && row < columns[col].size() - 1) {
            MultiColumnControllerAction.move(columns, col, row, col, row + 1);
        }
    }

    public void doControl(RunData data, Context context) {
        JetspeedRunData jdata = (JetspeedRunData)data;
        String controlName = data.getParameters().getString("control");
        String id = data.getParameters().getString("js_peid");
        try {
            Entry entry = jdata.getCustomizedProfile().getDocument().getEntryById(id);
            if (entry != null) {
                if (controlName != null && controlName.trim().length() > 0) {
                    PsmlControl control = new PsmlControl();
                    control.setName(controlName);
                    if (control != null) {
                        entry.setControl(control);
                    }
                } else {
                    entry.setControl(null);
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
    }

    protected static void setPosition(IdentityElement identityElement, int col, int row) {
        boolean colFound = false;
        boolean rowFound = false;
        if (identityElement != null) {
            Layout layout = identityElement.getLayout();
            if (layout == null) {
                layout = new PsmlLayout();
                identityElement.setLayout(layout);
            }
            for (int i = 0; i < layout.getParameterCount(); ++i) {
                Parameter p = layout.getParameter(i);
                if (p.getName().equals("column")) {
                    p.setValue(String.valueOf(col));
                    colFound = true;
                    continue;
                }
                if (!p.getName().equals("row")) continue;
                p.setValue(String.valueOf(row));
                rowFound = true;
            }
            if (!colFound) {
                PsmlParameter p = new PsmlParameter();
                p.setName("column");
                p.setValue(String.valueOf(col));
                layout.addParameter(p);
            }
            if (!rowFound) {
                PsmlParameter p = new PsmlParameter();
                p.setName("row");
                p.setValue(String.valueOf(row));
                layout.addParameter(p);
            }
        }
    }

    protected static void move(List[] cols, int oCol, int oRow, int nCol, int nRow) {
        Object obj = null;
        if (oCol < cols.length && oRow < cols[oCol].size() && (obj = (Object)cols[oCol].get(oRow)) != null) {
            cols[oCol].remove(oRow);
        }
        if (obj != null && nCol < cols.length) {
            if (nRow < cols[nCol].size()) {
                cols[nCol].add(nRow, obj);
            } else {
                cols[nCol].add(obj);
            }
        }
    }

    protected static List[] buildColumns(Portlets set, int colNum) {
        int i;
        Iterator iterator = set.getEntriesIterator();
        int row = 0;
        int col = 0;
        int rowNum = 0;
        while (iterator.hasNext()) {
            IdentityElement identityElement = (IdentityElement)iterator.next();
            Layout layout = identityElement.getLayout();
            if (layout == null) continue;
            for (int p = 0; p < layout.getParameterCount(); ++p) {
                Parameter prop = layout.getParameter(p);
                try {
                    if (prop.getName().equals("row")) {
                        row = Integer.parseInt(prop.getValue());
                        if (row <= rowNum) continue;
                        rowNum = row;
                        continue;
                    }
                    if (!prop.getName().equals("column") || (col = Integer.parseInt(prop.getValue())) <= colNum) continue;
                    prop.setValue(String.valueOf(col % colNum));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        int sCount = set.getEntryCount() + set.getPortletsCount();
        row = sCount / colNum + 1;
        if (row > rowNum) {
            rowNum = row;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Controller customize colNum: " + colNum + " rowNum: " + rowNum);
        }
        List[] table = new List[colNum];
        List<Object> filler = Collections.nCopies(rowNum + 1, null);
        for (int i2 = 0; i2 < colNum; ++i2) {
            table[i2] = new ArrayList();
            table[i2].addAll(filler);
        }
        ArrayList work = new ArrayList();
        for (i = 0; i < set.getEntryCount(); ++i) {
            MultiColumnControllerAction.addElement(set.getEntry(i), table, work, colNum);
        }
        for (i = 0; i < set.getReferenceCount(); ++i) {
            MultiColumnControllerAction.addElement(set.getReference(i), table, work, colNum);
        }
        Iterator i3 = work.iterator();
        for (row = 0; row < rowNum; ++row) {
            for (col = 0; i3.hasNext() && col < colNum; ++col) {
                if (table[col].get(row) != null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Set portlet at col " + col + " row " + row);
                }
                table[col].set(row, i3.next());
            }
        }
        for (int j = 0; j < table.length; ++j) {
            if (logger.isDebugEnabled()) {
                logger.debug("Column " + j);
            }
            i3 = table[j].iterator();
            while (i3.hasNext()) {
                Object obj = i3.next();
                if (logger.isDebugEnabled()) {
                    logger.debug("Element " + obj);
                }
                if (obj != null) continue;
                i3.remove();
            }
        }
        return table;
    }

    protected static List getCellSizes(String sizeList) {
        Vector<String> list = new Vector<String>();
        if (sizeList != null) {
            StringTokenizer st = new StringTokenizer(sizeList, ",");
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return list;
    }

    protected static List getCellClasses(String classlist) {
        Vector<String> list = new Vector<String>();
        if (classlist != null) {
            StringTokenizer st = new StringTokenizer(classlist, ",");
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return list;
    }

    protected static void addElement(IdentityElement element, List[] table, List work, int columnCount) {
        Layout layout = element.getLayout();
        int row = -1;
        int col = -1;
        if (layout != null) {
            try {
                for (int p = 0; p < layout.getParameterCount(); ++p) {
                    Parameter prop = layout.getParameter(p);
                    if (prop.getName().equals("row")) {
                        row = Integer.parseInt(prop.getValue());
                        continue;
                    }
                    if (!prop.getName().equals("column")) continue;
                    col = Integer.parseInt(prop.getValue());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Constraints col " + col + " row " + row);
        }
        if (row >= 0 && col >= 0 && col < columnCount && table[col].get(row) == null) {
            table[col].set(row, element);
        } else {
            if (layout != null) {
                element.setLayout(null);
                layout = null;
            }
            work.add(element);
        }
    }

    protected void dumpColumns(List[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            logger.debug("Column " + i);
            for (int j = 0; j < cols[i].size(); ++j) {
                logger.debug("Row " + j + " object: " + cols[i].get(j));
            }
        }
    }
}

