/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.mail.SimpleEmail;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.AccountExpiredException;
import org.apache.jetspeed.services.security.CredentialExpiredException;
import org.apache.jetspeed.services.security.FailedLoginException;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.nosecurity.FakeJetspeedUser;
import org.apache.turbine.modules.ActionEvent;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class JLoginUser
extends ActionEvent {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JLoginUser.class.getName());

    public void doReminder(RunData rundata) throws Exception {
        JetspeedRunData data = (JetspeedRunData)rundata;
        try {
            String username = data.getParameters().getString("username", "");
            JetspeedUser user = null;
            try {
                user = JetspeedSecurity.getUser(username);
            }
            catch (JetspeedSecurityException ignored) {
                // empty catch block
            }
            if (user == null) {
                data.setScreenTemplate("LoginHelp");
                data.setMessage(Localization.getString((String)"JLOGINUSER_PASSWORDREMINDER_INVALIDUSER"));
                if (logger.isDebugEnabled()) {
                    logger.debug(Localization.getString((RunData)rundata, (String)"JLOGINUSER_PASSWORDREMINDER_INVALIDUSER"));
                }
                return;
            }
            user.setHasLoggedIn(Boolean.FALSE);
            data.setUser(user);
            DynamicURI url = new DynamicURI((RunData)data);
            StringWriter email_body = new StringWriter();
            Context context = TurbineVelocity.getContext((RunData)data);
            context.put("data", (Object)data);
            context.put("user", (Object)user);
            context.put("userurl", (Object)url);
            context.put("config", (Object)new JetspeedResources());
            String lang = (String)user.getPerm("language");
            String ctry = (String)user.getPerm("country");
            Locale loc = null;
            if (lang != null && ctry != null) {
                loc = new Locale(lang, ctry);
            }
            String templatePath = TemplateLocator.locateEmailTemplate((RunData)data, JetspeedResources.getString("password.reminder.template"), loc);
            SimpleEmail se = new SimpleEmail();
            String charset = JetspeedResources.getString("newuser.notification.charset", "iso-8859-1");
            se.setCharset(charset);
            context.put("firstname", (Object)StringEscapeUtils.unescapeHtml(user.getFirstName()));
            context.put("lastname", (Object)StringEscapeUtils.unescapeHtml(user.getLastName()));
            context.put("username", (Object)StringEscapeUtils.unescapeHtml(user.getUserName()));
            context.put("email", (Object)se);
            TurbineVelocity.handleRequest((Context)context, (String)templatePath, (Writer)email_body);
            se.setMsg(email_body.toString());
            Properties props = System.getProperties();
            String mailServerMachine = JetspeedResources.getString("mail.server");
            props.put("mail.host", mailServerMachine);
            props.put("mail.smtp.host", mailServerMachine);
            se.send();
            data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_PASSWORDREMINDER_SENT"));
            logger.info("Password for user " + user.getUserName() + " was sent to " + user.getEmail());
            logger.info(Localization.getString((RunData)rundata, (String)"JLOGINUSER_PASSWORDREMINDER_SENT"));
            data.setScreenTemplate("Login");
        }
        catch (Exception e) {
            data.setScreenTemplate("LoginHelp");
            String errorTitle = Localization.getString((RunData)rundata, (String)"JLOGINUSER_PASSWORDREMINDER_ERROR");
            String errorMessage = errorTitle + e.toString();
            logger.warn(errorMessage, e);
            data.setMessage(errorMessage);
        }
    }

    public void doPerform(RunData rundata) throws Exception {
        String message;
        JetspeedRunData data = (JetspeedRunData)rundata;
        String username = data.getParameters().getString("username", "");
        String password = data.getParameters().getString("password", "");
        boolean newUserApproval = JetspeedResources.getBoolean("newuser.approval.enable", false);
        String secretkey = data.getParameters().getString("secretkey", null);
        if (secretkey != null) {
            String button1 = data.getParameters().getString("submit1", null);
            if (button1 != null && button1.equalsIgnoreCase("Cancel")) {
                data.setScreenTemplate(TurbineTemplate.getDefaultScreen());
                return;
            }
            JetspeedUser user = JetspeedSecurity.getUser(username);
            if (user == null) {
                logger.warn("JLogin User: Unexpected condition : user is NULL");
                return;
            }
            String confirm_value = user.getConfirmed();
            if (!secretkey.equals(confirm_value) && !confirm_value.equals("CONFIRMED")) {
                if (newUserApproval) {
                    data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                    data.setScreenTemplate("NewUserAwaitingAcceptance");
                    return;
                }
                if (user.getConfirmed().equals("REJECTED")) {
                    data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                    data.setScreenTemplate("NewUserRejected");
                    return;
                }
                data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                data.setScreenTemplate("ConfirmRegistration");
                return;
            }
            user.setConfirmed("CONFIRMED");
            data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_WELCOME"));
            JetspeedSecurity.saveUser(user);
        }
        JetspeedUser user = null;
        try {
            user = JetspeedSecurity.login(username, password);
            JetspeedSecurity.saveUser(user);
        }
        catch (LoginException e) {
            data.setScreenTemplate(JetspeedResources.getString("template.login"));
            message = e.getMessage() != null ? e.getMessage() : e.toString();
            data.setMessage(message);
            data.setUser(JetspeedSecurity.getAnonymousUser());
            data.getUser().setHasLoggedIn(new Boolean(false));
            if (e instanceof FailedLoginException) {
                if (!this.disableCheck(data)) {
                    logger.info("JLoginUser: Credential Failure on login for user: " + username);
                    data.setMessage(Localization.getString((RunData)rundata, (String)"PASSWORDFORM_FAILED_MSG"));
                }
            } else if (e instanceof AccountExpiredException) {
                logger.info("JLoginUser: Account Expired for user " + username);
            } else if (e instanceof CredentialExpiredException) {
                logger.info("JLoginUser: Credentials expired for user: " + username);
                data.setScreenTemplate(JetspeedResources.getString("template.change.password", "ChangePassword"));
                data.setMessage(Localization.getString((RunData)rundata, (String)"PASSWORDFORM_EXPIRED_MSG"));
                data.getParameters().setString("username", username);
            }
            return;
        }
        catch (Throwable other) {
            data.setScreenTemplate(JetspeedResources.getString("template.error"));
            message = other.getMessage() != null ? other.getMessage() : other.toString();
            data.setMessage(message);
            data.setStackTrace(StringUtils.stackTrace((Throwable)other), other);
            FakeJetspeedUser juser = new FakeJetspeedUser(JetspeedSecurity.getAnonymousUserName(), false);
            data.setUser(juser);
            return;
        }
        if (user.getDisabled()) {
            data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_ACCOUNT_DISABLED"));
            data.setScreenTemplate(JetspeedResources.getString("logon.disabled.form"));
            data.getUser().setHasLoggedIn(new Boolean(false));
            return;
        }
        if (data.getUser().hasLoggedIn()) {
            boolean userRequestsRememberMe;
            String confirmed;
            if (JetspeedSecurity.isDisableAccountCheckEnabled()) {
                JetspeedSecurity.resetDisableAccountCheck(data.getParameters().getString("username", ""));
            }
            if ((confirmed = data.getUser().getConfirmed()) == null || !confirmed.equals("CONFIRMED")) {
                if (confirmed != null && confirmed.equals("REJECTED")) {
                    data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                    data.setScreenTemplate("NewUserRejected");
                    data.getUser().setHasLoggedIn(new Boolean(false));
                    return;
                }
                data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_CONFIRMFIRST"));
                data.setScreenTemplate("ConfirmRegistration");
                data.getUser().setHasLoggedIn(new Boolean(false));
                return;
            }
            boolean automaticLogonEnabled = JetspeedResources.getBoolean("automatic.logon.enable", false);
            if (automaticLogonEnabled && (userRequestsRememberMe = data.getParameters().getBoolean("rememberme", false))) {
                int maxage = JetspeedResources.getInt("automatic.logon.cookie.maxage", -1);
                String comment = JetspeedResources.getString("automatic.logon.cookie.comment", "");
                String domain = JetspeedResources.getString("automatic.logon.cookie.domain");
                String path = JetspeedResources.getString("automatic.logon.cookie.path", "/");
                if (domain == null) {
                    String server = data.getServerName();
                    domain = "." + server;
                }
                String loginCookieValue = null;
                if (JetspeedResources.getString("automatic.logon.cookie.generation", "everylogon").equals("everylogon")) {
                    loginCookieValue = "" + Math.random();
                    data.getUser().setPerm("logincookie", (Object)loginCookieValue);
                    JetspeedSecurity.saveUser(data.getJetspeedUser());
                } else {
                    loginCookieValue = (String)data.getUser().getPerm("logincookie");
                    if (loginCookieValue == null || loginCookieValue.length() == 0) {
                        loginCookieValue = "" + Math.random();
                        data.getUser().setPerm("logincookie", (Object)loginCookieValue);
                        JetspeedSecurity.saveUser(data.getJetspeedUser());
                    }
                }
                Cookie userName = new Cookie("username", data.getUser().getUserName());
                Cookie loginCookie = new Cookie("logincookie", loginCookieValue);
                userName.setMaxAge(maxage);
                userName.setComment(comment);
                userName.setDomain(domain);
                userName.setPath(path);
                loginCookie.setMaxAge(maxage);
                loginCookie.setComment(comment);
                loginCookie.setDomain(domain);
                loginCookie.setPath(path);
                data.getResponse().addCookie(userName);
                data.getResponse().addCookie(loginCookie);
            }
        } else {
            this.disableCheck(data);
        }
    }

    private boolean disableCheck(JetspeedRunData data) {
        boolean disabled = false;
        if (JetspeedSecurity.isDisableAccountCheckEnabled() && (disabled = JetspeedSecurity.checkDisableAccount(data.getParameters().getString("username", "")))) {
            data.setMessage(Localization.getString((RunData)data, (String)"JLOGINUSER_ACCOUNT_DISABLED"));
            data.setScreenTemplate(JetspeedResources.getString("logon.disabled.form"));
            data.getUser().setHasLoggedIn(new Boolean(false));
        }
        return disabled;
    }
}

