/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.daemon.impl.util.feeddaemon;

import java.io.IOException;
import org.apache.jetspeed.cache.disk.DiskCacheUtils;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.Registry;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.urlmanager.URLFetcher;
import org.apache.jetspeed.services.urlmanager.URLManager;

public class Instantiator
implements Runnable {
    public static final int MAX_WARN_SECONDS = 3;
    public static final int LOG_INTERVAL = 100;
    private PortletEntry entry = null;
    private int id = 0;
    private boolean forcePortet = false;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(Instantiator.class.getName());

    public Instantiator(PortletEntry entry) {
        this.entry = entry;
    }

    public Instantiator(int id, PortletEntry entry) {
        this(entry);
        this.id = id;
    }

    public void getURL(String url) throws IOException {
        if (JetspeedResources.getBoolean("contentfeeds.fetchall") && !DiskCacheUtils.isCached(url)) {
            long download_begin = System.currentTimeMillis();
            try {
                JetspeedDiskCache.getInstance().getEntry(url, URLFetcher.fetch(url, true));
                long total = (System.currentTimeMillis() - download_begin) / 1000L;
                if (total >= 3L) {
                    logger.warn(this.getClass().getName() + "  The following URL took too long (" + total + " second(s)) to download: " + url);
                }
            }
            catch (IOException e) {
                logger.error("The following URL couldn't be downloaded " + url + " and took " + (System.currentTimeMillis() - download_begin) / 1000L + " seconds to download. ");
                throw new IOException(e.getMessage());
            }
        }
    }

    public void run() {
        try {
            if (this.entry == null) {
                logger.error("Instantiator: Null Entry");
                return;
            }
            if (this.entry.getURL() == null) {
                logger.error("Instantiator: Null URL");
                return;
            }
            this.getURL(this.entry.getURL());
        }
        catch (IOException e) {
            return;
        }
        catch (Throwable t) {
            logger.error("Instantiator: Throwable", t);
        }
        Registry registry = org.apache.jetspeed.services.Registry.get(org.apache.jetspeed.services.Registry.PORTLET);
        try {
            if (!registry.hasEntry(this.entry.getName())) {
                registry.addEntry(this.entry);
                if (JetspeedResources.getBoolean("autocreate.portlets")) {
                    PortletFactory.getPortlet(this.entry.getName(), "0");
                }
            }
        }
        catch (Exception e) {
            logger.error("InstantiatorThread: Couldn't create Portlet: ", e);
            URLManager.register(this.entry.getURL(), 14, e.toString());
            registry.removeEntry(this.entry.getName());
        }
        if (this.id != 0 && this.id % 100 == 0) {
            logger.info("Instantiator:  instanted " + this.id + " portlet(s)");
        }
    }
}

