/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.capability;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.om.registry.ClientEntry;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.om.registry.MediaTypeRegistry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.util.MimeType;

public class BaseCapabilityMap
implements CapabilityMap {
    private String useragent;
    private ClientEntry entry;

    protected BaseCapabilityMap(String agent, ClientEntry entry) {
        this.useragent = agent;
        this.entry = entry;
    }

    public MimeType getPreferredType() {
        return this.entry.getMimetypeMap().getPreferredMimetype();
    }

    public String getPreferredMediaType() {
        Iterator i = this.listMediaTypes();
        if (i.hasNext()) {
            return (String)i.next();
        }
        return null;
    }

    public Iterator listMediaTypes() {
        Vector<String> results = new Vector<String>();
        Vector types = new Vector();
        Enumeration en = ((MediaTypeRegistry)Registry.get(Registry.MEDIA_TYPE)).getEntries();
        while (en.hasMoreElements()) {
            types.add(en.nextElement());
        }
        Iterator mimes = this.entry.getMimetypeMap().getMimetypes();
        while (mimes.hasNext()) {
            String mime = ((MimeType)mimes.next()).getContentType();
            for (MediaTypeEntry mte : types) {
                if (!mime.equals(mte.getMimeType()) || !this.entry.getCapabilityMap().containsAll(mte.getCapabilityMap())) continue;
                results.add(mte.getName());
            }
        }
        return results.iterator();
    }

    public String getAgent() {
        return this.useragent;
    }

    public boolean hasCapability(int cap) {
        return false;
    }

    public boolean hasCapability(String capability) {
        Iterator i = this.entry.getCapabilityMap().getCapabilities();
        while (i.hasNext()) {
            String cap = (String)i.next();
            if (!cap.equals(capability)) continue;
            return true;
        }
        return false;
    }

    public MimeType[] getMimeTypes() {
        Vector<MimeType> v = new Vector<MimeType>();
        Iterator i = this.entry.getMimetypeMap().getMimetypes();
        while (i.hasNext()) {
            MimeType mime = (MimeType)i.next();
            v.add(mime);
        }
        return (MimeType[])v.toArray();
    }

    public boolean supportsMimeType(MimeType mimeType) {
        Iterator i = this.entry.getMimetypeMap().getMimetypes();
        while (i.hasNext()) {
            MimeType mime = (MimeType)i.next();
            if (!mime.equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsMediaType(String media) {
        if (media == null) {
            return true;
        }
        MediaTypeEntry mte = (MediaTypeEntry)Registry.getEntry(Registry.MEDIA_TYPE, media);
        if (!this.supportsMimeType(new MimeType(mte.getMimeType()))) {
            return false;
        }
        return this.entry.getCapabilityMap().containsAll(mte.getCapabilityMap());
    }

    public String toString() {
        StringBuffer desc = new StringBuffer(this.entry.getName());
        Iterator i = this.entry.getMimetypeMap().getMimetypes();
        while (i.hasNext()) {
            MimeType mime = (MimeType)i.next();
            desc.append(mime).append("-");
        }
        i = this.entry.getCapabilityMap().getCapabilities();
        while (i.hasNext()) {
            String capa = (String)i.next();
            desc.append(capa).append("/");
        }
        return desc.toString();
    }
}

