/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.disk;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.jetspeed.cache.disk.DiskCache;
import org.apache.jetspeed.cache.disk.DiskCacheEntry;
import org.apache.jetspeed.cache.disk.DiskCacheUtils;
import org.apache.jetspeed.cache.disk.JetspeedDiskCacheEntry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.threadpool.ThreadPool;
import org.apache.jetspeed.services.urlmanager.URLFetcher;
import org.apache.jetspeed.services.urlmanager.URLFetcherDownloader;
import org.apache.jetspeed.services.urlmanager.URLManager;
import org.apache.jetspeed.util.URIEncoder;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.servlet.TurbineServlet;

public class JetspeedDiskCache
implements DiskCache {
    public static String DEFAULT_CACHE_DIRECTORY = JetspeedResources.getString("cache.directory", "WEB-INF/cache");
    private static Hashtable instances = new Hashtable();
    private String directory;
    private Hashtable entries = new Hashtable();
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedDiskCache.class.getName());

    private JetspeedDiskCache(String directory) {
        this.directory = directory;
        if (DEFAULT_CACHE_DIRECTORY.equals("use-servlet-temp")) {
            String tempdir = new String("WEB-INF/cache");
            try {
                ServletContext sc = TurbineServlet.getServletContext();
                tempdir = sc.getAttribute("javax.servlet.context.tempdir").toString() + "/jetspeed/cache";
                if (logger.isDebugEnabled()) {
                    logger.debug("DISK CACHE: will create cache in servlet temp directory " + tempdir);
                }
            }
            catch (Exception e) {
                logger.error("DISK CACHE: problems creating cache in servlet temp directory  falling back to WEB-INF/cache : " + e);
            }
            this.directory = tempdir;
        } else if (logger.isDebugEnabled()) {
            logger.debug("DISK CACHE: will use cache in user configured directory " + directory);
        }
    }

    private void initEntries() {
        logger.info("Disk Cache init Entries...");
        try {
            TurbineServices.getInstance().getService("URLManager").init();
        }
        catch (Throwable t) {
            logger.error("initEntries: Unable to start URLManagerService", t);
        }
        File temp = new File(this.directory);
        String[] files = temp.list();
        if (files == null) {
            logger.error("DiskCache.initEntries: Error!!! - The cache directory cannot be found: " + this.directory);
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].indexOf("http_") != 0) continue;
            logger.info("Initializing cache entry: " + files[i]);
            JetspeedDiskCacheEntry ent = new JetspeedDiskCacheEntry(new File(this.getRoot(), files[i]));
            logger.info("Adding cache entry for " + ent.getSourceURL());
            String interned = ent.getSourceURL().intern();
            this.entries.put(interned, ent);
            URLManager.register(interned, URLManager.STATUS_OK, "Recovered from cache");
        }
        logger.info("Disk Cache init Entries DONE.");
    }

    public DiskCacheEntry[] getEntries() {
        Vector diskEntries = new Vector();
        Enumeration cacheEntries = this.entries.elements();
        logger.info("Calling JetspeedDiskCache getEntries");
        while (cacheEntries.hasMoreElements()) {
            diskEntries.addElement(cacheEntries.nextElement());
        }
        Object[] found = new DiskCacheEntry[diskEntries.size()];
        diskEntries.copyInto(found);
        return found;
    }

    public String getRoot() {
        new File(this.directory).mkdirs();
        return this.directory;
    }

    public DiskCacheEntry getEntry(String url) throws IOException {
        return this.getEntry(url, false);
    }

    public DiskCacheEntry getEntry(String url, boolean force) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("You must specify a URL to obtain an entry from the cache");
        }
        String interned = url.intern();
        JetspeedDiskCacheEntry entry = (JetspeedDiskCacheEntry)this.entries.get(interned);
        if (entry != null) {
            if (force) {
                logger.info("Refreshing local URL!!!" + interned);
                URLFetcher.refresh(interned);
            }
            return entry;
        }
        logger.warn("Cache getEntry Called with " + url);
        if (DiskCacheUtils.isLocal(url)) {
            String local = DiskCacheUtils.getLocalURL(url).intern();
            JetspeedDiskCacheEntry dce = (JetspeedDiskCacheEntry)this.entries.get(local);
            if (dce == null) {
                logger.info("Adding Local to cache list: " + local);
                dce = new JetspeedDiskCacheEntry(local);
                this.entries.put(local, dce);
                URLManager.register(local, URLManager.STATUS_OK, "Local added");
            }
            logger.info("Returning local cached URL");
            return dce;
        }
        if (DiskCacheUtils.isCacheable(url)) {
            if (!DiskCacheUtils.isCached(this, url) || force) {
                this.add(url, true);
            }
            return this.getEntry(url, force);
        }
        logger.info("DiskCache: this URL can't be stored in cache... providing it directly." + url);
        return new JetspeedDiskCacheEntry(url);
    }

    public DiskCacheEntry getEntry(String url, Reader is) throws IOException {
        String uri = URIEncoder.encode(url);
        String oldfilename = this.getRoot() + "/old." + uri;
        String filename = DiskCacheUtils.getFile(this, url).getAbsolutePath();
        String newfilename = this.getRoot() + "/new." + uri;
        File file = new File(DiskCacheUtils.getFile(this, url).getAbsolutePath());
        File newfile = new File(newfilename);
        OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(newfile), "utf-8");
        char[] chars = new char[200];
        int readCount = 0;
        while ((readCount = is.read(chars)) > 0) {
            os.write(chars, 0, readCount);
        }
        is.close();
        os.close();
        File oldfile = new File(oldfilename);
        if (oldfile.exists()) {
            oldfile.delete();
        }
        if (newfile.exists() && newfile.length() > 0L) {
            file = new File(filename);
            file.renameTo(oldfile);
            newfile.renameTo(file);
        }
        try {
            if (oldfile.exists()) {
                oldfile.delete();
            }
        }
        catch (Exception e) {
            logger.info("Exception " + e.getMessage() + " while deleting " + oldfilename, e);
        }
        JetspeedDiskCacheEntry dce = (JetspeedDiskCacheEntry)this.entries.get(url.intern());
        if (dce != null) {
            dce.setFile(file);
            return dce;
        }
        return this.getEntry(url, false);
    }

    public void remove(String url) throws IOException {
        String newfilename;
        String oldfilename;
        File file;
        String uri = URIEncoder.encode(url);
        if (DiskCacheUtils.isCached(this, url)) {
            this.entries.remove(url.intern());
            URLManager.unregister(url.intern());
            File file2 = DiskCacheUtils.getFile(this, url);
            if (file2.exists()) {
                file2.delete();
            }
        }
        if ((file = new File(oldfilename = this.getRoot() + "/old." + uri)).exists()) {
            file.delete();
        }
        if ((file = new File(newfilename = this.getRoot() + "/new." + uri)).exists()) {
            file.delete();
        }
    }

    public void add(String url) throws IOException {
        this.add(url, false);
    }

    public void add(String url, boolean force) throws IOException {
        String interned = url.intern();
        this.fetch(url, DiskCacheUtils.getFile(this, url).getAbsolutePath(), force);
        if (this.entries.get(interned) != null) {
            return;
        }
        this.entries.put(interned, new JetspeedDiskCacheEntry(interned));
        URLManager.register(interned, URLManager.STATUS_OK, "Added by Program");
    }

    public String fetch(String url, String cache) throws IOException {
        return this.fetch(url, cache, false);
    }

    public String fetch(String url, String cache, boolean force) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("cache cannot be null");
        }
        try {
            Reader is = URLFetcher.fetch(url, force);
            OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(cache), "utf-8");
            char[] chars = new char[200];
            int readCount = 0;
            while ((readCount = is.read(chars)) > 0) {
                os.write(chars, 0, readCount);
            }
            is.close();
            os.close();
        }
        catch (MalformedURLException e) {
            logger.error("Error in URL", e);
        }
        return cache;
    }

    public void refresh(String url) {
        ThreadPool.process(new URLFetcherDownloader(url));
    }

    public static JetspeedDiskCache getInstance() {
        return JetspeedDiskCache.getInstance(DEFAULT_CACHE_DIRECTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JetspeedDiskCache getInstance(String directory) {
        Hashtable hashtable = instances;
        synchronized (hashtable) {
            JetspeedDiskCache cache = (JetspeedDiskCache)instances.get(directory);
            if (cache == null) {
                cache = new JetspeedDiskCache(directory);
                instances.put(directory, cache);
                logger.info("DISK CACHE: Initing cache for " + directory);
                cache.initEntries();
                logger.info("DISK CACHE: Inited cache:" + directory);
            }
            return cache;
        }
    }

    public boolean isCached(String url) {
        return this.entries.containsKey(url.intern());
    }
}

