/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.cache.FileCacheEntry;
import org.apache.jetspeed.cache.FileCacheEventListener;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class FileCache
implements Comparator {
    protected long scanRate = 300L;
    protected int maxSize = 100;
    protected List listeners = new LinkedList();
    private FileCacheScanner scanner = null;
    private Map cache = null;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(FileCache.class.getName());

    public FileCache() {
        this.cache = new HashMap();
        this.scanner = new FileCacheScanner();
        this.scanner.setDaemon(true);
    }

    public FileCache(long scanRate, int maxSize) {
        this.cache = new HashMap();
        this.scanRate = scanRate;
        this.maxSize = maxSize;
        this.scanner = new FileCacheScanner();
        this.scanner.setDaemon(true);
    }

    public FileCache(int initialCapacity, int loadFactor, long scanRate, int maxSize) {
        this.cache = new HashMap(initialCapacity, loadFactor);
        this.scanRate = scanRate;
        this.maxSize = maxSize;
        this.scanner = new FileCacheScanner();
        this.scanner.setDaemon(true);
    }

    public void setScanRate(long scanRate) {
        this.scanRate = scanRate;
    }

    public long getScanRate() {
        return this.scanRate;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public FileCacheEntry get(String key) {
        return (FileCacheEntry)this.cache.get(key);
    }

    public Object getDocument(String key) {
        FileCacheEntry entry = (FileCacheEntry)this.cache.get(key);
        if (entry != null) {
            return entry.getDocument();
        }
        return null;
    }

    public void put(File file, Object document) throws IOException {
        FileCacheEntry entry = new FileCacheEntry(file, document);
        this.cache.put(file.getCanonicalPath(), entry);
    }

    public void put(String key, Object document) throws IOException {
        File file = new File(key);
        FileCacheEntry entry = new FileCacheEntry(file, document);
        this.cache.put(file.getCanonicalPath(), entry);
    }

    public Object remove(String key) {
        return this.cache.remove(key);
    }

    public void addListener(FileCacheEventListener listener) {
        this.listeners.add(listener);
    }

    public void startFileScanner() {
        try {
            this.scanner.start();
        }
        catch (IllegalThreadStateException e) {
            logger.error("Exception starting scanner", e);
        }
    }

    public void stopFileScanner() {
        this.scanner.setStopping(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evict() {
        Map map = this.cache;
        synchronized (map) {
            if (this.getMaxSize() >= this.cache.size()) {
                return;
            }
            LinkedList list = new LinkedList(this.cache.values());
            Collections.sort(list, this);
            int limit = this.cache.size() - this.getMaxSize();
            Iterator it = list.iterator();
            for (int count = 0; it.hasNext() && count < limit; ++count) {
                FileCacheEntry entry = (FileCacheEntry)it.next();
                String key = null;
                try {
                    key = entry.getFile().getCanonicalPath();
                }
                catch (IOException e) {
                    logger.error("Exception getting file path: ", e);
                }
                for (FileCacheEventListener listener : this.listeners) {
                    listener.evict(entry);
                }
                this.cache.remove(key);
            }
        }
    }

    public int compare(Object o1, Object o2) {
        FileCacheEntry e1 = (FileCacheEntry)o1;
        FileCacheEntry e2 = (FileCacheEntry)o2;
        if (e1.getLastAccessed() < e2.getLastAccessed()) {
            return -1;
        }
        if (e1.getLastAccessed() == e2.getLastAccessed()) {
            return 0;
        }
        return 1;
    }

    public Iterator getIterator() {
        return this.cache.values().iterator();
    }

    public int getSize() {
        return this.cache.size();
    }

    protected class FileCacheScanner
    extends Thread {
        private boolean stopping = false;

        protected FileCacheScanner() {
        }

        public void setStopping(boolean flag) {
            this.stopping = flag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean done = false;
            try {
                while (!done) {
                    try {
                        int count = 0;
                        FileCache fileCache = FileCache.this;
                        synchronized (fileCache) {
                            for (FileCacheEntry entry : FileCache.this.cache.values()) {
                                Date modified = new Date(entry.getFile().lastModified());
                                if (modified.after(entry.getLastModified())) {
                                    for (FileCacheEventListener listener : FileCache.this.listeners) {
                                        listener.refresh(entry);
                                        entry.setLastModified(modified);
                                    }
                                }
                                ++count;
                            }
                        }
                        if (count > FileCache.this.getMaxSize()) {
                            FileCache.this.evict();
                        }
                    }
                    catch (Exception e) {
                        logger.error("FileCache Scanner: Error in iteration...", e);
                    }
                    FileCacheScanner.sleep(FileCache.this.getScanRate() * 1000L);
                    if (!this.stopping) continue;
                    this.stopping = false;
                    done = true;
                }
            }
            catch (InterruptedException e) {
                logger.error("FileCacheScanner: recieved interruption, exiting.", e);
            }
        }
    }
}

