/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.util;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPosition;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALMyGroups;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALCommonUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.modules.actions.controls.Restore;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.portal.security.portlets.PortletWrapper;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.util.MimeType;
import org.apache.jetspeed.util.template.BaseJetspeedLink;
import org.apache.jetspeed.util.template.ContentTemplateLink;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class ALEipUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALEipUtils.class.getName());

    public static void setTemp(RunData rundata, Context context, String key, String value) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        if (portlet == null) {
            String js_peid = rundata.getParameters().getString("js_peid");
            jdata.getUser().setTemp(new StringBuffer().append(js_peid).append(key).toString(), (Object)value);
        } else {
            jdata.getUser().setTemp(new StringBuffer().append(portlet.getID()).append(key).toString(), (Object)value);
        }
    }

    public static void removeTemp(RunData rundata, Context context, String key) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        if (portlet == null) {
            String js_peid = rundata.getParameters().getString("js_peid");
            jdata.getUser().removeTemp(new StringBuffer().append(js_peid).append(key).toString());
        } else {
            jdata.getUser().removeTemp(new StringBuffer().append(portlet.getID()).append(key).toString());
        }
    }

    public static void removeTemp(RunData rundata, Context context, List list) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        int size = list.size();
        if (portlet == null) {
            String js_peid = rundata.getParameters().getString("js_peid");
            for (int i = 0; i < size; ++i) {
                jdata.getUser().removeTemp(new StringBuffer().append(js_peid).append(list.get(i).toString()).toString());
            }
        } else {
            String peid = portlet.getID();
            for (int i = 0; i < size; ++i) {
                jdata.getUser().removeTemp(new StringBuffer().append(peid).append(list.get(i).toString()).toString());
            }
        }
    }

    public static String getTemp(RunData rundata, Context context, String key) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        Object obj = null;
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        if (portlet == null) {
            String js_peid = rundata.getParameters().getString("js_peid");
            obj = jdata.getUser().getTemp(new StringBuffer().append(js_peid).append(key).toString());
        } else {
            obj = jdata.getUser().getTemp(new StringBuffer().append(portlet.getID()).append(key).toString());
        }
        return obj == null ? null : obj.toString();
    }

    public static int getEntityId(RunData rundata, Context context) {
        int entity_id = 0;
        String entity_id_str = ALEipUtils.getTemp(rundata, context, "entityid");
        try {
            entity_id = Integer.parseInt(entity_id_str);
        }
        catch (Exception e) {
            entity_id = 0;
        }
        return entity_id;
    }

    public static int getUserId(RunData rundata) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        String id = jdata.getJetspeedUser().getUserId();
        return Integer.parseInt(id);
    }

    public static VelocityPortlet getPortlet(RunData rundata, Context context) {
        return (VelocityPortlet)context.get("portlet");
    }

    public static Portlet getPortlet(RunData rundata, String portletId) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletId)) continue;
                    PortletWrapper wrapper = (PortletWrapper)PortletFactory.getPortlet(entries[j]);
                    if (wrapper != null) {
                        return wrapper.getPortlet();
                    }
                    return null;
                }
            }
        }
        catch (Exception ex) {
            logger.error("Exception", ex);
            return null;
        }
        return null;
    }

    public static boolean isMatch(RunData rundata, Context context) {
        VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);
        if (portlet == null) {
            return true;
        }
        String peid1 = portlet.getID();
        String peid2 = rundata.getParameters().getString("js_peid");
        if (peid1 == null || peid2 == null) {
            return false;
        }
        return peid1.equals(peid2);
    }

    public static List getUsers(String groupname) {
        ArrayList<ALEipUser> list = new ArrayList<ALEipUser>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION ");
        statement.append("FROM TURBINE_USER_GROUP_ROLE as A ");
        statement.append("LEFT JOIN TURBINE_USER as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN TURBINE_GROUP as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN EIP_M_USER_POSITION as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
        statement.append(" AND C.GROUP_NAME = '").append(groupname).append("' ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SQLTemplate rawSelect = new SQLTemplate(TurbineUser.class, query, true);
        rawSelect.setFetchingDataRows(true);
        List ulist = dataContext.performQuery((Query)rawSelect);
        int recNum = ulist.size();
        for (int j = 0; j < recNum; ++j) {
            DataRow dataRow = (DataRow)ulist.get(j);
            ALEipUser user = new ALEipUser();
            user.initField();
            user.setUserId((Integer)ALEipUtils.getObjFromDataRow(dataRow, "USER_ID"));
            user.setName((String)ALEipUtils.getObjFromDataRow(dataRow, "LOGIN_NAME"));
            user.setAliasName((String)ALEipUtils.getObjFromDataRow(dataRow, "FIRST_NAME"), (String)ALEipUtils.getObjFromDataRow(dataRow, "LAST_NAME"));
            list.add(user);
        }
        return list;
    }

    public static List getUserIds(String groupname) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, D.POSITION ");
        statement.append("FROM TURBINE_USER_GROUP_ROLE as A ");
        statement.append("LEFT JOIN TURBINE_USER as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN TURBINE_GROUP as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN EIP_M_USER_POSITION as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
        statement.append(" AND C.GROUP_NAME = '").append(groupname).append("' ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SQLTemplate rawSelect = new SQLTemplate(TurbineUser.class, query, true);
            rawSelect.setFetchingDataRows(true);
            List ulist = dataContext.performQuery((Query)rawSelect);
            int recNum = ulist.size();
            for (int j = 0; j < recNum; ++j) {
                DataRow dataRow = (DataRow)ulist.get(j);
                list.add((Integer)ALEipUtils.getObjFromDataRow(dataRow, "USER_ID"));
            }
        }
        catch (Exception ex) {
            logger.error("[ALEipUtils]", ex);
        }
        return list;
    }

    public static List getUsersFromPost(int postid) {
        ArrayList<ALEipUser> list = new ArrayList<ALEipUser>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION ");
        statement.append("FROM TURBINE_USER_GROUP_ROLE as A ");
        statement.append("LEFT JOIN TURBINE_USER as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN TURBINE_GROUP as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN EIP_M_USER_POSITION as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
        statement.append(" AND B.POST_ID = '").append(postid).append("' ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SQLTemplate rawSelect = new SQLTemplate(TurbineUser.class, query, true);
        rawSelect.setFetchingDataRows(true);
        List ulist = dataContext.performQuery((Query)rawSelect);
        int recNum = ulist.size();
        for (int j = 0; j < recNum; ++j) {
            DataRow dataRow = (DataRow)ulist.get(j);
            ALEipUser user = new ALEipUser();
            user.initField();
            user.setUserId((Integer)ALEipUtils.getObjFromDataRow(dataRow, "USER_ID"));
            user.setName((String)ALEipUtils.getObjFromDataRow(dataRow, "LOGIN_NAME"));
            user.setAliasName((String)ALEipUtils.getObjFromDataRow(dataRow, "FIRST_NAME"), (String)ALEipUtils.getObjFromDataRow(dataRow, "LAST_NAME"));
            list.add(user);
        }
        return list;
    }

    public static List getUsersFromSelectQuery(SelectQuery query) {
        ArrayList<ALEipUser> list = new ArrayList<ALEipUser>();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            query.addOrdering("eipMUserPosition.position", true);
            List ulist = dataContext.performQuery((Query)query);
            int size = ulist.size();
            for (int i = 0; i < size; ++i) {
                TurbineUser record = (TurbineUser)ulist.get(i);
                ALEipUser user = new ALEipUser();
                user.initField();
                user.setUserId(record.getUserId());
                user.setName(record.getLoginName());
                user.setAliasName(record.getFirstName(), record.getLastName());
                list.add(user);
            }
        }
        catch (Exception ex) {
            logger.error("[ALEipUtils]", ex);
        }
        return list;
    }

    public static ALEipUser getALEipUser(RunData rundata) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        ALEipUser user = new ALEipUser();
        user.initField();
        user.setUserId(Integer.parseInt(jdata.getJetspeedUser().getUserId()));
        user.setName(jdata.getJetspeedUser().getUserName());
        user.setAliasName(jdata.getJetspeedUser().getFirstName(), jdata.getJetspeedUser().getLastName());
        return user;
    }

    public static ALEipUser getALEipUser(int id) throws ALDBErrorException {
        Expression exp;
        SelectQuery query;
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        List users = dataContext.performQuery((Query)(query = new SelectQuery(TurbineUser.class, exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)id))));
        if (users.size() == 0) {
            return null;
        }
        TurbineUser tuser = (TurbineUser)users.get(0);
        ALEipUser user = new ALEipUser();
        user.initField();
        user.setUserId(tuser.getUserId());
        user.setName(tuser.getLoginName());
        user.setAliasName(tuser.getFirstName(), tuser.getLastName());
        return user;
    }

    public static ALEipUser getALEipUser(String loginname) throws ALDBErrorException {
        Expression exp;
        SelectQuery query;
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        List users = dataContext.performQuery((Query)(query = new SelectQuery(TurbineUser.class, exp = ExpressionFactory.matchExp((String)"loginName", (Object)loginname))));
        if (users.size() == 0) {
            return null;
        }
        TurbineUser tuser = (TurbineUser)users.get(0);
        ALEipUser user = new ALEipUser();
        user.initField();
        user.setUserId(tuser.getUserId());
        user.setName(tuser.getLoginName());
        user.setAliasName(tuser.getFirstName(), tuser.getLastName());
        return user;
    }

    public static ALBaseUser getBaseUser(int userid) {
        String uid = String.valueOf(userid);
        try {
            if (uid == null) {
                logger.debug("Empty ID...");
                return null;
            }
            return (ALBaseUser)JetspeedSecurity.getUser(new UserIdPrincipal(uid));
        }
        catch (Exception ex) {
            logger.error("Exception", ex);
            return null;
        }
    }

    public static String getUserFullName(int userid) {
        String userName = "";
        ALBaseUser user = ALEipUtils.getBaseUser(userid);
        if (user != null) {
            userName = new StringBuffer().append(user.getLastName()).append(" ").append(user.getFirstName()).toString();
        }
        return userName;
    }

    public static boolean changePost(RunData rundata, String username, int postid) throws ALDBErrorException {
        try {
            ALBaseUser user = (ALBaseUser)JetspeedSecurity.getUser(username);
            JetspeedSecurity.joinGroup(username, ((ALEipPost)ALEipManager.getInstance().getPostMap().get(postid)).getGroupName().getValue());
            user.setPostId(postid);
            JetspeedSecurity.saveUser(user);
            ALBaseUser currentUser = (ALBaseUser)rundata.getUser();
            if (currentUser.getUserName().equals(user.getUserName())) {
                currentUser.setPostId(user.getPostId());
            }
        }
        catch (JetspeedSecurityException ex) {
            logger.error("[ALEipUtils]", (Throwable)((Object)ex));
            throw new ALDBErrorException();
        }
        return true;
    }

    public static void reloadMygroup(RunData rundata) throws ALDBErrorException {
        ArrayList<ALEipGroup> ulist = new ArrayList<ALEipGroup>();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId(rundata));
            SelectQuery query = new SelectQuery(TurbineGroup.class, exp);
            List list = dataContext.performQuery((Query)query);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                TurbineGroup record = (TurbineGroup)list.get(i);
                ALEipGroup group = new ALEipGroup();
                group.initField();
                group.setName(record.getGroupName());
                group.setAliasName(record.getGroupAliasName());
                ulist.add(group);
            }
        }
        catch (Exception ex) {
            logger.error("[ALEipUtils]", ex);
            throw new ALDBErrorException();
        }
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        ALMyGroups mygroups = new ALMyGroups();
        mygroups.addList(ulist);
        jdata.getUser().setTemp("mygroup", (Object)mygroups);
    }

    public static List getMyGroups(RunData rundata) throws ALDBErrorException {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        Object obj = jdata.getUser().getTemp("mygroup");
        if (obj == null || !(obj instanceof ALMyGroups)) {
            ALEipUtils.reloadMygroup(rundata);
            obj = jdata.getUser().getTemp("mygroup");
        }
        ALMyGroups mygroups = (ALMyGroups)obj;
        return mygroups.getList();
    }

    public static String getCompanyName(int id) {
        String companyName = null;
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMCompany.class);
            query.addCustomDbAttribute("COMPANY_NAME");
            Expression exp = ExpressionFactory.matchDbExp((String)"COMPANY_ID", (Object)id);
            query.setQualifier(exp);
            List list = dataContext.performQuery((Query)query);
            if (list == null || list.size() == 0) {
                logger.debug("[ALEipUtils] Not found ComapnyID...");
                return null;
            }
            DataRow dataRow = (DataRow)list.get(0);
            companyName = (String)ALEipUtils.getObjFromDataRow(dataRow, "COMPANY_NAME");
        }
        catch (Exception ex) {
            logger.error("[ALEipUtils]", ex);
            companyName = null;
        }
        return companyName;
    }

    public static String getPostName(int id) {
        if (ALEipManager.getInstance().getPostMap().containsKey(id)) {
            return ((ALEipPost)ALEipManager.getInstance().getPostMap().get(id)).getPostName().getValue();
        }
        return null;
    }

    public static String getPositionName(int id) {
        if (ALEipManager.getInstance().getPositionMap().containsKey(id)) {
            return ((ALEipPosition)ALEipManager.getInstance().getPositionMap().get(id)).getPositionName().getValue();
        }
        return null;
    }

    public static boolean redirectPageNotFound(RunData rundata) {
        try {
            JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
            DynamicURI duri = jsLink.getPage();
            duri.addPathInfo("template", "PageNotFound");
            rundata.setRedirectURI(duri.toString());
            rundata.getResponse().sendRedirect(rundata.getRedirectURI());
            JetspeedLinkFactory.putInstance(jsLink);
            jsLink = null;
            return true;
        }
        catch (TurbineException e) {
            logger.error("Exception", e);
            return false;
        }
        catch (IOException e) {
            logger.error("Exception", e);
            return false;
        }
    }

    public static boolean redirectDBError(RunData rundata) {
        try {
            JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
            DynamicURI duri = jsLink.getPage();
            String template = rundata.getParameters().getString("template");
            if (template != null && !"".equals(template) && template.endsWith("DetailScreen")) {
                VelocityContext context = new VelocityContext();
                ALEipUtils.setupContext(rundata, (Context)context);
                try {
                    ServletOutputStream out = null;
                    HttpServletResponse response = rundata.getResponse();
                    out = response.getOutputStream();
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, ALEipConstants.DEF_CONTENT_ENCODING));
                    Template templete = Velocity.getTemplate((String)"screens/html/AjaxDBError.vm");
                    templete.merge((Context)context, (Writer)writer);
                    writer.flush();
                    writer.close();
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
            duri.addPathInfo("template", "DBError");
            rundata.setRedirectURI(duri.toString());
            rundata.getResponse().sendRedirect(rundata.getRedirectURI());
            JetspeedLinkFactory.putInstance(jsLink);
            jsLink = null;
            return true;
        }
        catch (TurbineException e) {
            logger.error("Exception", e);
            return false;
        }
        catch (IOException e) {
            logger.error("Exception", e);
            return false;
        }
    }

    public static boolean redirectPermissionError(RunData rundata) {
        try {
            JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
            DynamicURI duri = jsLink.getPage();
            String template = rundata.getParameters().getString("template");
            if (template != null && !"".equals(template)) {
                if (template.endsWith("JSONScreen")) {
                    VelocityContext context = new VelocityContext();
                    ALEipUtils.setupContext(rundata, (Context)context);
                    try {
                        ServletOutputStream out = null;
                        HttpServletResponse response = rundata.getResponse();
                        out = response.getOutputStream();
                        ArrayList<String> list = new ArrayList<String>();
                        list.add("PermissionError");
                        list.add("\u30a2\u30af\u30bb\u30b9\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406\u8005\u306b\u304a\u554f\u3044\u5408\u308f\u305b\u304f\u3060\u3055\u3044\u3002");
                        JSONArray json = JSONArray.fromObject(list);
                        StringBuffer result = new StringBuffer().append("/* ").append(json.toString()).append(" */");
                        out.print(result.toString());
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
                if (template.endsWith("FormScreen") || template.endsWith("DetailScreen")) {
                    VelocityContext context = new VelocityContext();
                    ALEipUtils.setupContext(rundata, (Context)context);
                    try {
                        ServletOutputStream out = null;
                        HttpServletResponse response = rundata.getResponse();
                        out = response.getOutputStream();
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, ALEipConstants.DEF_CONTENT_ENCODING));
                        Template templete = Velocity.getTemplate((String)"screens/html/AjaxPermissionError.vm");
                        templete.merge((Context)context, (Writer)writer);
                        writer.flush();
                        writer.close();
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
                if (template.endsWith("Screen")) {
                    VelocityContext context = new VelocityContext();
                    ALEipUtils.setupContext(rundata, (Context)context);
                    try {
                        ServletOutputStream out = null;
                        HttpServletResponse response = rundata.getResponse();
                        out = response.getOutputStream();
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, ALEipConstants.DEF_CONTENT_ENCODING));
                        Template templete = Velocity.getTemplate((String)"portlets/html/PermissionError.vm");
                        templete.merge((Context)context, (Writer)writer);
                        writer.flush();
                        writer.close();
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
                if (template.equals("Customize") || template.equals("Home")) {
                    duri.addPathInfo("template", "PermissionError");
                    rundata.setRedirectURI(duri.toString());
                    rundata.getResponse().sendRedirect(rundata.getRedirectURI());
                    JetspeedLinkFactory.putInstance(jsLink);
                    jsLink = null;
                    return true;
                }
                if (ALEipUtils.isCellularPhone(rundata)) {
                    duri.addPathInfo("template", "CellPermissionError");
                    rundata.setRedirectURI(duri.toString());
                    rundata.getResponse().sendRedirect(rundata.getRedirectURI());
                    JetspeedLinkFactory.putInstance(jsLink);
                    jsLink = null;
                    Restore restore = new Restore();
                    try {
                        restore.doPerform(rundata);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return true;
                }
            }
            try {
                Restore restore = new Restore();
                restore.doPerform(rundata);
            }
            catch (Exception e) {
                // empty catch block
            }
            JetspeedRunData jdata = (JetspeedRunData)rundata;
            if (jdata.getMode() == 2) {
                duri.addPathInfo("template", "PermissionError");
                rundata.setRedirectURI(duri.toString());
                rundata.getResponse().sendRedirect(rundata.getRedirectURI());
                JetspeedLinkFactory.putInstance(jsLink);
                jsLink = null;
            } else {
                Context context = (Context)jdata.getTemplateInfo().getTemplateContext("VelocityPortletContext");
                context.put("template", (Object)"PermissionError");
            }
            return true;
        }
        catch (TurbineException e) {
            logger.error("Exception", e);
            return false;
        }
        catch (IOException e) {
            logger.error("Exception", e);
            return false;
        }
    }

    public static String getMessageList(String msgline) {
        StringBuffer sb = new StringBuffer();
        ALStringField field = null;
        if (msgline == null || msgline.equals("")) {
            return "";
        }
        if (msgline.indexOf("\r") < 0 && msgline.indexOf("\n") < 0 && msgline.indexOf("\r\n") < 0) {
            field = new ALStringField();
            field.setTrim(false);
            field.setValue(msgline);
            return ALCommonUtils.replaceToAutoCR(ALEipUtils.replaceStrToLink(field.toString()));
        }
        String token = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(msgline));
            while ((token = reader.readLine()) != null) {
                field = new ALStringField();
                field.setTrim(false);
                field.setValue(token);
                sb.append(ALCommonUtils.replaceToAutoCR(ALEipUtils.replaceStrToLink(ALEipUtils.replaseLeftSpace(field.toString())))).append("<br/>");
            }
            reader.close();
        }
        catch (IOException ioe) {
            try {
                reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return "";
        }
        int index = sb.lastIndexOf("<br/>");
        if (index == -1) {
            return sb.toString();
        }
        return sb.substring(0, index);
    }

    public static String replaseLeftSpace(String str) {
        if (str == null || str.length() <= 0) {
            return str;
        }
        int len = str.length();
        char[] val = str.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int st = 0; st < len; ++st) {
            if (val[st] == ' ') {
                sb.append("&nbsp;");
                continue;
            }
            sb.append(val[st]);
        }
        return sb.length() > 0 ? sb.toString() : str;
    }

    public static boolean isCellularPhone(RunData data) {
        MediaTypeEntry media;
        String mediatype;
        boolean isCellularPhone = false;
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap(data.getRequest().getHeader("User-Agent"));
        MimeType mime = cm.getPreferredType();
        if (mime != null && ("docomo_imode".equals(mediatype = (media = (MediaTypeEntry)Registry.getEntry(Registry.MEDIA_TYPE, cm.getPreferredMediaType())).getName()) || "docomo_foma".equals(mediatype) || "au".equals(mediatype) || "vodafone".equals(mediatype))) {
            isCellularPhone = true;
        }
        return isCellularPhone;
    }

    public static int compareToDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int date1Year = cal1.get(1);
        int date1Month = cal1.get(2) + 1;
        int date1Day = cal1.get(5);
        int date1Hour = cal1.get(10);
        int date1Minute = cal1.get(12);
        int date1Second = cal1.get(13);
        int date2Year = cal2.get(1);
        int date2Month = cal2.get(2) + 1;
        int date2Day = cal2.get(5);
        int date2Hour = cal2.get(10);
        int date2Minute = cal2.get(12);
        int date2Second = cal2.get(13);
        if (date1Year == date2Year && date1Month == date2Month && date1Day == date2Day && date1Hour == date2Hour && date1Minute == date2Minute && date1Second == date2Second) {
            return 0;
        }
        if (cal1.after(cal2)) {
            return 2;
        }
        return 1;
    }

    public static Object getObjFromDataRow(DataRow dataRow, String key) {
        String lowerKey = key.toLowerCase();
        if (dataRow.containsKey((Object)lowerKey)) {
            return dataRow.get((Object)lowerKey);
        }
        return dataRow.get((Object)key.toUpperCase());
    }

    public static EipMCompany getEipMCompany(String id) {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query = new SelectQuery(EipMCompany.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"COMPANY_ID", (Object)Integer.valueOf(id));
        query.setQualifier(exp);
        List list = dataContext.performQuery((Query)query);
        if (list == null || list.size() == 0) {
            logger.debug("Not found ID...");
            return null;
        }
        return (EipMCompany)list.get(0);
    }

    public static String getUrl(String ip, int port, String servername) {
        if (ip == null || ip.length() == 0 || port == -1) {
            return "";
        }
        String protocol = JetspeedResources.getString("access.url.protocol", "http");
        StringBuffer url = new StringBuffer();
        if (port == 80) {
            url.append(protocol).append("://").append(ip).append("/").append(servername).append("/");
        } else {
            url.append(protocol).append("://").append(ip).append(":").append(port).append("/").append(servername).append("/");
        }
        return url.toString();
    }

    public static void setupContext(RunData rundata, Context context) {
        if (!rundata.getParameters().containsKey((Object)"js_peid")) {
            return;
        }
        String js_peid = rundata.getParameters().getString("js_peid");
        Portlet portlet = ALEipUtils.getPortlet(rundata, js_peid);
        context.put("portlet", (Object)portlet);
        context.put("jslink", (Object)new BaseJetspeedLink(rundata));
        context.put("clink", (Object)new ContentTemplateLink(rundata));
    }

    public static String getParameter(RunData rundata, Context context, String key) {
        String name = null;
        String idParam = rundata.getParameters().getString(key);
        name = ALEipUtils.getTemp(rundata, context, key);
        if (idParam == null && name == null) {
            ALEipUtils.removeTemp(rundata, context, key);
            name = null;
        } else if (idParam != null) {
            ALEipUtils.setTemp(rundata, context, key, idParam);
            name = idParam;
        }
        return name;
    }

    public static List getObjectModels(DataContext dataContext, Class classname, String search_key, Integer search_value, boolean isDb) {
        SelectQuery query = new SelectQuery(classname);
        Expression exp = isDb ? ExpressionFactory.matchDbExp((String)search_key, (Object)search_value) : ExpressionFactory.matchExp((String)search_key, (Object)search_value);
        query.setQualifier(exp);
        List list = dataContext.performQuery((Query)query);
        if (list == null || list.size() <= 0) {
            return null;
        }
        return list;
    }

    public static String getPortletURI(RunData rundata, String portletEntryId) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletEntryId)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", portletList[i].getId()).addPathInfo("js_peid", entries[j].getId()).addQueryData("action", "controls.Maximize");
                    return duri.toString();
                }
            }
        }
        catch (Exception ex) {
            logger.error("Exception", ex);
            return null;
        }
        return null;
    }

    public static String getPortletURItoTopPage(RunData rundata, String portletEntryId) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletEntryId)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", portletList[i].getId()).addQueryData("action", "controls.Restore");
                    return duri.toString();
                }
            }
        }
        catch (Exception ex) {
            logger.error("Exception", ex);
            return null;
        }
        return null;
    }

    public static String replaceStrToLink(String msg) {
        if (msg != null) {
            String newMsg = msg.replaceAll("(https?|ftp|gopher|telnet|whois|news)\\:([\\w|\\:\\!\\#\\$\\%\\=\\&\\-\\^\\`\\\\|\\@\\~\\[\\{\\]\\}\\;\\+\\*\\,\\.\\?\\/]+)", "<a href=\"$1\\:$2\" target=\"_blank\">$1\\:$2</a>");
            return newMsg.replaceAll("[\\w\\.\\-]+@([\\w\\-]+\\.)+[\\w\\-]+", "<a href='mailto:$0'>$0</a>");
        }
        return "";
    }

    public static boolean deleteOldFolder(File parent_folder, Calendar cal) {
        Calendar mod = Calendar.getInstance();
        boolean flag = true;
        try {
            if (!parent_folder.exists()) {
                return false;
            }
            if (parent_folder.isFile()) {
                return false;
            }
            String[] folders_path = parent_folder.list();
            if (folders_path.length == 0) {
                return true;
            }
            int length = folders_path.length;
            for (int i = 0; i < length; ++i) {
                File folder = new File(parent_folder.getAbsolutePath() + File.separator + folders_path[i]);
                mod.setTimeInMillis(folder.lastModified());
                if (folder.isDirectory()) {
                    if (!ALEipUtils.deleteOldFolder(folder, cal)) {
                        flag = false;
                        continue;
                    }
                    if (!mod.before(cal) || folder.delete()) continue;
                    flag = false;
                    continue;
                }
                if (mod.before(cal)) {
                    if (folder.delete()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            }
        }
        catch (Exception e) {
            logger.error(e);
            return false;
        }
        return flag;
    }

    public static boolean deleteFolder(File parent_folder) {
        boolean flag = true;
        try {
            String[] folders_path;
            if (!parent_folder.exists()) {
                return false;
            }
            if (parent_folder.isFile() && !parent_folder.delete()) {
                flag = false;
            }
            if ((folders_path = parent_folder.list()).length == 0) {
                return true;
            }
            int length = folders_path.length;
            for (int i = 0; i < length; ++i) {
                File folder = new File(parent_folder.getAbsolutePath() + File.separator + folders_path[i]);
                if (folder.isDirectory()) {
                    if (!ALEipUtils.deleteFolder(folder)) {
                        flag = false;
                        continue;
                    }
                    if (folder.delete()) continue;
                    flag = false;
                    continue;
                }
                if (folder.delete()) continue;
                flag = false;
            }
        }
        catch (Exception e) {
            logger.error(e);
            return false;
        }
        return flag;
    }

    public static ArrayList getPostNameList(int id) {
        SelectQuery query = new SelectQuery(TurbineUserGroupRole.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"turbineUser", (Object)id);
        Expression exp2 = ExpressionFactory.greaterExp((String)"turbineGroup", (Object)3);
        Expression exp3 = ExpressionFactory.matchExp((String)"turbineGroup.ownerId", (Object)1);
        query.setQualifier(exp1);
        query.andQualifier(exp2);
        query.andQualifier(exp3);
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        List list = dataContext.performQuery((Query)query);
        ArrayList<String> postNames = new ArrayList<String>();
        TurbineUserGroupRole ugr = null;
        for (int j = 0; j < list.size(); ++j) {
            ugr = (TurbineUserGroupRole)list.get(j);
            postNames.add(ugr.getTurbineGroup().getGroupAliasName());
        }
        return postNames;
    }

    public static boolean CheckAclPermissionForCustomize(RunData rundata, Context context, int defineAclType) {
        try {
            if (defineAclType == 0) {
                return true;
            }
            boolean hasAuthority = ALEipUtils.getHasAuthority(rundata, context, defineAclType);
            if (!hasAuthority) {
                throw new ALPermissionException();
            }
            return true;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError(rundata);
            return false;
        }
    }

    public static boolean getHasAuthority(RunData rundata, Context context, int defineAclType) {
        String pfeature = "portlet_customize";
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        return aclhandler.hasAuthority(ALEipUtils.getUserId(rundata), pfeature, defineAclType);
    }
}

