/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.util;

import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.util.ALEipUtils;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.cayenne.DataRow;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.Base64;
import org.apache.jetspeed.util.MimeType;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ALCellularUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALCellularUtils.class.getName());

    public static String getCheckValueForCellLogin(String username, String userid) {
        if (username == null || username.length() == 0 || userid == null) {
            return "";
        }
        String marge = username + userid;
        CRC32 crc32 = new CRC32();
        crc32.update(marge.getBytes());
        long value = crc32.getValue();
        String base64value = null;
        try {
            base64value = Base64.encodeAsString(String.valueOf(value));
        }
        catch (Exception e) {
            // empty catch block
        }
        return base64value == null ? "" : base64value.toLowerCase();
    }

    public static String getCellularUid(RunData rundata) {
        CapabilityMap cm;
        MimeType mime;
        String password = "";
        JetspeedRunData data = (JetspeedRunData)rundata;
        String useragent = data.getRequest().getHeader("User-Agent");
        if (useragent != null && useragent.length() > 0 && (mime = (cm = CapabilityMapFactory.getCapabilityMap(useragent = useragent.trim())).getPreferredType()) != null) {
            MediaTypeEntry media = (MediaTypeEntry)Registry.getEntry(Registry.MEDIA_TYPE, cm.getPreferredMediaType());
            if ("docomo_imode".equals(media.getName())) {
                int lastindex = useragent.lastIndexOf("ser");
                if (lastindex >= 0) {
                    password = useragent.substring(lastindex, useragent.length());
                }
            } else if ("docomo_foma".equals(media.getName())) {
                StringTokenizer st = new StringTokenizer(useragent, ";");
                String token = null;
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (!token.startsWith("ser")) continue;
                    password = token.trim();
                    break;
                }
            } else if ("au".equals(media.getName())) {
                int index;
                String header = data.getRequest().getHeader("x-up-subno");
                if (header != null && header.length() > 0 && (index = header.indexOf("_")) >= 0) {
                    password = header.substring(0, index);
                }
            } else if ("vodafone".equals(media.getName())) {
                int index = useragent.indexOf("SN");
                int delta = -1;
                if (useragent.startsWith("J-PHONE/4")) {
                    delta = 10;
                } else if (useragent.startsWith("J-PHONE/5")) {
                    delta = 15;
                } else if (useragent.startsWith("Vodafone")) {
                    delta = 15;
                } else if (useragent.startsWith("SoftBank")) {
                    delta = 15;
                }
                if (index >= 0 && delta > 0) {
                    password = useragent.substring(index, index + 2 + delta);
                }
            }
        }
        return password;
    }

    public static boolean isCellularPhone(RunData data) {
        MediaTypeEntry media;
        String mediatype;
        boolean isCellularPhone = false;
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap(data.getRequest().getHeader("User-Agent"));
        MimeType mime = cm.getPreferredType();
        if (mime != null && ("docomo_imode".equals(mediatype = (media = (MediaTypeEntry)Registry.getEntry(Registry.MEDIA_TYPE, cm.getPreferredMediaType())).getName()) || "docomo_foma".equals(mediatype) || "au".equals(mediatype) || "vodafone".equals(mediatype))) {
            isCellularPhone = true;
        }
        return isCellularPhone;
    }

    public static Object getObjFromDataRow(DataRow dataRow, String key) {
        String lowerKey = key.toLowerCase();
        if (dataRow.containsKey((Object)lowerKey)) {
            return dataRow.get((Object)lowerKey);
        }
        return dataRow.get((Object)key.toUpperCase());
    }

    public static String getCellularUrl(RunData rundata, ALEipUser eipUser) {
        String servlet_name = rundata.getServletConfig().getServletName();
        String key = eipUser.getName().getValue() + "_" + ALCellularUtils.getCheckValueForCellLogin(eipUser.getName().getValue(), eipUser.getUserId().toString());
        EipMCompany record = ALEipUtils.getEipMCompany("1");
        String domain = ALEipUtils.getUrl(record.getIpaddress(), record.getPort(), servlet_name);
        String url = domain != null && domain.length() > 0 ? domain + "?key=" + key : "";
        return url;
    }

    public static String crypt3Des(String key, String plain) throws Exception {
        String KEY_CRPTY_ALGORITHM = "DESede";
        byte[] tripleDesKeyData = new byte[24];
        for (byte tripleDesKeyData[i] : key.getBytes()) {
        }
        SecretKeySpec secretKey = new SecretKeySpec(tripleDesKeyData, KEY_CRPTY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(KEY_CRPTY_ALGORITHM);
        cipher.init(1, secretKey);
        byte[] encryptedMessage = cipher.doFinal(plain.getBytes());
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encodeBuffer(encryptedMessage);
    }

    private static String decrypt3Des(String key, String plain) throws Exception {
        String KEY_CRPTY_ALGORITHM = "DESede";
        byte[] tripleDesKeyData = new byte[24];
        for (byte tripleDesKeyData[i] : key.getBytes()) {
        }
        SecretKeySpec secretKey = new SecretKeySpec(tripleDesKeyData, KEY_CRPTY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(KEY_CRPTY_ALGORITHM);
        cipher.init(2, secretKey);
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] decParam = decoder.decodeBuffer(plain.trim());
        return String.valueOf(cipher.doFinal(decParam));
    }

    public static String getPortletURIForCell(RunData rundata, String portletEntryId) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Entry[] entries = portlets.getEntriesArray();
            if (entries == null || entries.length <= 0) {
                return null;
            }
            int ent_length = entries.length;
            for (int j = 0; j < ent_length; ++j) {
                if (!entries[j].getId().equals(portletEntryId)) continue;
                JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
                DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                duri = duri.addPathInfo("js_peid", entries[j].getId()).addQueryData("action", "controls.Maximize").addQueryData("mode", "list");
                return duri.toString();
            }
        }
        catch (Exception ex) {
            logger.error("Exception", ex);
            return null;
        }
        return null;
    }
}

