/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.util;

import com.aimluck.eip.common.ALCsvAbstractSelectData;
import com.aimluck.eip.common.ALCsvAbstractUploadFormData;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ALCSVUtils {
    public static final String AFTER_BEHAVIOR = "afterbehavior";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALEipUtils.class.getName());
    public static String DB_NAME_POSTGRESQL = "postgresql";

    public static void csvUpload(RunData rundata, Context context, ALAction action, ALCsvAbstractUploadFormData formData) throws Exception {
        formData.doUpdate(action, rundata, context);
        ALEipUtils.setTemp(rundata, context, "page_count", Integer.toString(formData.getPageCount()));
        ALEipUtils.setTemp(rundata, context, "line_count", Integer.toString(formData.getLineCount()));
    }

    public static void makeList(RunData rundata, Context context, ALAction action, ALCsvAbstractSelectData listData) throws Exception {
        listData.setState(0);
        ArrayList sequency = ALCSVUtils.stringToArray(ALEipUtils.getTemp(rundata, context, "sequency"));
        int page_count = Integer.parseInt(ALEipUtils.getTemp(rundata, context, "page_count"));
        int line_count = Integer.parseInt(ALEipUtils.getTemp(rundata, context, "line_count"));
        listData.setSequency(sequency);
        listData.setPageCount(page_count);
        listData.setLineCount(line_count);
        listData.doViewList(action, rundata, context);
        ALEipUtils.setTemp(rundata, context, "line_count", Integer.toString(listData.getLineCount()));
        ALEipUtils.setTemp(rundata, context, "error_count", Integer.toString(listData.getErrorCount()));
    }

    public static void makeErrorList(RunData rundata, Context context, ALAction action, ALCsvAbstractSelectData listData) throws Exception {
        listData.setState(2);
        ArrayList sequency = ALCSVUtils.stringToArray(ALEipUtils.getTemp(rundata, context, "sequency"));
        int page_count = Integer.parseInt(ALEipUtils.getTemp(rundata, context, "page_count"));
        int line_count = Integer.parseInt(ALEipUtils.getTemp(rundata, context, "line_count"));
        listData.setSequency(sequency);
        listData.setPageCount(page_count);
        listData.setLineCount(line_count);
        int error_count = Integer.parseInt(ALEipUtils.getTemp(rundata, context, "error_count"));
        listData.setErrorCount(error_count);
        listData.doViewList(action, rundata, context);
    }

    public static void makeListPage(RunData rundata, Context context, ALAction action, ALCsvAbstractSelectData listData) throws Exception {
        ArrayList sequency = ALCSVUtils.stringToArray(ALEipUtils.getTemp(rundata, context, "sequency"));
        int page_count = Integer.parseInt(ALEipUtils.getTemp(rundata, context, "page_count"));
        int line_count = Integer.parseInt(ALEipUtils.getTemp(rundata, context, "line_count"));
        listData.setSequency(sequency);
        listData.setPageCount(page_count);
        listData.setLineCount(line_count);
        int error_count = Integer.parseInt(ALEipUtils.getTemp(rundata, context, "error_count"));
        listData.setErrorCount(error_count);
        listData.setState(1);
        listData.doViewList(action, rundata, context);
    }

    public static void setSequency(RunData rundata, Context context, ArrayList arg) {
        ALEipUtils.setTemp(rundata, context, "sequency", ALCSVUtils.arrayToString(arg));
    }

    public static ArrayList getSequency(RunData rundata, Context context) {
        return ALCSVUtils.stringToArray(ALEipUtils.getTemp(rundata, context, "sequency"));
    }

    private static String arrayToString(ArrayList arg) {
        String str = "";
        for (int i = 0; i < arg.size(); ++i) {
            if (i != 0) {
                str = str + ",";
            }
            str = str + arg.get(i).toString();
        }
        return str;
    }

    private static ArrayList stringToArray(String str) {
        try {
            ArrayList<String> arg = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                arg.add(st.nextToken());
            }
            return arg;
        }
        catch (Exception e) {
            return null;
        }
    }
}

