/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.security;

import com.aimluck.eip.cayenne.om.security.TurbinePermission;
import com.aimluck.eip.cayenne.om.security.TurbineRolePermission;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.JetspeedSecurityCache;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.PermissionException;
import org.apache.jetspeed.services.security.PermissionManagement;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class ALPermissionManagement
extends TurbineBaseService
implements PermissionManagement {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALPermissionManagement.class.getName());
    private JetspeedRunDataService runDataService = null;
    private static final String CASCADE_DELETE = "programmatic.cascade.delete";
    private static final boolean DEFAULT_CASCADE_DELETE = true;
    private static final String CONFIG_SYSTEM_PERMISSIONS = "system.permissions";
    private boolean cascadeDelete;
    private static final String CACHING_ENABLE = "caching.enable";
    private boolean cachingEnable = true;
    private Vector systemPermissions = null;

    public Iterator getPermissions(String rolename) throws JetspeedSecurityException {
        HashMap<String, Object> perms;
        Role role = null;
        try {
            Iterator iterator;
            if (this.cachingEnable && (iterator = JetspeedSecurityCache.getPermissions(rolename)) != null) {
                return iterator;
            }
            role = JetspeedSecurity.getRole(rolename);
        }
        catch (JetspeedSecurityException e) {
            logger.error("Failed to Retrieve Role: ", (Throwable)((Object)e));
            throw new PermissionException("Failed to Retrieve Role: ", (Throwable)((Object)e));
        }
        try {
            Expression exp = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(role.getId()));
            SelectQuery query = new SelectQuery(TurbineRolePermission.class, exp);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            List rels = dataContext.performQuery((Query)query);
            perms = rels.size() > 0 ? new HashMap(rels.size()) : new HashMap<String, TurbinePermission>();
            for (int ix = 0; ix < rels.size(); ++ix) {
                TurbineRolePermission rel = (TurbineRolePermission)rels.get(ix);
                TurbinePermission perm = rel.getTurbinePermission();
                perms.put(perm.getName(), perm);
            }
        }
        catch (Exception e) {
            logger.error("Failed to retrieve permissions ", e);
            throw new PermissionException("Failed to retrieve permissions ", e);
        }
        return perms.values().iterator();
    }

    public Iterator getPermissions() throws JetspeedSecurityException {
        List permissions;
        try {
            SelectQuery query = new SelectQuery(TurbinePermission.class);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            permissions = dataContext.performQuery((Query)query);
        }
        catch (Exception e) {
            logger.error("Failed to retrieve permissions ", e);
            throw new PermissionException("Failed to retrieve permissions ", e);
        }
        return permissions.iterator();
    }

    public void addPermission(Permission permission) throws JetspeedSecurityException {
        if (this.permissionExists(permission.getName())) {
            throw new PermissionException("The permission '" + permission.getName() + "' already exists");
        }
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            TurbinePermission tpermission = (TurbinePermission)dataContext.createAndRegisterNewObject(TurbinePermission.class);
            tpermission.setName(permission.getName());
            tpermission.setOBJECTDATA(null);
            dataContext.commitChanges();
        }
        catch (Exception e) {
            String message = "Failed to create permission '" + permission.getName() + "'";
            logger.error(message, e);
            throw new PermissionException(message, e);
        }
    }

    public void savePermission(Permission permission) throws JetspeedSecurityException {
        if (!this.permissionExists(permission.getName())) {
            throw new PermissionException("The permission '" + permission.getName() + "' doesn't exists");
        }
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            if (!(permission instanceof TurbinePermission)) {
                throw new PermissionException("TurbinePermissionManagment: Permission is not a Turbine permission, cannot update");
            }
            dataContext.commitChanges();
        }
        catch (Exception e) {
            String message = "Failed to create permission '" + permission.getName() + "'";
            logger.error(message, e);
            throw new PermissionException(message, e);
        }
    }

    public void removePermission(String permissionName) throws JetspeedSecurityException {
        try {
            if (this.systemPermissions.contains(permissionName)) {
                throw new PermissionException("[" + permissionName + "] is a system permission and cannot be removed");
            }
            Permission permission = this.getPermission(permissionName);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            if (this.cascadeDelete) {
                Expression exp = ExpressionFactory.matchDbExp((String)"PERMISSION_ID", (Object)Integer.valueOf(permission.getId()));
                SelectQuery query = new SelectQuery(TurbineRolePermission.class, exp);
                List rolepermissions = dataContext.performQuery((Query)query);
                dataContext.deleteObjects((Collection)rolepermissions);
            }
            dataContext.deleteObject((Persistent)((TurbineRolePermission)permission));
            dataContext.commitChanges();
            if (this.cachingEnable) {
                JetspeedSecurityCache.removeAllPermissions(permissionName);
            }
        }
        catch (Exception e) {
            String message = "Failed to remove permission '" + permissionName + "'";
            logger.error(message, e);
            throw new PermissionException(message, e);
        }
    }

    public void grantPermission(String roleName, String permissionName) throws JetspeedSecurityException {
        try {
            Role role = JetspeedSecurity.getRole(roleName);
            Permission permission = this.getPermission(permissionName);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            TurbineRolePermission role_permission = (TurbineRolePermission)dataContext.createAndRegisterNewObject(TurbineRolePermission.class);
            role_permission.setRoleId(Integer.parseInt(role.getId()));
            role_permission.setPermissionId(Integer.parseInt(permission.getId()));
            dataContext.commitChanges();
        }
        catch (Exception e) {
            String message = "Grant permission '" + permissionName + "' to role '" + roleName + "' failed: ";
            logger.error(message, e);
            throw new PermissionException(message, e);
        }
    }

    public void revokePermission(String roleName, String permissionName) throws JetspeedSecurityException {
        try {
            Role role = JetspeedSecurity.getRole(roleName);
            Permission permission = this.getPermission(permissionName);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            Expression exp1 = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(role.getId()));
            Expression exp2 = ExpressionFactory.matchDbExp((String)"PERMISSION_ID", (Object)Integer.valueOf(permission.getId()));
            SelectQuery query = new SelectQuery(TurbineRolePermission.class);
            query.setQualifier(exp1);
            query.andQualifier(exp2);
            List list = dataContext.performQuery((Query)query);
            dataContext.deleteObjects((Collection)list);
            if (this.cachingEnable) {
                JetspeedSecurityCache.removePermission(roleName, permissionName);
            }
        }
        catch (Exception e) {
            String message = "Revoke permission '" + permissionName + "' to role '" + roleName + "' failed: ";
            logger.error(message, e);
            throw new PermissionException(message, e);
        }
    }

    public boolean hasPermission(String roleName, String permissionName) throws JetspeedSecurityException {
        List permissions;
        try {
            if (this.cachingEnable) {
                return JetspeedSecurityCache.hasPermission(roleName, permissionName);
            }
            Role role = JetspeedSecurity.getRole(roleName);
            Permission permission = this.getPermission(permissionName);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            Expression exp1 = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(role.getId()));
            Expression exp2 = ExpressionFactory.matchDbExp((String)"PERMISSION_ID", (Object)Integer.valueOf(permission.getId()));
            SelectQuery query = new SelectQuery(TurbineRolePermission.class);
            query.setQualifier(exp1);
            query.andQualifier(exp2);
            permissions = dataContext.performQuery((Query)query);
        }
        catch (Exception e) {
            String message = "Failed to check permission '" + permissionName + "'";
            logger.error(message, e);
            throw new PermissionException(message, e);
        }
        return permissions.size() > 0;
    }

    public Permission getPermission(String permissionName) throws JetspeedSecurityException {
        List permissions;
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(TurbinePermission.class);
            permissions = dataContext.performQuery((Query)query);
        }
        catch (Exception e) {
            String message = "Failed to retrieve permission '" + permissionName + "'";
            logger.error(message, e);
            throw new PermissionException(message, e);
        }
        if (permissions.size() > 1) {
            throw new PermissionException("Multiple Permissions with same permissionname '" + permissionName + "'");
        }
        if (permissions.size() == 1) {
            TurbinePermission permission = (TurbinePermission)permissions.get(0);
            return permission;
        }
        throw new PermissionException("Unknown permission '" + permissionName + "'");
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected boolean permissionExists(String permissionName) throws PermissionException {
        List permissions;
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            Expression exp = ExpressionFactory.matchExp((String)"permissionName", (Object)permissionName);
            SelectQuery query = new SelectQuery(TurbinePermission.class, exp);
            permissions = dataContext.performQuery((Query)query);
        }
        catch (Exception e) {
            logger.error("Failed to check account's presence", e);
            throw new PermissionException("Failed to check account's presence", e);
        }
        return permissions.size() >= 1;
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.cascadeDelete = serviceConf.getBoolean(CASCADE_DELETE, true);
        this.cachingEnable = serviceConf.getBoolean(CACHING_ENABLE, this.cachingEnable);
        this.systemPermissions = serviceConf.getVector(CONFIG_SYSTEM_PERMISSIONS, new Vector());
        this.setInit(true);
    }
}

