/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.security;

import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineRole;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.GroupException;
import org.apache.jetspeed.services.security.GroupManagement;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.util.RunData;

public class ALGroupManagement
extends TurbineBaseService
implements GroupManagement {
    private JetspeedRunDataService runDataService = null;
    private static final String CONFIG_DEFAULT_ROLE = "role.default";
    private static final String CASCADE_DELETE = "programmatic.cascade.delete";
    private static final boolean DEFAULT_CASCADE_DELETE = true;
    private boolean cascadeDelete;
    protected String defaultRole = "user";

    public void addGroup(Group group) throws JetspeedSecurityException {
        if (this.groupExists(group.getName())) {
            throw new GroupException("The group '" + group.getName() + "' already exists");
        }
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            dataContext.commitChanges();
        }
        catch (Exception e) {
            throw new GroupException("Failed to create group '" + group.getName() + "'", e);
        }
        try {
            this.addDefaultGroupPSML(group);
        }
        catch (Exception e) {
            try {
                this.removeGroup(group.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GroupException("failed to add default PSML for Group resource", e);
        }
    }

    public Iterator getGroups(String username) throws JetspeedSecurityException {
        HashMap<String, Object> groups;
        JetspeedUser user = null;
        try {
            user = JetspeedSecurity.getUser(new UserNamePrincipal(username));
        }
        catch (JetspeedSecurityException e) {
            throw new GroupException("Failed to Retrieve User: ", (Throwable)((Object)e));
        }
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)user.getUserId());
        SelectQuery query = new SelectQuery(TurbineUserGroupRole.class, exp);
        try {
            List rels = dataContext.performQuery((Query)query);
            groups = rels.size() > 0 ? new HashMap(rels.size()) : new HashMap<String, TurbineGroup>();
            for (int ix = 0; ix < rels.size(); ++ix) {
                TurbineUserGroupRole rel = (TurbineUserGroupRole)rels.get(ix);
                TurbineGroup group = rel.getTurbineGroup();
                groups.put(group.getName(), group);
            }
        }
        catch (Exception e) {
            throw new GroupException("Failed to retrieve groups ", e);
        }
        return groups.values().iterator();
    }

    public Iterator getGroups() throws JetspeedSecurityException {
        List groups;
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        try {
            SelectQuery query = new SelectQuery(TurbineGroup.class);
            groups = dataContext.performQuery((Query)query);
        }
        catch (Exception e) {
            throw new GroupException("Failed to retrieve groups ", e);
        }
        return groups.iterator();
    }

    protected void addDefaultGroupPSML(Group group) throws GroupException {
        try {
            String org_id = DatabaseOrmService.getInstance().getOrgId((RunData)this.getRunData());
            JetspeedRunDataService runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
            JetspeedRunData rundata = runDataService.getCurrentRunData();
            Profile profile = Profiler.createProfile();
            profile.setGroup(group);
            profile.setMediaType("html");
            profile.setOrgName(org_id);
            Profiler.createProfile((RunData)rundata, profile);
        }
        catch (ProfileException e) {
            try {
                this.removeGroup(group.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GroupException("Failed to create Group PSML", e);
        }
    }

    public void saveGroup(Group group) throws JetspeedSecurityException {
        if (!this.groupExists(group.getName())) {
            throw new GroupException("The group '" + group.getName() + "' doesn't exists");
        }
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            if (!(group instanceof TurbineGroup)) {
                throw new GroupException("TurbineGroupManagment: Group is not a Turbine group, cannot update");
            }
            dataContext.commitChanges();
        }
        catch (Exception e) {
            throw new GroupException("Failed to create group '" + group.getName() + "'", e);
        }
    }

    public void removeGroup(String groupname) throws JetspeedSecurityException {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            Group group = this.getGroup(groupname);
            if (this.cascadeDelete) {
                Expression exp = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)Integer.valueOf(group.getId()));
                SelectQuery query = new SelectQuery(TurbineUserGroupRole.class, exp);
                List groups = dataContext.performQuery((Query)query);
                dataContext.deleteObjects((Collection)groups);
            }
            dataContext.deleteObject((Persistent)((TurbineGroup)group));
            PsmlManager.removeGroupDocuments(group);
            dataContext.commitChanges();
        }
        catch (Exception e) {
            throw new GroupException("Failed to remove group '" + groupname + "'", e);
        }
    }

    public void joinGroup(String username, String groupname) throws JetspeedSecurityException {
        this.joinGroup(username, groupname, this.defaultRole);
    }

    public void joinGroup(String username, String groupname, String rolename) throws JetspeedSecurityException {
        try {
            JetspeedUser user = JetspeedSecurity.getUser(username);
            Group group = this.getGroup(groupname);
            Role role = JetspeedSecurity.getRole(rolename);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            TurbineUserGroupRole user_group_role = (TurbineUserGroupRole)dataContext.createAndRegisterNewObject(TurbineUserGroupRole.class);
            TurbineUser tuser = (TurbineUser)DataObjectUtils.objectForPK((ObjectContext)dataContext, TurbineUser.class, (Object)Integer.valueOf(user.getUserId()));
            user_group_role.setTurbineUser(tuser);
            user_group_role.setTurbineGroup((TurbineGroup)group);
            user_group_role.setTurbineRole((TurbineRole)role);
            dataContext.commitChanges();
        }
        catch (Exception e) {
            throw new GroupException("Join group '" + groupname + "' to user '" + username + "' failed: ", e);
        }
    }

    public void unjoinGroup(String username, String groupname) throws JetspeedSecurityException {
        this.unjoinGroup(username, groupname, this.defaultRole);
    }

    public void unjoinGroup(String username, String groupname, String rolename) throws JetspeedSecurityException {
        try {
            JetspeedUser user = JetspeedSecurity.getUser(username);
            Group group = this.getGroup(groupname);
            Role role = JetspeedSecurity.getRole(rolename);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            Expression exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(user.getUserId()));
            Expression exp2 = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)Integer.valueOf(group.getId()));
            Expression exp3 = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(role.getId()));
            SelectQuery query = new SelectQuery(TurbineUserGroupRole.class);
            query.setQualifier(exp1);
            query.andQualifier(exp2);
            query.andQualifier(exp3);
            List list = dataContext.performQuery((Query)query);
            dataContext.deleteObjects((Collection)list);
            dataContext.commitChanges();
        }
        catch (Exception e) {
            throw new GroupException("Unjoin group '" + groupname + "' to user '" + username + "' failed: ", e);
        }
    }

    public boolean inGroup(String username, String groupname) throws JetspeedSecurityException {
        List groups;
        try {
            JetspeedUser user = JetspeedSecurity.getUser(username);
            Group group = this.getGroup(groupname);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)user.getUserId());
            Expression exp2 = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)group.getId());
            SelectQuery query = new SelectQuery(TurbineUserGroupRole.class);
            query.setQualifier(exp1);
            query.andQualifier(exp2);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            groups = dataContext.performQuery((Query)query);
        }
        catch (Exception e) {
            throw new GroupException("Failed to check group '" + groupname + "'", e);
        }
        return groups.size() > 0;
    }

    public Group getGroup(String groupname) throws JetspeedSecurityException {
        List groups;
        try {
            Expression exp = ExpressionFactory.matchExp((String)"groupName", (Object)groupname);
            SelectQuery query = new SelectQuery(TurbineGroup.class, exp);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            groups = dataContext.performQuery((Query)query);
        }
        catch (Exception e) {
            throw new GroupException("Failed to retrieve group '" + groupname + "'", e);
        }
        if (groups.size() > 1) {
            throw new GroupException("Multiple Groups with same groupname '" + groupname + "'");
        }
        if (groups.size() == 1) {
            TurbineGroup group = (TurbineGroup)groups.get(0);
            return group;
        }
        throw new GroupException("Unknown group '" + groupname + "'");
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected boolean groupExists(String groupName) throws GroupException {
        List groups;
        try {
            Expression exp = ExpressionFactory.matchExp((String)"groupName", (Object)groupName);
            SelectQuery query = new SelectQuery(TurbineGroup.class, exp);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            groups = dataContext.performQuery((Query)query);
        }
        catch (Exception e) {
            throw new GroupException("Failed to check account's presence", e);
        }
        return groups.size() >= 1;
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.defaultRole = serviceConf.getString(CONFIG_DEFAULT_ROLE, this.defaultRole);
        this.cascadeDelete = serviceConf.getBoolean(CASCADE_DELETE, true);
        this.setInit(true);
    }
}

