/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.daemonfactory;

import java.util.Hashtable;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.daemon.Daemon;
import org.apache.jetspeed.daemon.DaemonConfig;
import org.apache.jetspeed.daemon.DaemonEntry;
import org.apache.jetspeed.daemon.DaemonException;
import org.apache.jetspeed.daemon.DaemonThread;
import org.apache.jetspeed.services.daemonfactory.JetspeedDaemonFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class AipoDaemonFactoryService
extends JetspeedDaemonFactoryService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(AipoDaemonFactoryService.class.getName());
    private Hashtable daemons = new Hashtable();
    private Hashtable threads = new Hashtable();
    protected ServletConfig config = null;

    public synchronized void init(ServletConfig config) {
        this.config = config;
        super.init(config);
    }

    private void start(DaemonEntry entry) {
        logger.info("DaemonFactory:  start(): starting daemon -> " + entry.getName());
        DaemonThread dt = new DaemonThread(entry);
        this.threads.put(entry.getName(), dt);
        dt.start();
    }

    public Daemon getDaemon(DaemonEntry entry) throws DaemonException {
        Daemon daemon = (Daemon)this.daemons.get(entry.getName());
        if (daemon != null) {
            return daemon;
        }
        logger.info("Creating daemon: " + entry.getName());
        try {
            daemon = (Daemon)Class.forName(entry.getClassname()).newInstance();
            DaemonConfig dc = new DaemonConfig();
            daemon.init(dc, entry);
            this.daemons.put(entry.getName(), daemon);
            return daemon;
        }
        catch (ClassNotFoundException e) {
            logger.error("Exception", e);
            throw new DaemonException("daemon not found: " + e.getMessage());
        }
        catch (InstantiationException e) {
            logger.error("Exception", e);
            throw new DaemonException("couldn't instantiate daemon: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            logger.error("Exception", e);
            throw new DaemonException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(DaemonEntry entry) throws DaemonException {
        int status;
        DaemonThread dt = (DaemonThread)this.threads.get(entry.getName());
        if (dt == null) {
            this.start(entry);
            dt = (DaemonThread)this.threads.get(entry.getName());
        }
        if ((status = this.getStatus(entry)) != 3 && status != 0 && dt != null) {
            DaemonThread daemonThread = dt;
            synchronized (daemonThread) {
                dt.notify();
            }
        }
        if (dt != null && !dt.isAlive()) {
            dt.start();
        }
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }
}

