/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.accessctl.empty;

import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class ALEmptyAccessControlHandler
extends ALAccessControlHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALEmptyAccessControlHandler.class.getName());

    public boolean hasAuthority(int userId, String featerName, int aclType) {
        if ("schedule_other".equals(featerName)) {
            boolean updatable = (aclType & 8) == 8;
            boolean deletable = (aclType & 0x10) == 16;
            return !updatable && !deletable;
        }
        return true;
    }

    public List getAcceptUserIdsExceptLoginUser(DataContext dataContext, int uid, String feat, int acl_type) {
        int size;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM TURBINE_USER WHERE ");
        sb.append("USER_ID");
        sb.append(" != ");
        sb.append(Integer.toString(uid));
        String sqlString = sb.toString();
        SQLTemplate query = new SQLTemplate(TurbineUser.class, sqlString, true);
        query.setFetchingDataRows(true);
        List list = dataContext.performQuery((Query)query);
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        if (list == null || (size = list.size()) < 1) {
            return userIds;
        }
        for (int i = 0; i < size; ++i) {
            DataRow raw = (DataRow)list.get(i);
            userIds.add((Integer)ALEipUtils.getObjFromDataRow(raw, "USER_ID"));
        }
        return userIds;
    }

    public List getAcceptUserIdsInListExceptLoginUser(DataContext dataContext, int uid, String feat, int acl_type, List ulist) {
        int size;
        int u_size;
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        if (ulist == null || (u_size = ulist.size()) < 1) {
            return userIds;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM TURBINE_USER WHERE (");
        sb.append("USER_ID");
        sb.append(" in (");
        for (int i = 0; i < u_size; ++i) {
            ALEipUser member = (ALEipUser)ulist.get(i);
            sb.append(Long.toString(member.getUserId().getValue()));
            if (i + 1 >= u_size) continue;
            sb.append(",");
        }
        sb.append(")) AND (");
        sb.append("USER_ID");
        sb.append(" != ");
        sb.append(Integer.toString(uid));
        sb.append(")");
        String sqlString = sb.toString();
        SQLTemplate query = new SQLTemplate(TurbineUser.class, sqlString, true);
        query.setFetchingDataRows(true);
        List list = dataContext.performQuery((Query)query);
        if (list == null || (size = list.size()) < 1) {
            return userIds;
        }
        for (int i = 0; i < size; ++i) {
            DataRow raw = (DataRow)list.get(i);
            userIds.add((Integer)ALEipUtils.getObjFromDataRow(raw, "USER_ID"));
        }
        return userIds;
    }

    public List getAuthorityUsersFromGroup(RunData rundata, String feat, String groupname, boolean includeLoginuser) {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION ");
        statement.append("FROM TURBINE_USER_GROUP_ROLE as A ");
        statement.append("LEFT JOIN TURBINE_USER as B ");
        statement.append("on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN TURBINE_GROUP as C ");
        statement.append("on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN EIP_M_USER_POSITION as D ");
        statement.append("on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.DISABLED = 'F'");
        statement.append(" AND C.GROUP_NAME = '").append(groupname).append("' ");
        statement.append("ORDER BY D.POSITION");
        String merged2 = statement.toString();
        SQLTemplate stemp = new SQLTemplate(TurbineUser.class, merged2);
        stemp.setFetchingDataRows(true);
        List ulist = dataContext.performQuery((Query)stemp);
        return ulist;
    }

    public void insertDefaultRole(int uid) throws Exception {
    }
}

